/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.ActionFactory;
import de.bos_bremen.ecard.client.action.SelectTargetFolderHandler;
import de.bos_bremen.ecard.client.control.step.AbstractSelectTargetDir;
import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CuttingLabel;
import de.bos_bremen.ecard.client.gui.view.component.DescriptionPanel;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepHandler;
import de.bos_bremen.ecard.client.gui.view.component.SkipStepPanel;
import de.bos_bremen.ecard.client.gui.view.component.buttons.CurvedToggleIconButton;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSelectTargetDirView
extends JPanel
implements StepChangedListener,
SelectTargetFolderHandler,
SkipStepHandler {
    private static final String TARGETFOLDER = "/targetfolder";
    private static final String LOCALCOPYFOLDER = "/localcopyfolder";
    private static final Logger LOG = LogManager.getLogger(AbstractSelectTargetDirView.class);
    private static final long serialVersionUID = 1L;
    private static final String ACTION_SELECTTARGETFOLDER = "action.selecttargetfolder";
    protected transient AbstractSelectTargetDir step;
    protected CurvedToggleIconButton selectSameAsSourceButton;
    private CurvedToggleIconButton selectSpecialFolderButton;
    private CuttingLabel specialFolderLabel;
    private CurvedToggleIconButton selectLocalCopyFolderButton;
    private CurvedToggleIconButton deleteLocalCopyFolderButton;
    private CuttingLabel localCopyFolderLabel;
    private SkipStepPanel skipStepPanel;
    private final String componentKey;

    protected AbstractSelectTargetDirView(AbstractSelectTargetDir selectTargetDirStep) {
        this.step = selectTargetDirStep;
        this.componentKey = "step." + this.step.getStepName();
        this.createComponents();
        this.initGUI();
        this.step.addStateChangeListener(this);
    }

    protected void createComponents() {
        this.selectSpecialFolderButton = new CurvedToggleIconButton(ACTION_SELECTTARGETFOLDER);
        ActionFactory actionFactory = Document.getInstance().getActionFactory();
        this.selectSpecialFolderButton.setAction(actionFactory.createSelectTargetFolder(this, ACTION_SELECTTARGETFOLDER));
        this.selectSpecialFolderButton.setFocusTraversalKeysEnabled(false);
        this.selectSpecialFolderButton.addKeyListener(this.createKeyAdapterFor(this.selectSpecialFolderButton));
        String mnemonic = Messages.getResource("action.selecttargetfolder.mnemonic");
        KeyStroke ks = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
        int condition = 2;
        this.selectSpecialFolderButton.getInputMap(condition).put(ks, "selectNew");
        this.selectSpecialFolderButton.getActionMap().put("selectNew", new SelectSpecialFolderButtonAction());
        this.selectSameAsSourceButton = new CurvedToggleIconButton("action.selecttargetfoldersameassource");
        this.selectSameAsSourceButton.setAction(actionFactory.createSelectTargetFolderSameAsSource(this, "action.selecttargetfoldersameassource"));
        this.selectSameAsSourceButton.setFocusTraversalKeysEnabled(false);
        this.selectSameAsSourceButton.addKeyListener(this.createKeyAdapterFor(this.selectSameAsSourceButton));
        mnemonic = Messages.getResource("action.selecttargetfoldersameassource.mnemonic");
        KeyStroke ks2 = KeyStroke.getKeyStroke("alt " + mnemonic.charAt(0));
        this.selectSameAsSourceButton.getInputMap(condition).put(ks2, "useSame");
        this.selectSameAsSourceButton.getActionMap().put("useSame", new SelectSameAsSourceButtonAction());
        ButtonGroup targetFolderGroup = new ButtonGroup();
        targetFolderGroup.add(this.selectSpecialFolderButton);
        targetFolderGroup.add(this.selectSameAsSourceButton);
        AccessibleJLabel folderLabel = new AccessibleJLabel(Messages.getString(this.componentKey + ".folder") + "   ");
        folderLabel.setHorizontalAlignment(11);
        this.specialFolderLabel = new CuttingLabel();
        this.specialFolderLabel.setCutMode(JComponentUtils.CutMode.MODE_MIDDLE);
        this.specialFolderLabel.setFocusable(false);
        this.selectLocalCopyFolderButton = new CurvedToggleIconButton();
        this.selectLocalCopyFolderButton.setAction(actionFactory.createSelectLocalCopyFolder(this, ACTION_SELECTTARGETFOLDER));
        this.deleteLocalCopyFolderButton = new CurvedToggleIconButton();
        this.deleteLocalCopyFolderButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ImageIcon imageIcon = IconScalingUtils.createMultiResIcon("action.localcopy.icon");
        this.deleteLocalCopyFolderButton.setIcon(imageIcon);
        this.deleteLocalCopyFolderButton.addActionListener(e -> {
            this.setLocalCopyFolder(null);
            this.selectLocalCopyFolderButton.setSelected(false);
            this.deleteLocalCopyFolderButton.setSelected(false);
        });
        this.deleteLocalCopyFolderButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ActionListener[] actionListeners;
                    for (ActionListener actionListener : actionListeners = AbstractSelectTargetDirView.this.deleteLocalCopyFolderButton.getActionListeners()) {
                        actionListener.actionPerformed(null);
                    }
                }
            }
        });
        this.localCopyFolderLabel = new CuttingLabel();
        this.localCopyFolderLabel.setCutMode(JComponentUtils.CutMode.MODE_MIDDLE);
        this.localCopyFolderLabel.setFocusable(false);
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel content = this.createContentPanel();
        DescriptionPanel descPanel = new DescriptionPanel("step." + this.step.getStepName().toString());
        this.add((Component)descPanel, "North");
        this.add((Component)content, "Center");
        this.skipStepPanel = new SkipStepPanel(this);
        this.skipStepPanel.getSkipStep().setSelected(this.isSaveAsStandardProperty());
        this.add((Component)this.skipStepPanel, "South");
        LicenceTyp targetfolderLicenceTyp = Document.getInstance().getProductFunctions().getLicence(this.step.getLicenceTypKey() + TARGETFOLDER);
        if (!targetfolderLicenceTyp.useInProcess()) {
            this.step.setTargetFolderTyp(null);
        }
        targetfolderLicenceTyp = Document.getInstance().getProductFunctions().getLicence(this.step.getLicenceTypKey());
        String type = this.getTargetfolderType();
        if (type == null || TargetFolderType.sameAsSourceFolder.toString().equals(type)) {
            this.selectSameAsSourceButton.setSelected(true);
        } else if (TargetFolderType.oneSpecial.toString().equals(type)) {
            this.selectSpecialFolderButton.setSelected(true);
        }
        this.stateChanged(null);
        JComponentUtils.setLookByLicence(this, targetfolderLicenceTyp);
    }

    protected JPanel createContentPanel() {
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        if (productFunctions.getLicence(this.step.getLicenceTypKey() + TARGETFOLDER).isVisible()) {
            GridBagPanel targetDirContent = this.createTargetDirContentPanel();
            ((JComponent)targetDirContent).setBorder(ComponentUtils.createTitledCurvedBorderForTitle(Messages.getString("step.selecttargetfolder.description.header")));
            targetDirContent.setFocusable(true);
            content.add((Component)targetDirContent, "Center");
        }
        if (productFunctions.getLicence(this.step.getLicenceTypKey() + LOCALCOPYFOLDER).isVisible()) {
            GridBagPanel localCopyContent = this.createLocalCopyContentPanel();
            ((JComponent)localCopyContent).setBorder(ComponentUtils.createTitledCurvedBorderForTitle(Messages.getString("step.selecttargetfolder.localcopy.description.header")));
            if (!productFunctions.getLicence(this.step.getLicenceTypKey() + TARGETFOLDER).isVisible()) {
                content.add((Component)localCopyContent, "Center");
            } else {
                content.add((Component)localCopyContent, "South");
            }
            if (!productFunctions.getLicence(this.step.getLicenceTypKey() + LOCALCOPYFOLDER).useInProcess()) {
                this.selectLocalCopyFolderButton.setEnabled(false);
                this.deleteLocalCopyFolderButton.setEnabled(false);
            }
        }
        return content;
    }

    private GridBagPanel createLocalCopyContentPanel() {
        GridBagPanel content = new GridBagPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        JComponentUtils.setLookByLicence(this.selectLocalCopyFolderButton, productFunctions.getLicence(this.step.getLicenceTypKey() + LOCALCOPYFOLDER), content, gbc);
        gbc.gridx = 3;
        JComponentUtils.setLookByLicence(this.deleteLocalCopyFolderButton, productFunctions.getLicence(this.step.getLicenceTypKey() + LOCALCOPYFOLDER), content, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        JComponentUtils.setLookByLicence(this.localCopyFolderLabel, productFunctions.getLicence(this.step.getLicenceTypKey() + LOCALCOPYFOLDER), content, gbc);
        content.setColumnMinWidth(0, 50);
        content.setColumnMinWidth(2, 50);
        content.setRowMinHeight(0, 20);
        content.setRowMinHeight(2, 10);
        content.setRowMinHeight(4, 10);
        content.setRowMinHeight(5, 20);
        return content;
    }

    private GridBagPanel createTargetDirContentPanel() {
        GridBagPanel content = new GridBagPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        JComponentUtils.setLookByLicence(this.selectSameAsSourceButton, productFunctions.getLicence(this.step.getLicenceTypKey() + TARGETFOLDER), content, gbc);
        gbc.gridy = 3;
        JComponentUtils.setLookByLicence(this.selectSpecialFolderButton, productFunctions.getLicence(this.step.getLicenceTypKey() + TARGETFOLDER), content, gbc);
        gbc.gridy = 5;
        JComponentUtils.setLookByLicence(this.specialFolderLabel, productFunctions.getLicence(this.step.getLicenceTypKey() + TARGETFOLDER), content, gbc);
        content.setColumnMinWidth(0, 50);
        content.setColumnMinWidth(2, 50);
        content.setRowMinHeight(0, 20);
        content.setRowMinHeight(2, 40);
        content.setRowMinHeight(4, 10);
        content.setRowMinHeight(5, 20);
        content.setRowMinHeight(7, 20);
        return content;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.step.getForm() == null) {
            return;
        }
        if (this.step.getTargetFolderTyp() == null) {
            LOG.debug("Kein TargetFolderTyp");
            this.skipStepPanel.stateChanged(null);
            return;
        }
        if (this.step.getTargetFolderTyp() != null) {
            if (event != null) {
                String localCopyTarget = this.step.getLocalCopyFolder();
                this.setLocalCopyFolder(localCopyTarget);
            } else {
                this.selectSpecialFolderButton.setSelected(false);
                this.localCopyFolderLabel.setText(null);
            }
            switch (this.step.getTargetFolderTyp()) {
                case oneSpecial: {
                    String target = this.step.getTargetFolder();
                    if (target == null) break;
                    this.setTargetFolder(target);
                    break;
                }
                default: {
                    this.setSameAsSource();
                }
            }
        }
        this.skipStepPanel.stateChanged(null);
    }

    @Override
    public File getLastFolder() {
        String userHome = System.getProperty("user.home");
        String lastUsedDir = this.step.getApplicationProperties().getProperty("last_folder", null);
        if (lastUsedDir == null) {
            lastUsedDir = userHome;
        }
        return new File(lastUsedDir);
    }

    @Override
    public File getLastLocalCopyFolder() {
        String userHome = System.getProperty("user.home");
        String lastUsedDir = this.step.getApplicationProperties().getProperty("last_localcopy_folder", null);
        if (lastUsedDir == null) {
            lastUsedDir = userHome;
        }
        return new File(lastUsedDir);
    }

    @Override
    public void setTargetFolder(String targetFolderPath) {
        if (targetFolderPath != null) {
            this.step.setTargetFolderTyp(TargetFolderType.oneSpecial);
            this.step.setTargetFolder(targetFolderPath);
            this.step.setApplicationProperty("last_folder", targetFolderPath);
            this.selectSpecialFolderButton.setSelected(true);
            this.specialFolderLabel.setText(targetFolderPath);
            this.selectSpecialFolderButton.setToolTipText(MultiLineTooltips.wrapToolTip(targetFolderPath, 80));
        } else {
            this.stateChanged(null);
            this.selectSpecialFolderButton.setToolTipText(null);
        }
    }

    @Override
    public void setLocalCopyFolder(String localCopyFplder) {
        if (localCopyFplder != null) {
            this.step.setLocalCopyFolder(localCopyFplder);
            this.step.setApplicationProperty("last_localcopy_folder", localCopyFplder);
            this.localCopyFolderLabel.setText(localCopyFplder);
            this.localCopyFolderLabel.setFocusable(true);
        } else {
            this.step.setLocalCopyFolder(null);
            this.localCopyFolderLabel.setFocusable(false);
        }
    }

    @Override
    public void setSameAsSource() {
        this.step.setTargetFolderTyp(TargetFolderType.sameAsSourceFolder);
        this.step.setTargetFolder(null);
        this.specialFolderLabel.setText("");
        this.selectSameAsSourceButton.setSelected(true);
    }

    @Override
    public SkippableStep getSkippableStep() {
        return this.step;
    }

    @Override
    public boolean getSkipStep() {
        return this.step.skipStep();
    }

    @Override
    public void setSkipStep(boolean skip) {
        this.step.skipStep(skip);
    }

    @Override
    public boolean isStepComplete() {
        return this.step.isStateComplete();
    }

    @Override
    public void setActive(boolean active) {
        if (active) {
            LOG.debug("set active {} : {}", (Object)this.step.getParent().getProcessName(), (Object)this.step.getStepName());
            LOG.info("\n------------------------- {}/Zielverzeichnis w\u00e4hlen : ausgew\u00e4hlt ----------------------------", (Object)this.step.getParent().getProcessName());
        } else {
            this.step.setLastSelectedJComponent(null);
        }
    }

    @Override
    public void requestFocus() {
    }

    private boolean isSaveAsStandardProperty() {
        String standard = this.step.getStepProperty("isSaveAsStandardProperty");
        return Boolean.valueOf(standard);
    }

    private String getTargetfolderType() {
        return this.step.getStepProperty("targetfolder.type");
    }

    private KeyListener createKeyAdapterFor(final CurvedToggleIconButton button) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent == null) {
                    return;
                }
                if (keyEvent.isConsumed()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 9: {
                        if (keyEvent.isShiftDown()) {
                            button.getParent().transferFocusBackward();
                            keyEvent.consume();
                            break;
                        }
                        if (AbstractSelectTargetDirView.this.selectSameAsSourceButton.hasFocus()) {
                            AbstractSelectTargetDirView.this.selectSpecialFolderButton.requestFocus();
                            AbstractSelectTargetDirView.this.selectSpecialFolderButton.transferFocus();
                            keyEvent.consume();
                            break;
                        }
                        button.transferFocus();
                        keyEvent.consume();
                        break;
                    }
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        if (AbstractSelectTargetDirView.this.selectSameAsSourceButton.hasFocus()) {
                            AbstractSelectTargetDirView.this.selectSpecialFolderButton.requestFocus();
                            keyEvent.consume();
                            break;
                        }
                        AbstractSelectTargetDirView.this.selectSameAsSourceButton.requestFocus();
                        keyEvent.consume();
                        break;
                    }
                }
            }
        };
    }

    private class SelectSpecialFolderButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractSelectTargetDirView.this.step.setLastSelectedJComponent((JComponent)e.getSource());
            AbstractSelectTargetDirView.this.selectSpecialFolderButton.doClick();
        }
    }

    private class SelectSameAsSourceButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractSelectTargetDirView.this.step.setLastSelectedJComponent((JComponent)e.getSource());
            AbstractSelectTargetDirView.this.selectSameAsSourceButton.doClick();
        }
    }
}

