/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ServerPanel {
    protected static final Logger LOG = LogManager.getLogger(ServerPanel.class);
    protected JPanel content;
    private JTextField serverHost;
    private final LicenceTyp licenceTyp;

    protected ServerPanel(LicenceTyp licencetyp) {
        LOG.trace("");
        this.licenceTyp = licencetyp;
        this.initContent();
        this.initGUI();
    }

    private void initContent() {
        this.content = new JPanel();
        this.content.setLayout(new GridBagLayout());
    }

    protected void initGUI() {
        LOG.trace("");
        this.content = ComponentUtils.setTitledFocusableBorder(this.content, Messages.getString("config.dialog.verificationserver.title"));
        Insets insetsLeft = new Insets(10, 20, 10, 5);
        Insets insetsRight = new Insets(10, 5, 10, 20);
        JLabel servername = new JLabel(Messages.getString("config.dialog.verificationserver.host"));
        this.content.add((Component)servername, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.serverHost = new JTextField();
        this.serverHost.addFocusListener(ComponentUtils.createFocusListenerFor(this.serverHost));
        servername.setLabelFor(this.serverHost);
        this.content.add((Component)this.serverHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        this.addAdditionalContent();
        JComponentUtils.setLookByLicence(this.content, this.licenceTyp);
    }

    protected abstract void addAdditionalContent();

    public JPanel getView() {
        return this.content;
    }

    public String getServerHost() {
        LOG.trace("CVS-View Servername -> {}", (Object)this.serverHost.getText());
        return this.serverHost.getText();
    }

    public void setServerHost(String host) {
        LOG.trace("CVS-View Servername <- {}", (Object)host);
        this.serverHost.setText(host);
    }
}

