/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.textfields.ServerPortTextField;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.util.Entry;
import de.bos_bremen.ecard.client.util.Reg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyServerPanel
extends ConfigComponent {
    private static final String WIN_INTERNET_SETTINGS = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    protected static final Logger LOG = LogManager.getLogger(ProxyServerPanel.class);
    protected static final String COMPONENT_KEY = "proxyserver";
    protected JPanel content;
    private final LicenceTyp licenceTyp;
    private JTextField serverHost;
    private JTextField serverPort;
    private JPasswordField serverPasswd;
    private JTextField serverUser;
    private JTextField nonProxyHosts;
    private JTextField autoConfigUrl;
    private String pServerHost;
    private String pServerUser;
    private char[] pServerPasswd;
    private String pServerPort;
    private JLabel loadSystemProxyFeedback = new JLabel("<html>&nbsp;</html>");

    public ProxyServerPanel(LicenceTyp licenceTyp) {
        this.licenceTyp = licenceTyp;
        this.initContent();
        this.initGUI();
    }

    @Override
    public JPanel getView() {
        return this.content;
    }

    private void initContent() {
        this.content = new JPanel(new GridBagLayout());
    }

    @Override
    protected void initGUI() {
        this.content = ComponentUtils.setTitledFocusableBorder(this.content, Messages.getString("config.dialog.proxyserver.title"));
        Insets insets = new Insets(5, 5, 0, 5);
        Insets insetsLeft = new Insets(5, 20, 0, 5);
        Insets insetsRight = new Insets(5, 5, 0, 20);
        Insets insetsLeftBottom = new Insets(5, 20, 0, 5);
        JLabel description = new JLabel(Messages.getString("config.dialog.proxyserver.message"));
        description.addFocusListener(ComponentUtils.createFocusListenerFor(description));
        description.setFocusable(true);
        int contentRow = 0;
        this.content.add((Component)description, new GridBagConstraints(0, contentRow++, 2, 1, 1.0, 0.0, 17, 2, insetsLeftBottom, 0, 0));
        JPanel proxyEditPanel = new JPanel(new GridBagLayout());
        proxyEditPanel = ComponentUtils.setTitledFocusableBorder(proxyEditPanel, Messages.getString("config.dialog.proxyserver.edit.title"));
        int row = 1;
        JLabel labelFor = new JLabel(Messages.getString("config.dialog.proxyserver.host"));
        proxyEditPanel.add((Component)labelFor, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.serverHost = new JTextField(Config.getInstance().getProxyServer().getProxyHost());
        labelFor.setLabelFor(this.serverHost);
        this.serverHost.addFocusListener(ComponentUtils.createFocusListenerFor(this.serverHost));
        proxyEditPanel.add((Component)this.serverHost, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        labelFor = new JLabel(Messages.getString("config.dialog.proxyserver.port"));
        proxyEditPanel.add((Component)labelFor, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.serverPort = new ServerPortTextField(Config.getInstance().getProxyServer().getProxyPortAsString());
        labelFor.setLabelFor(this.serverPort);
        this.serverPort.addFocusListener(ComponentUtils.createFocusListenerFor(this.serverPort));
        proxyEditPanel.add((Component)this.serverPort, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        labelFor = new JLabel(Messages.getString("config.dialog.proxyserver.user"));
        proxyEditPanel.add((Component)labelFor, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.serverUser = new JTextField(Config.getInstance().getProxyServer().getUsername());
        labelFor.setLabelFor(this.serverUser);
        this.serverUser.addFocusListener(ComponentUtils.createFocusListenerFor(this.serverUser));
        proxyEditPanel.add((Component)this.serverUser, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        labelFor = new JLabel(Messages.getString("config.dialog.proxyserver.password"));
        proxyEditPanel.add((Component)labelFor, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        char[] value = Config.getInstance().getProxyServer().getPasswordAsArray();
        this.serverPasswd = new JPasswordField(value != null ? Arrays.toString(value) : "");
        labelFor.setLabelFor(this.serverPasswd);
        this.serverPasswd.addFocusListener(ComponentUtils.createFocusListenerFor(this.serverPasswd));
        proxyEditPanel.add((Component)this.serverPasswd, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        labelFor = new JLabel(Messages.getString("config.dialog.proxyserver.noproxyhost"));
        proxyEditPanel.add((Component)labelFor, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.nonProxyHosts = new JTextField(Config.getInstance().getProxyServer().getNoProxyHost());
        labelFor.setLabelFor(this.nonProxyHosts);
        this.nonProxyHosts.setToolTipText(MultiLineTooltips.wrapToolTip(Messages.getString("config.dialog.proxyserver.noproxyhost.tooltip")));
        this.nonProxyHosts.addFocusListener(ComponentUtils.createFocusListenerFor(this.nonProxyHosts));
        proxyEditPanel.add((Component)this.nonProxyHosts, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        this.content.add((Component)proxyEditPanel, new GridBagConstraints(0, contentRow++, 2, 1, 0.0, 0.0, 13, 2, insetsLeftBottom, 0, 0));
        JPanel pacEditPanel = new JPanel(new GridBagLayout());
        pacEditPanel = ComponentUtils.setTitledFocusableBorder(pacEditPanel, Messages.getString("config.dialog.proxyserver.autoconfigurl.title"));
        row = 1;
        description = new JLabel("<html>" + Messages.getString("config.dialog.proxyserver.autoconfigurl.description") + "</html>");
        description.addFocusListener(ComponentUtils.createFocusListenerFor(description));
        description.setFocusable(true);
        pacEditPanel.add((Component)description, new GridBagConstraints(0, row, 2, 1, 1.0, 0.0, 17, 2, insetsLeftBottom, 0, 0));
        labelFor = new JLabel(Messages.getString("config.dialog.proxyserver.autoconfigurl"));
        pacEditPanel.add((Component)labelFor, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.autoConfigUrl = new JTextField(Config.getInstance().getProxyServer().getAutoConfigUrl());
        labelFor.setLabelFor(this.autoConfigUrl);
        this.autoConfigUrl.setToolTipText(MultiLineTooltips.wrapToolTip(Messages.getString("config.dialog.proxyserver.autoconfigurl.tooltip")));
        this.autoConfigUrl.addFocusListener(ComponentUtils.createFocusListenerFor(this.autoConfigUrl));
        pacEditPanel.add((Component)this.autoConfigUrl, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 13, 2, insetsRight, 0, 0));
        if (!Config.getInstance().getProxyServer().getAutoConfigUrl().isEmpty()) {
            this.resetExceptCredentials();
        }
        this.content.add((Component)pacEditPanel, new GridBagConstraints(0, contentRow++, 2, 1, 1.0, 0.0, 13, 2, insetsLeftBottom, 0, 0));
        if (this.isVendorWindows()) {
            JPanel systemLoadPanel = new JPanel(new GridBagLayout());
            systemLoadPanel = ComponentUtils.setTitledFocusableBorder(systemLoadPanel, Messages.getString("config.dialog.proxyserver.systemsettings.title"));
            description = new JLabel("<html>" + Messages.getString("config.dialog.proxyserver.systemsettings.description") + "</html>");
            description.addFocusListener(ComponentUtils.createFocusListenerFor(description));
            description.setFocusable(true);
            row = 1;
            systemLoadPanel.add((Component)description, new GridBagConstraints(0, row, 2, 1, 1.0, 0.0, 17, 2, insetsLeftBottom, 0, 0));
            IconButton loadSystemProxyButton = new IconButton("config.dialog.proxyserver.systemsettings");
            loadSystemProxyButton.addActionListener(actionEvent -> this.readSystemProxy());
            InputMap inputMap = loadSystemProxyButton.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(80, 128), "loadSystemProxyAction");
            inputMap = loadSystemProxyButton.getInputMap(0);
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "loadSystemProxyAction");
            ActionMap actionMap = loadSystemProxyButton.getActionMap();
            actionMap.put("loadSystemProxyAction", new LoadSystemProxyAction());
            systemLoadPanel.add((Component)loadSystemProxyButton, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            systemLoadPanel.add((Component)this.loadSystemProxyFeedback, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 10, 2, insetsLeftBottom, 0, 0));
            this.content.add((Component)systemLoadPanel, new GridBagConstraints(0, contentRow, 2, 1, 1.0, 0.0, 17, 2, insetsLeftBottom, 0, 0));
        }
        JComponentUtils.setLookByLicence(this.content, this.licenceTyp);
    }

    @Override
    protected void storeValues() {
        this.pServerHost = this.getServerHost();
        this.pServerPort = this.getServerPort();
        this.pServerUser = this.getServerUser();
        this.pServerPasswd = this.getServerPasswd();
    }

    @Override
    protected void restoreValues() {
        this.setServerHost(this.pServerHost);
        this.setServerPort(this.pServerPort);
        this.setServerUser(this.pServerUser);
        this.setServerPasswd(this.pServerPasswd);
    }

    @Override
    protected JComponent getContentPane() {
        return this.content;
    }

    public String getServerHost() {
        return this.serverHost.getText();
    }

    public void setServerHost(String host) {
        this.serverHost.setText(host);
    }

    public String getServerPort() {
        return this.serverPort.getText();
    }

    public void setServerPort(String port) {
        this.serverPort.setText(port);
    }

    public String getServerUser() {
        if (this.serverUser != null) {
            return this.serverUser.getText();
        }
        return null;
    }

    public void setServerUser(String user) {
        if (this.serverUser != null) {
            this.serverUser.setText(user != null ? user : "");
        }
    }

    public char[] getServerPasswd() {
        if (this.serverPasswd != null) {
            return this.serverPasswd.getPassword();
        }
        return null;
    }

    public void setServerPasswd(char[] passwd) {
        if (this.serverPasswd != null) {
            if (passwd != null) {
                this.serverPasswd.setText(new String(passwd));
            } else {
                this.serverPasswd.setText(null);
            }
        }
    }

    public String getNonProxyHosts() {
        if (this.nonProxyHosts != null) {
            return this.nonProxyHosts.getText();
        }
        return null;
    }

    public void setNonProxyHosts(String nonproxyHosts) {
        if (this.nonProxyHosts != null) {
            this.nonProxyHosts.setText(nonproxyHosts != null ? nonproxyHosts : "");
        }
    }

    public void setAutoConfigUrl(String autoConfigUrlText) {
        if (autoConfigUrlText != null && !autoConfigUrlText.isEmpty()) {
            this.resetExceptCredentials();
        }
        this.autoConfigUrl.setText(autoConfigUrlText);
    }

    public String getAutoConfigUrl() {
        return this.autoConfigUrl.getText();
    }

    private boolean isVendorWindows() {
        String property = System.getProperty("os.name");
        return property.toLowerCase().contains("windows");
    }

    public void readSystemProxy() {
        LOG.info("read system proxy");
        String regPath = WIN_INTERNET_SETTINGS;
        String key = "AutoConfigURL";
        try {
            LOG.info("PAC check ...");
            List<Entry> pacEntries = Reg.query(regPath, key);
            String path = pacEntries != null && !pacEntries.isEmpty() ? (String)pacEntries.get((int)0).value : null;
            LOG.info("PAC: {}", path);
            if (path != null) {
                this.reset();
                this.autoConfigUrl.setText(path);
                System.setProperty("http.proxy.auto.config", path);
                LOG.trace("set System http.proxy.auto.config : {}", (Object)System.getProperty("http.proxy.auto.config", null));
                return;
            }
            this.autoConfigUrl.setText("");
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            this.autoConfigUrl.setText("");
        }
        try {
            LOG.info("Proxy check ...");
            key = "ProxyEnable";
            List<Entry> entry = Reg.query(regPath, key);
            if ((Long)entry.get((int)0).value != 1L) {
                this.reset();
                LOG.info("Proxy ist in Registry nicht freigeschaltet.");
                this.loadSystemProxyFeedback.setText(Messages.getString("config.dialog.proxyserver.systemsettings.noproxy"));
                this.loadSystemProxyFeedback.setFocusable(true);
                this.loadSystemProxyFeedback.addFocusListener(ComponentUtils.createFocusListenerFor(this.loadSystemProxyFeedback));
                this.loadSystemProxyFeedback.requestFocus();
                return;
            }
            key = "ProxyServer";
            entry = Reg.query(regPath, key);
            if ((String)entry.get((int)0).value == null) {
                this.reset();
                LOG.info("Proxyserver ist in Registry nicht konfiguriert.");
                this.loadSystemProxyFeedback.setText(Messages.getString("config.dialog.proxyserver.systemsettings.noproxy"));
                this.loadSystemProxyFeedback.setFocusable(true);
                this.loadSystemProxyFeedback.requestFocus();
                return;
            }
            String proxyHost = (String)entry.get((int)0).value;
            for (String token : proxyHost.split(";")) {
                if (!token.startsWith("http=")) continue;
                this.setServerHost(token.substring("http=".length()));
                break;
            }
            String[] split = proxyHost.split(":");
            this.setServerHost(split[0]);
            if (split.length > 1) {
                this.serverPort.setText(split[1]);
            }
            key = "ProxyOverride";
            try {
                entry = Reg.query(regPath, key);
                this.nonProxyHosts.setText((String)entry.get((int)0).value);
            }
            catch (IOException ioex) {
                this.nonProxyHosts.setText("");
            }
            this.setServerUser("");
            this.setServerPasswd("".toCharArray());
            this.setEditable(true);
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    private void reset() {
        LOG.trace("");
        this.setServerHost("");
        this.setServerPort("");
        this.setServerUser("");
        this.setServerPasswd("".toCharArray());
        this.setNonProxyHosts("");
    }

    private void resetExceptCredentials() {
        this.setServerHost("");
        this.setServerPort("");
        this.setNonProxyHosts("");
    }

    private void setEditable(boolean editable) {
        this.serverHost.setEditable(editable);
        this.serverPort.setEditable(editable);
        this.serverUser.setEditable(editable);
        this.serverPasswd.setEditable(editable);
        this.nonProxyHosts.setEditable(editable);
    }

    private class LoadSystemProxyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private LoadSystemProxyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProxyServerPanel.this.readSystemProxy();
        }
    }
}

