/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config.components;

import de.bos_bremen.debug_mode.DebugLevel;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.textfields.TargetFileTextField;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LoggingPanel
extends ConfigComponent
implements SelectedFileHandler,
ChangeListener {
    JCheckBox loggingCheckBox;
    IconButton bntChooseLogging;
    private final JTextField tfTarget = new TargetFileTextField(200);
    private JPanel content;
    private String tmpTargetFile;
    private boolean tmpUseLogging;

    public LoggingPanel() {
        this.initContent();
        this.initGUI();
        this.stateChanged(null);
    }

    private void initContent() {
        this.content = new JPanel(new GridBagLayout());
    }

    @Override
    public void initGUI() {
        this.content = ComponentUtils.setTitledFocusableBorder(this.content, Messages.getString("config.dialog.logging.title"));
        this.loggingCheckBox = new JCheckBox(Messages.getString("config.dialog.logging.checkbox.label"));
        String wrappedTooltipText = MultiLineTooltips.wrapToolTip(Messages.getString("config.dialog.logging.checkbox.tooltip"));
        this.loggingCheckBox.setToolTipText(wrappedTooltipText);
        JPanel loggingCheckBoxPanel = ComponentUtils.layoutCheckbox(this.loggingCheckBox);
        this.content.add((Component)loggingCheckBoxPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 23, 0, new Insets(5, 15, 5, 5), 0, 0));
        JLabel chooseLoggingLabel = new JLabel(Messages.getString("config.dialog.logging.dir.label"));
        String wrappedTooltip = MultiLineTooltips.wrapToolTip(Messages.getString("config.dialog.logging.dir.tooltip"));
        chooseLoggingLabel.setToolTipText(wrappedTooltip);
        chooseLoggingLabel.setLabelFor(this.tfTarget);
        this.content.add((Component)chooseLoggingLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 21, 0, new Insets(5, 20, 5, 5), 0, 0));
        this.tfTarget.setFont(UIManager.getFont("Label.font"));
        this.tfTarget.setMinimumSize(new Dimension(400, (int)this.tfTarget.getPreferredSize().getHeight()));
        this.content.add((Component)this.tfTarget, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.bntChooseLogging = new IconButton();
        this.bntChooseLogging.setAction(Document.getInstance().getActionFactory().createSelectFile(this, "action.logging.button.choose", 1, false, false));
        this.bntChooseLogging.setFocusPainted(true);
        this.bntChooseLogging.setVerticalTextPosition(0);
        this.bntChooseLogging.setHorizontalTextPosition(11);
        this.content.add((Component)this.bntChooseLogging, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.loggingCheckBox.addChangeListener(evt -> {
            if (evt != null && evt.getSource().equals(this.loggingCheckBox) && Document.getInstance().getProductFunctions().enableGeneralActionsSettingsProtocol().isEditable()) {
                this.bntChooseLogging.setEnabled(this.loggingCheckBox.isSelected());
                this.tfTarget.setEnabled(this.loggingCheckBox.isSelected());
            }
        });
    }

    public String getProtocolFile() {
        return this.tfTarget.getText();
    }

    public void setProtocolFile(String protocolFile) {
        this.tfTarget.setText(protocolFile);
        this.tfTarget.setToolTipText(protocolFile);
    }

    public DebugLevel getProtocolLevel() {
        if (this.loggingCheckBox.isSelected()) {
            return DebugLevel.debug;
        }
        return DebugLevel.none;
    }

    public void setProtocolLevel(DebugLevel level) {
        switch (level) {
            case error: 
            case warning: 
            case info: 
            case debug: {
                this.loggingCheckBox.setSelected(true);
                break;
            }
            default: {
                this.loggingCheckBox.setSelected(false);
            }
        }
    }

    @Override
    public JComponent getView() {
        return this.content;
    }

    @Override
    public File getLastFolder() {
        File tempFile;
        if (this.tfTarget.getText() != null && (tempFile = new File(this.tfTarget.getText())).getParentFile() != null && tempFile.getParentFile().exists()) {
            return tempFile.getParentFile();
        }
        return null;
    }

    @Override
    public void setFileToLoad(File fileToLoad) {
        if (fileToLoad == null) {
            return;
        }
        if (!fileToLoad.exists()) {
            try {
                fileToLoad.mkdir();
            }
            catch (Exception e) {
                Document.getInstance().reportError(ErrorCode.OUTPUT_DIR_NOT_FOUND, false, fileToLoad);
                String protocollFile = Config.getInstance().getProtocolFile();
                this.tfTarget.setText(protocollFile);
                this.tfTarget.setToolTipText(protocollFile);
                return;
            }
        }
        this.tfTarget.setText(fileToLoad.getAbsolutePath());
        this.tfTarget.setToolTipText(fileToLoad.getAbsolutePath());
    }

    @Override
    public void setFilesToLoad(File[] files) {
    }

    public void useLogging(boolean loggingEnabled) {
        this.loggingCheckBox.setSelected(loggingEnabled);
    }

    public boolean useLogging() {
        return this.loggingCheckBox.isSelected();
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.bntChooseLogging.setEnabled(this.loggingCheckBox.isSelected());
        this.tfTarget.setEnabled(this.loggingCheckBox.isSelected());
    }

    @Override
    protected JComponent getContentPane() {
        return this.content;
    }

    @Override
    protected void restoreValues() {
        this.loggingCheckBox.setSelected(this.tmpUseLogging);
        this.tfTarget.setText(this.tmpTargetFile);
        this.tfTarget.setToolTipText(this.tmpTargetFile);
    }

    @Override
    protected void storeValues() {
        this.tmpUseLogging = this.loggingCheckBox.isSelected();
        this.tmpTargetFile = this.tfTarget.getText();
    }
}

