/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config.components;

import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.TitledCurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.table.renderer.LocaleRenderer;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LanguagePanel
extends ConfigComponent {
    protected static final String COMPONENT_KEY = "language";
    private JPanel content;
    private JComboBox<Locale> locales;
    private final Vector<Locale> localesVector = new Vector();
    Locale tmpLocale = null;

    public LanguagePanel() {
        this.initContent();
        this.initGUI();
    }

    private void initContent() {
        this.content = new JPanel();
        this.content.setLayout(new GridBagLayout());
        this.localesVector.clear();
        this.localesVector.add(Locale.GERMAN);
        this.localesVector.add(Locale.ENGLISH);
        this.locales = new JComboBox<Locale>(this.localesVector);
        this.locales.setRenderer(new LocaleRenderer());
        this.locales.addActionListener(evt -> {
            if (evt != null) {
                JComboBox jcb = (JComboBox)evt.getSource();
                Locale locale = (Locale)jcb.getSelectedItem();
                this.setLocale(locale);
            }
        });
    }

    @Override
    protected void initGUI() {
        TitledCurvedBorder generalBorder = ComponentUtils.createTitledCurvedBorder(COMPONENT_KEY);
        this.content.setBorder(generalBorder);
        ComponentUtils.createComponent(this.content, this.locales, COMPONENT_KEY);
        this.locales.setSelectedItem(LocaleChanger.getInstance().getActualLocale());
    }

    public Locale getLocale() {
        return (Locale)this.locales.getSelectedItem();
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locales.setSelectedItem(locale);
            LocaleChanger.getInstance().setLocale(locale, false);
        }
    }

    @Override
    public JComponent getView() {
        return this.content;
    }

    @Override
    protected JComponent getContentPane() {
        return this.content;
    }

    @Override
    protected void restoreValues() {
        if (this.tmpLocale != null) {
            this.locales.setSelectedItem(this.tmpLocale);
        }
        this.tmpLocale = null;
    }

    @Override
    protected void storeValues() {
        this.tmpLocale = (Locale)this.locales.getSelectedItem();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getContentPane().removeAll();
        this.initGUI();
        this.locales.setSelectedItem(LocaleChanger.getInstance().getActualLocale());
        this.getContentPane().revalidate();
    }
}

