/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SubsequentProcessDialog
extends JDialog
implements SelectedFileHandler {
    protected static final String COMPONENT_KEY = "subsequentprocess";
    int status = 2;
    private static final long serialVersionUID = 1L;
    private JTextField process;
    private IconButton searchProcessButton;
    private JTextField param;
    private final HashMap<ProcessName, JCheckBox> defaultProcess = new HashMap();
    private IconButton okButton;
    private IconButton cancelButton;
    private final JFrame frame;
    private SetDefaultsPanel defaultsPanel;
    private final String processUID;

    public SubsequentProcessDialog(JFrame parentFrame, SubsequentProcess subProcess, String uID) {
        super((Frame)parentFrame, true);
        this.frame = parentFrame;
        this.processUID = uID;
        this.setTitle(Messages.getString("config.dialog.subsequentprocess.add.change.title"));
        this.initComponents();
        if (subProcess != null) {
            this.process.setText(subProcess.getProcess());
            this.param.setText(subProcess.getDefaultProcessParam());
            List<ProcessI> processes = Document.getInstance().getProcessFactory().getProcesses();
            for (int i = 0; i < processes.size(); ++i) {
                ProcessI processI = processes.get(i);
                if (processI.getProcessName().getProcessIndex() >= 4) continue;
                this.defaultProcess.get(processI.getProcessName()).setSelected(uID.equals(processI.getSubsequentProcessUID()));
            }
        }
        Dimension parentDimension = this.frame.getMinimumSize() == null ? this.frame.getSize() : this.frame.getMinimumSize();
        this.setMinimumSize(GUIUtils.createRelativeToParent(parentDimension, 0.9, 0.45));
        this.setSize(GUIUtils.createRelativeToParent(parentDimension, 0.9, 0.45));
        this.setResizable(true);
        this.setLocationRelativeTo(this.frame);
    }

    private void initComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        panel = ComponentUtils.setTitledFocusableBorder(panel, Messages.getString("config.dialog.subsequentprocess.title"));
        this.getContentPane().add(panel);
        panel.add((Component)this.buildCenterPanel(), "North");
        panel.add((Component)this.buildButtonPanel(), "South");
    }

    private JComponent buildCenterPanel() {
        this.process = new JTextField();
        this.process.addFocusListener(ComponentUtils.createFocusListenerFor(this.process));
        this.param = new JTextField();
        this.param.addFocusListener(ComponentUtils.createFocusListenerFor(this.param));
        this.searchProcessButton = new IconButton();
        this.searchProcessButton.setAction(Document.getInstance().getActionFactory().createSelectProcess(this));
        this.defaultsPanel = new SetDefaultsPanel();
        SetApplicationPanel applicationPanel = new SetApplicationPanel();
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout());
        center.add((Component)applicationPanel, "Center");
        return center;
    }

    protected JComponent buildButtonPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        contentPanel.add((Component)buttonPanel, "Center");
        buttonPanel.setLayout(new FlowLayout(1));
        this.okButton = new IconButton("config.dialog.subsequentprocess.option0");
        this.okButton.addActionListener(e -> {
            if (!this.isProcessChoosed()) {
                Document.getInstance().showMessageDialogText(this.frame, Messages.getString("config.dialog.subsequentprocess.nosubsequentprocess"));
                return;
            }
            this.status = 0;
            Set<Map.Entry<ProcessName, JCheckBox>> entrySet = this.defaultProcess.entrySet();
            for (Map.Entry<ProcessName, JCheckBox> entry : entrySet) {
                ProcessI process2 = Document.getInstance().getProcessFactory().getProcess(entry.getKey());
                if (entry.getValue().isSelected()) {
                    if (process2.getProcessName().getProcessIndex() >= 4) continue;
                    process2.setSubsequentProcessUID(this.processUID);
                    continue;
                }
                if (process2.getSubsequentProcessUID() == null || !process2.getSubsequentProcessUID().equals(this.processUID)) continue;
                process2.setSubsequentProcessUID(null);
            }
            this.setVisible(false);
        });
        buttonPanel.add(this.okButton);
        OkAction okAction = new OkAction();
        InputMap inputMap = this.okButton.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "okAction");
        ActionMap actionMap = this.okButton.getActionMap();
        actionMap.put("okAction", okAction);
        inputMap = this.okButton.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "okAction");
        this.cancelButton = new IconButton("config.dialog.subsequentprocess.option1");
        this.cancelButton.addActionListener(e -> {
            this.status = 2;
            this.setVisible(false);
        });
        buttonPanel.add(this.cancelButton);
        CancelAction cancelAction = new CancelAction();
        inputMap = this.cancelButton.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelAction");
        actionMap = this.cancelButton.getActionMap();
        actionMap.put("cancelAction", cancelAction);
        inputMap = this.cancelButton.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "cancelAction");
        return contentPanel;
    }

    private boolean isProcessChoosed() {
        return this.process.getText() != null && this.process.getText().length() > 0;
    }

    @Override
    public File getLastFolder() {
        return null;
    }

    @Override
    public void setFileToLoad(File fileToLoad) {
        if (fileToLoad != null) {
            this.process.setText(fileToLoad.getAbsolutePath());
        }
    }

    @Override
    public void setFilesToLoad(File[] filesToLoad) {
    }

    public SubsequentProcess getProcess() {
        if (this.status == 2) {
            return null;
        }
        return new SubsequentProcess(this.process.getText(), this.param.getText(), this.processUID);
    }

    private class SetDefaultsPanel
    extends GridBagPanel {
        private static final long serialVersionUID = 1L;

        public SetDefaultsPanel() {
            SubsequentProcessDialog.this.setResizable(true);
            this.setBorder(ComponentUtils.createTitledCurvedBorder("subsequentprocess.defaultsettings"));
            List<ProcessI> processes = Document.getInstance().getProcessFactory().getProcesses();
            for (int i = 0; i < processes.size(); ++i) {
                ProcessI processI = processes.get(i);
                if (processI.getProcessName().getProcessIndex() >= 4) continue;
                JCheckBox aProcessCheckBox = new JCheckBox(" " + Messages.getString("config.dialog.subsequentprocess.defaultsettings." + processI.getProcessName().getName()));
                JPanel aProcessCheckBoxPanel = ComponentUtils.layoutCheckbox(aProcessCheckBox);
                SubsequentProcessDialog.this.defaultProcess.put(processI.getProcessName(), aProcessCheckBox);
                this.add((Component)aProcessCheckBoxPanel, new GridBagConstraints(i % 2, i / 2, 1, 1, 0.0, 1.0, 16, 0, new Insets(3, 3, 3, 3), 0, 0));
            }
        }
    }

    private class SetApplicationPanel
    extends GridBagPanel {
        private static final long serialVersionUID = 1L;

        public SetApplicationPanel() {
            JLabel processLabel = new JLabel("  " + Messages.getString("config.dialog.subsequentprocess.application") + " ");
            processLabel.setLabelFor(SubsequentProcessDialog.this.process);
            JLabel parameterLabel = new JLabel("  " + Messages.getString("config.dialog.subsequentprocess.application.parameter") + " ");
            parameterLabel.setLabelFor(SubsequentProcessDialog.this.param);
            Insets insets = new Insets(5, 5, 5, 5);
            Insets indentLeft = new Insets(5, 15, 5, 5);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.insets = indentLeft;
            this.addComponent(this, processLabel, gbc);
            this.addComponent(this, processLabel, gbc);
            gbc.gridx = 2;
            gbc.insets = insets;
            this.addComponent(this, SubsequentProcessDialog.this.process, gbc);
            gbc.gridx = 4;
            gbc.insets = new Insets(5, 5, 5, 15);
            this.addComponent(this, SubsequentProcessDialog.this.searchProcessButton, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = indentLeft;
            this.addComponent(this, parameterLabel, gbc);
            gbc.gridx = 2;
            gbc.insets = insets;
            this.addComponent(this, SubsequentProcessDialog.this.param, gbc);
            gbc.gridy = 4;
            gbc.gridwidth = 3;
            gbc.insets = indentLeft;
            this.addComponent(this, SubsequentProcessDialog.this.defaultsPanel, gbc);
            this.getGridBagLayout().layoutContainer(this);
            double[] colWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0};
            this.getGridBagLayout().columnWeights = colWeights;
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SubsequentProcessDialog.this.okButton.doClick();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SubsequentProcessDialog.this.cancelButton.doClick();
        }
    }
}

