/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.SubsequentProcessHandler;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.SubsequentProcessDialog;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.table.SubsequentProcessTable;
import de.bos_bremen.ecard.client.gui.view.component.table.SubsequentProcessTableModel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.SubsequentProcessFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class ManageSubsequentProcessDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String ESCAPE_ACTION = "escapeAction";
    private static final String DELETE_ACTION = "deleteAction";
    protected static final String COMPONENT_KEY = "subsequentprocess";
    private final JFrame frame;
    private JPanel content;
    private IconButton addButton;
    private IconButton changeButton;
    private IconButton cancelButton;
    private IconButton removeButton;
    private SubsequentProcessTable subsequentProcessTable;
    private transient List<SubsequentProcess> subprocessesToRemove;
    private final transient SubsequentProcessHandler handler;

    public ManageSubsequentProcessDialog(JFrame parentFrame, SubsequentProcessHandler processHandler) {
        super((Frame)parentFrame, true);
        this.handler = processHandler;
        this.frame = parentFrame;
        this.setTitle(Messages.getString("config.dialog.subsequentprocess.description.header"));
        this.initComponents();
        Dimension parentDimension = this.frame.getMinimumSize() == null ? this.frame.getSize() : this.frame.getMinimumSize();
        this.setMinimumSize(GUIUtils.createRelativeToParent(parentDimension, 0.95, 0.4));
        this.setSize(GUIUtils.createRelativeToParent(parentDimension, 0.95, 0.4));
        this.setResizable(true);
        this.setLocationRelativeTo(this.frame);
    }

    private void initComponents() {
        this.content = new JPanel();
        this.getContentPane().add(this.content);
        BorderLayout layout = new BorderLayout();
        this.content.setLayout(layout);
        this.content.add((Component)this.createSubsequentProcessPanel(), "Center");
        this.content.add((Component)this.createButtonPanel(), "South");
        this.pack();
        this.setSubsequentProcesses(this.handler.getRemoveableSubsequentProcesses());
    }

    private JPanel createSubsequentProcessPanel() {
        JPanel subsequentProcessPanel = new JPanel(new BorderLayout());
        subsequentProcessPanel = ComponentUtils.setTitledFocusableBorder(subsequentProcessPanel, Messages.getString("config.dialog.subsequentprocess.processes.title"));
        this.subsequentProcessTable = new SubsequentProcessTable();
        this.subsequentProcessTable.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.subsequentProcessTable);
        subsequentProcessPanel.add(scrollPane);
        return subsequentProcessPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(CurvedBorder.createDefault());
        buttonPanel.setBackground(SignerTheme.BOREUM_PETROL_MENU);
        buttonPanel.setOpaque(true);
        this.addButton = new IconButton("config.dialog.subsequentprocess.add");
        this.configureButton(this.addButton);
        this.addButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (10 == keyEvent.getKeyCode() || 32 == keyEvent.getKeyCode()) {
                    ManageSubsequentProcessDialog.this.addAction();
                    keyEvent.consume();
                }
            }
        });
        this.changeButton = new IconButton("config.dialog.subsequentprocess.change");
        this.configureButton(this.changeButton);
        this.changeButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (10 == keyEvent.getKeyCode() || 32 == keyEvent.getKeyCode()) {
                    ManageSubsequentProcessDialog.this.changeAction();
                    keyEvent.consume();
                }
            }
        });
        this.removeButton = new IconButton("config.dialog.subsequentprocess.remove");
        this.configureButton(this.removeButton);
        InputMap keyMap = this.removeButton.getInputMap(2);
        keyMap.put(KeyStroke.getKeyStroke(127, 0), DELETE_ACTION);
        keyMap = this.removeButton.getInputMap(0);
        keyMap.put(KeyStroke.getKeyStroke(10, 0), DELETE_ACTION);
        ActionMap actionMap = this.removeButton.getActionMap();
        actionMap.put(DELETE_ACTION, new DeleteAction());
        this.cancelButton = new IconButton("config.dialog.subsequentprocess.cancel");
        this.configureButton(this.cancelButton);
        keyMap = this.cancelButton.getInputMap(2);
        keyMap.put(KeyStroke.getKeyStroke(27, 0), ESCAPE_ACTION);
        keyMap = this.cancelButton.getInputMap(0);
        keyMap.put(KeyStroke.getKeyStroke(10, 0), ESCAPE_ACTION);
        actionMap = this.cancelButton.getActionMap();
        actionMap.put(ESCAPE_ACTION, new EscapeAction());
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.changeButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(new JLabel("             "));
        buttonPanel.add(this.cancelButton);
        return buttonPanel;
    }

    public List<SubsequentProcess> getProcessesToRemove() {
        return this.subprocessesToRemove;
    }

    public void setSubsequentProcesses(List<SubsequentProcess> subsequentProcesses) {
        this.subsequentProcessTable.setData(subsequentProcesses);
        this.content.revalidate();
    }

    public void showNoSelectionMessage() {
        Document.getInstance().showMessageDialogText(this, Messages.getString("config.dialog.subsequentprocess.selection"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt == null) {
            return;
        }
        Iterator<SubsequentProcess> iterator = evt.getSource();
        if (!(iterator instanceof IconButton)) {
            return;
        }
        IconButton iconButton = (IconButton)((Object)iterator);
        if (iconButton.equals(this.cancelButton)) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (iconButton.equals(this.removeButton)) {
            if (this.subsequentProcessTable.getSelectedRow() == -1) {
                this.showNoSelectionMessage();
            } else {
                this.subprocessesToRemove = this.subsequentProcessTable.getSelectedData();
                if (this.subprocessesToRemove != null && this.handler != null) {
                    for (SubsequentProcess process : this.subprocessesToRemove) {
                        this.handler.removeSubsequentProcess(process);
                        ((SubsequentProcessTableModel)this.subsequentProcessTable.getModel()).removeRow(this.subsequentProcessTable.getSelectedRow());
                    }
                }
            }
            return;
        }
        if (iconButton.equals(this.addButton)) {
            this.addAction();
            return;
        }
        if (iconButton.equals(this.changeButton)) {
            this.changeAction();
        }
    }

    private void changeAction() {
        if (this.subsequentProcessTable.getSelectedRow() == -1) {
            this.showNoSelectionMessage();
        } else {
            Vector test = (Vector)((SubsequentProcessTableModel)this.subsequentProcessTable.getModel()).getDataVector().get(this.subsequentProcessTable.getSelectedRow());
            SubsequentProcess selectedProcess = (SubsequentProcess)test.get(0);
            SubsequentProcessDialog continueProcessDialog = new SubsequentProcessDialog(this.frame, selectedProcess, selectedProcess.getUniqueId());
            continueProcessDialog.setVisible(true);
            SubsequentProcess process = continueProcessDialog.getProcess();
            if (process != null) {
                this.handler.addSubsequentProcess(process);
            }
        }
    }

    private void addAction() {
        int newSize = SubsequentProcessFactory.getNextProcessCounter();
        SubsequentProcessDialog continueProcessDialog = new SubsequentProcessDialog(this.frame, null, "COUNTER_" + newSize);
        continueProcessDialog.setVisible(true);
        SubsequentProcess process = continueProcessDialog.getProcess();
        if (process != null) {
            this.handler.addSubsequentProcess(process);
            Vector<SubsequentProcess> temp = new Vector<SubsequentProcess>();
            temp.add(process);
            temp.add(process);
            ((SubsequentProcessTableModel)this.subsequentProcessTable.getModel()).getDataVector().add(temp);
            ((SubsequentProcessTableModel)this.subsequentProcessTable.getModel()).fireTableDataChanged();
        }
    }

    private void configureButton(JButton button) {
        button.addActionListener(this);
        button.addFocusListener(ComponentUtils.createFocusListenerFor((JComponent)button, (Border)CurvedBorder.EMPTY_BORDER, (Border)CurvedBorder.FOCUSED_BORDER));
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ManageSubsequentProcessDialog.this.removeButton.doClick();
        }
    }

    private class EscapeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ManageSubsequentProcessDialog.this.cancelButton.doClick();
        }
    }
}

