/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.SubsequentProcessHandler;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ConfigPanel;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.JDICSubsequentProcess;
import de.bos_bremen.ecard.client.model.ProcessSubsequentProcess;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.SubsequentProcessComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class JPanelSubsequentProcess
implements ConfigPanel,
SubsequentProcessHandler,
ItemListener,
PropertyChangeListener {
    private JPanel content;
    private List<SubsequentProcess> subsequentProcessList;
    private final HashMap<String, JComboBox> subsequentComboBoxes = new HashMap();
    private final HashMap<ProcessI, SubsequentProcess> storedSubsequentProcesses = new HashMap();

    public JPanelSubsequentProcess() {
        this.initContent();
        this.initGUI();
        LocaleChanger.getInstance().addObserver(this);
    }

    private void initContent() {
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout());
    }

    protected void initGUI() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 10, 5);
        p.add(this.createSubsequentPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, insets, 0, 0));
        p.add(this.createButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, insets, 0, 0));
        this.content.add((Component)p, "North");
    }

    private Component createSubsequentPanel() {
        this.subsequentProcessList = Config.getInstance().getSubsequentProcessList();
        Collections.sort(this.subsequentProcessList, new SubsequentProcessComparator());
        TooltipListRenderer tooltipListRenderer = new TooltipListRenderer();
        JPanel processPanel = new JPanel(new GridBagLayout());
        processPanel = ComponentUtils.setTitledFocusableBorder(processPanel, Messages.getString("config.dialog.subsequentprocess2.title"));
        Insets insetsLabel = new Insets(5, 15, 5, 5);
        Insets insetsCombo = new Insets(5, 5, 5, 5);
        JLabel description = new JLabel(Messages.getString("config.dialog.subsequentprocess2.text"));
        description.setFocusable(true);
        description.addFocusListener(ComponentUtils.createFocusListenerFor(description));
        processPanel.add((Component)description, new GridBagConstraints(0, 0, 3, 1, 3.0, 0.0, 18, 2, insetsLabel, 0, 0));
        this.subsequentComboBoxes.clear();
        List<ProcessI> allProcesses = Document.getInstance().getProcessFactory().getProcesses();
        for (int i = 0; i < allProcesses.size(); ++i) {
            ProcessI p = allProcesses.get(i);
            if (p.getProcessName().getProcessIndex() >= 4) continue;
            JLabel processLabel = new JLabel(Messages.getString("config.dialog.subsequentprocess2." + p.getProcessName().getName() + ".label.text"));
            processLabel.setVerticalAlignment(3);
            processPanel.add((Component)processLabel, new GridBagConstraints(1, i + 1, 1, 1, 0.0, 0.0, 13, 0, insetsLabel, 0, 0));
            JComboBox<Object> subsequentComboBox = new JComboBox<Object>();
            processLabel.setLabelFor(subsequentComboBox);
            this.subsequentComboBoxes.put(p.getProcessName().getName(), subsequentComboBox);
            subsequentComboBox.setRenderer(tooltipListRenderer);
            processPanel.add(subsequentComboBox, new GridBagConstraints(2, i + 1, 1, 1, 1.0, 1.0, 17, 2, insetsCombo, 0, 0));
            this.populateCombobox(p, subsequentComboBox, this.subsequentProcessList);
            subsequentComboBox.addItemListener(this);
        }
        return processPanel;
    }

    private Component createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel = ComponentUtils.setTitledFocusableBorder(buttonPanel, Messages.getString("config.dialog.subsequentprocess2.more.title"));
        IconButton manageProcessButton = new IconButton();
        manageProcessButton.setAction(Document.getInstance().getActionFactory().createManageSubsequentProcess(this));
        manageProcessButton.setVerticalTextPosition(0);
        manageProcessButton.setHorizontalTextPosition(11);
        manageProcessButton.setToolTipText(MultiLineTooltips.wrapToolTip(manageProcessButton.getToolTipText()));
        JLabel description = new JLabel(Messages.getString("action.subsequentprocess.manage.label"));
        description.setHorizontalAlignment(11);
        description.setFocusable(true);
        description.addFocusListener(ComponentUtils.createFocusListenerFor(description));
        buttonPanel.add((Component)description, new GridBagConstraints(0, 0, 1, 1, 3.0, 0.0, 18, 0, new Insets(5, 15, 10, 5), 0, 0));
        buttonPanel.add((Component)manageProcessButton, new GridBagConstraints(0, 0, 1, 1, 3.0, 0.0, 10, 0, new Insets(60, 5, 10, 5), 0, 0));
        return buttonPanel;
    }

    public void setSubsequentProcesses(List<SubsequentProcess> subProcesses) {
        List<SubsequentProcess> subProcessesSorted = this.sortForDropDownMenu(subProcesses);
        List<ProcessI> signerProcesses = Document.getInstance().getProcessFactory().getProcesses();
        for (ProcessI p : signerProcesses) {
            if (p.getProcessName().getProcessIndex() >= 4) continue;
            JComboBox cb = this.subsequentComboBoxes.get(p.getProcessName().getName());
            this.populateCombobox(p, cb, subProcessesSorted);
        }
    }

    @Override
    public JPanel getView() {
        return this.content;
    }

    private void populateCombobox(ProcessI p, JComboBox subsequentComboBox, List<SubsequentProcess> subsequentProcessList) {
        subsequentComboBox.removeAllItems();
        for (SubsequentProcess sp : subsequentProcessList) {
            ProcessSubsequentProcess processSubsequentProcess;
            if (sp instanceof ProcessSubsequentProcess && (processSubsequentProcess = (ProcessSubsequentProcess)sp).getProcessName().equals(p.getProcessName())) continue;
            subsequentComboBox.addItem(sp);
            if (!sp.getUniqueId().equals(p.getSubsequentProcessUID())) continue;
            subsequentComboBox.setSelectedItem(sp);
            subsequentComboBox.setToolTipText(this.getTooltiptext(sp));
        }
    }

    @Override
    public void addSubsequentProcess(SubsequentProcess subsequentProcess) {
        if (!this.subsequentProcessList.contains(subsequentProcess)) {
            this.subsequentProcessList.add(subsequentProcess);
        }
        Collections.sort(this.subsequentProcessList, new SubsequentProcessComparator());
        this.setSubsequentProcesses(this.subsequentProcessList);
    }

    private List<SubsequentProcess> sortForDropDownMenu(List<SubsequentProcess> subsequentProcessList) {
        ArrayList<SubsequentProcess> resultList = new ArrayList<SubsequentProcess>();
        int i = 0;
        for (SubsequentProcess tmpSubsequentProcess : subsequentProcessList) {
            ProcessSubsequentProcess processSubsequentProcess;
            if (tmpSubsequentProcess instanceof ProcessSubsequentProcess && "none".equals((processSubsequentProcess = (ProcessSubsequentProcess)tmpSubsequentProcess).getProcessName().getName())) {
                resultList.add(0, tmpSubsequentProcess);
                ++i;
                continue;
            }
            resultList.add(i, tmpSubsequentProcess);
            ++i;
        }
        return resultList;
    }

    @Override
    public void removeSubsequentProcess(SubsequentProcess subsequentProcess) {
        this.subsequentProcessList.remove(subsequentProcess);
        List<ProcessI> processes = Document.getInstance().getProcessFactory().getProcesses();
        for (ProcessI processI : processes) {
            if (!subsequentProcess.getUniqueId().equals(processI.getSubsequentProcessUID())) continue;
            processI.setSubsequentProcessUID(null);
        }
        this.setSubsequentProcesses(this.subsequentProcessList);
    }

    @Override
    public List<SubsequentProcess> getSubsequentProcesses() {
        return this.subsequentProcessList;
    }

    @Override
    public List<SubsequentProcess> getRemoveableSubsequentProcesses() {
        ArrayList<SubsequentProcess> removeable = new ArrayList<SubsequentProcess>();
        for (SubsequentProcess sp : this.getSubsequentProcesses()) {
            if (sp instanceof JDICSubsequentProcess || sp instanceof ProcessSubsequentProcess) continue;
            removeable.add(sp);
        }
        return removeable;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        SubsequentProcess sp;
        JComboBox cb;
        if (evt != null && (cb = (JComboBox)evt.getSource()) != null && (sp = (SubsequentProcess)cb.getSelectedItem()) != null) {
            cb.setToolTipText(this.getTooltiptext(sp));
        }
    }

    private String getTooltiptext(SubsequentProcess sp) {
        if (sp == null) {
            return null;
        }
        return sp.getProcess() + " " + (sp.getDefaultProcessParam() == null ? "" : sp.getDefaultProcessParam());
    }

    public void reinit() {
        this.subsequentProcessList = Config.getInstance().getSubsequentProcessList();
        Collections.sort(this.subsequentProcessList, new SubsequentProcessComparator());
        this.setSubsequentProcesses(this.subsequentProcessList);
    }

    protected void storeValues() {
        this.storedSubsequentProcesses.clear();
        List<ProcessI> allProcesses = Document.getInstance().getProcessFactory().getProcesses();
        for (ProcessI p : allProcesses) {
            if (p.getProcessName().getProcessIndex() >= 4) continue;
            JComboBox cb = this.subsequentComboBoxes.get(p.getProcessName().getName());
            SubsequentProcess sp = (SubsequentProcess)cb.getSelectedItem();
            this.storedSubsequentProcesses.put(p, sp);
        }
    }

    public void save() {
        List<ProcessI> allProcesses = Document.getInstance().getProcessFactory().getProcesses();
        for (ProcessI p : allProcesses) {
            JComboBox cb;
            SubsequentProcess sp;
            if (p.getProcessName().getProcessIndex() >= 4 || (sp = (SubsequentProcess)(cb = this.subsequentComboBoxes.get(p.getProcessName().getName())).getSelectedItem()) == null) continue;
            p.setSubsequentProcessUID(sp.getUniqueId());
        }
    }

    protected void restoreValues() {
        this.reinit();
        List<ProcessI> allProcesses = Document.getInstance().getProcessFactory().getProcesses();
        for (ProcessI p : allProcesses) {
            if (p.getProcessName().getProcessIndex() >= 4) continue;
            JComboBox cb = this.subsequentComboBoxes.get(p.getProcessName().getName());
            SubsequentProcess sp = this.storedSubsequentProcesses.get(p);
            cb.setSelectedItem(sp);
        }
        this.storedSubsequentProcesses.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.storeValues();
        this.content.removeAll();
        this.initGUI();
        this.restoreValues();
        this.content.revalidate();
    }

    private class TooltipListRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        private TooltipListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setToolTipText(JPanelSubsequentProcess.this.getTooltiptext((SubsequentProcess)value));
            return this;
        }
    }
}

