/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config;

import de.bos_bremen.debug_mode.DebugLevel;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.HelpAction;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.JPanelGeneral;
import de.bos_bremen.ecard.client.gui.dialog.config.JPanelNetwork;
import de.bos_bremen.ecard.client.gui.dialog.config.JPanelSubsequentProcess;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.util.GlassPane;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.server.ProxyServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDialog
extends JDialog
implements ChangeListener,
KeyListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigDialog.class);
    private static final org.apache.logging.log4j.Logger LOG = LogManager.getLogger(ConfigDialog.class);
    private static final long serialVersionUID = -1296179202456874631L;
    private static final String CONFIG_DEFAULT_HELP_TARGET = Messages.getString("config.dialog.general.helpcontext");
    private JPanel buttonPanel;
    private boolean closedByAction = false;
    private Component comp = null;
    private JTabbedPane tpConfig;
    public transient JPanelNetwork pNetwork;
    private transient JPanelSubsequentProcess pSubsequentProcess2;
    private transient JPanelGeneral pGeneral;
    private final HashMap<String, String> titleHelpMap = new HashMap();
    private AbstractSignerAction helpAction = null;

    public ConfigDialog(JFrame parentFrame) {
        super(parentFrame, Messages.getString("config.dialog.title"), true);
        this.comp = parentFrame;
        GUIUtils.setSignerThemeInUIManager();
        this.initContent();
        this.init();
        JComponentUtils.setKeyListenerToAllComponents(this.tpConfig, this);
        super.repaint();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (!ConfigDialog.this.closedByAction) {
                    ConfigDialog.this.closedByAction = true;
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Config.getInstance().setConfigDialogSize(ConfigDialog.this.getSize());
                if (!ConfigDialog.this.closedByAction) {
                    ConfigDialog.this.closedByAction = true;
                }
            }
        });
    }

    public ConfigDialog(JDialog parentDialog) {
        super(parentDialog, Messages.getString("config.dialog.title"), true);
        this.comp = parentDialog;
        GUIUtils.setSignerThemeInUIManager();
        this.initContent();
        this.init();
        JComponentUtils.setKeyListenerToAllComponents(this.tpConfig, this);
    }

    private void initContent() {
        this.setIconImage(ComponentUtils.getImage("config.dialog"));
        this.helpAction = Document.getInstance().getActionFactory().getContextSensitiveHelpAction();
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 3));
        this.createButtonPanel();
        this.createPanels();
        this.createTabbedPane();
        this.setMinimumSize(GUIUtils.createConfigDialogDimension(this.comp.getMinimumSize()));
        this.setSize(GUIUtils.createConfigDialogDimension(this.comp.getMinimumSize()));
        this.setResizable(true);
        this.setLocationRelativeTo(this.comp);
    }

    private void createTabbedPane() {
        this.tpConfig = new JTabbedPane();
        this.tpConfig.setTabLayoutPolicy(0);
        this.tpConfig.addChangeListener(e -> {
            int selectedIndex = this.tpConfig.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.tpConfig.getTabCount()) {
                String selectedCard = this.tpConfig.getTitleAt(this.tpConfig.getSelectedIndex());
                String helpID = this.titleHelpMap.get(selectedCard);
                if (helpID != null) {
                    HelpAction.enableHelpKey(this.getRootPane(), helpID);
                } else {
                    HelpAction.enableHelpKey(this.getRootPane(), CONFIG_DEFAULT_HELP_TARGET);
                }
            } else {
                HelpAction.enableHelpKey(this.getRootPane(), CONFIG_DEFAULT_HELP_TARGET);
            }
        });
    }

    private void createPanels() {
        this.createGeneralPanel();
        this.createSubsequentProcess2();
        this.createNetworkPanel();
    }

    private void init() {
        super.setTitle(Messages.getString("config.dialog.title"));
        int tabIndex = 0;
        this.getContentPane().add((Component)this.tpConfig, "Center");
        Document documentInstance = Document.getInstance();
        if (documentInstance.getProductFunctions().enableGeneralActionsSettingsLanguage().isVisible() && documentInstance.getProductFunctions().enableGeneralActionsSettingsProtocol().isVisible() && documentInstance.getProductFunctions().enableGeneralActionsSettingsSplashScreen().isVisible()) {
            this.addCard(tabIndex, "config.dialog.general", this.pGeneral.getView());
            if (!(documentInstance.getProductFunctions().enableGeneralActionsSettingsLanguage().isEditable() || documentInstance.getProductFunctions().enableGeneralActionsSettingsProtocol().isEditable() || documentInstance.getProductFunctions().enableGeneralActionsSettingsSplashScreen().isEditable())) {
                this.tpConfig.setEnabledAt(tabIndex, false);
            }
            ++tabIndex;
        }
        if (documentInstance.getProductFunctions().enableGeneralActionsSettingsSubsequentProcess().isVisible()) {
            this.addCard(tabIndex, "config.dialog.subsequentprocess2", this.pSubsequentProcess2.getView());
            if (!documentInstance.getProductFunctions().enableGeneralActionsSettingsSubsequentProcess().isEditable()) {
                this.tpConfig.setEnabledAt(tabIndex, false);
            }
            ++tabIndex;
        }
        List<ProcessI> processes = documentInstance.getProcessFactory().getProcesses();
        for (ProcessI process : processes) {
            List<ProcessConfigComponent> configComponents = process.getConfigComponents();
            if (configComponents == null || !process.getLicenceTyp().isVisible()) continue;
            for (ProcessConfigComponent configComp : configComponents) {
                if (configComp.getLicenceTyp() == null || !configComp.getLicenceTyp().isVisible()) continue;
                configComp.load();
                this.addCard(tabIndex, configComp);
                if (!configComp.getLicenceTyp().isEditable()) {
                    this.tpConfig.setEnabledAt(tabIndex, false);
                }
                ++tabIndex;
            }
        }
        if (documentInstance.getProductFunctions().enableGeneralActionsSettingsProxyserver().isVisible()) {
            this.addCard(tabIndex, "config.dialog.network", this.pNetwork.getView());
            if (!documentInstance.getProductFunctions().enableGeneralActionsSettingsProxyserver().isEditable()) {
                this.tpConfig.setEnabledAt(tabIndex, false);
            }
        }
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.tpConfig.addChangeListener(this);
    }

    private void addCard(int tabIndex, String keyname, JComponent view) {
        this.titleHelpMap.put(Messages.getString(keyname + ".title"), Messages.getString(keyname + ".helpcontext"));
        this.tpConfig.add(Messages.getString(keyname + ".title"), view);
        this.tpConfig.setIconAt(tabIndex, ComponentUtils.getIcon(keyname));
    }

    private void addCard(int tabIndex, ProcessConfigComponent component) {
        try {
            if (component.getHelpContext() != null) {
                this.titleHelpMap.put(component.getTitle(), component.getHelpContext());
            } else {
                this.titleHelpMap.put(component.getTitle(), CONFIG_DEFAULT_HELP_TARGET);
            }
            this.tpConfig.add(component.getTitle(), component.getView());
            this.tpConfig.setIconAt(tabIndex, component.getIcon());
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    private JPanel createGeneralPanel() {
        this.pGeneral = new JPanelGeneral();
        this.pGeneral.setProtocolFile(Config.getInstance().getProtocolFile());
        this.pGeneral.setProtocolLevel(Config.getInstance().getProtocolLevel());
        this.pGeneral.setLocale(Config.getInstance().getLocale());
        return this.pGeneral.getView();
    }

    private JPanel createSubsequentProcess2() {
        this.pSubsequentProcess2 = new JPanelSubsequentProcess();
        this.pSubsequentProcess2.setSubsequentProcesses(Config.getInstance().getSubsequentProcessList());
        return this.pSubsequentProcess2.getView();
    }

    private JPanel createNetworkPanel() {
        Config config = Config.getInstance();
        this.pNetwork = new JPanelNetwork();
        ProxyServer proxyServer = config.getProxyServer();
        this.pNetwork.setProxyHost(proxyServer.getProxyHost());
        this.pNetwork.setProxyPort(proxyServer.getProxyPortAsString());
        this.pNetwork.setProxyUser(proxyServer.getUsername());
        this.pNetwork.setProxyPasswd(proxyServer.getPasswordAsArray());
        this.pNetwork.setAutoConfigUrl(proxyServer.getAutoConfigUrl());
        return this.pNetwork.getView();
    }

    private JPanel createButtonPanel() {
        JPanel leftPanel = new JPanel(new FlowLayout(0));
        JPanel centerPanel = new JPanel(new GridLayout(1, 2));
        JPanel rightPanel = new JPanel();
        Document documentInstance = Document.getInstance();
        JPanel arrows = new JPanel(new GridBagLayout());
        String signerHelpPath = System.getProperty("signer.helppath");
        if (signerHelpPath != null && !signerHelpPath.isEmpty()) {
            IconButton helpButton = new IconButton();
            ((AbstractButton)helpButton).setAction(documentInstance.getActionFactory().createContextSensitiveHelpAction(""));
            arrows.add(helpButton);
        } else {
            LOG.debug("signer.helppath erwartet URL zur 'doc'");
        }
        leftPanel.add(arrows);
        CancelAction cancelAction = new CancelAction("config.abort" + (documentInstance.isSaveConfig() ? "" : ".temp"), this.comp);
        IconButton cancelButton = new IconButton();
        cancelButton.setAction(cancelAction);
        ComponentInputMap keyMap = new ComponentInputMap(cancelButton);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(27, 0), "cancelAction");
        ActionMapUIResource actionMap = new ActionMapUIResource();
        actionMap.put("cancelAction", cancelAction);
        SwingUtilities.replaceUIActionMap(cancelButton, actionMap);
        SwingUtilities.replaceUIInputMap(cancelButton, 2, keyMap);
        keyMap = new ComponentInputMap(cancelButton);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(32, 0), "cancelAction");
        SwingUtilities.replaceUIInputMap(cancelButton, 0, keyMap);
        SaveAction saveAction = new SaveAction("button.save" + (documentInstance.isSaveConfig() ? "" : ".temp"), this.comp);
        IconButton saveButton = new IconButton();
        ((AbstractButton)saveButton).setAction(saveAction);
        keyMap = new ComponentInputMap(saveButton);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(83, 128), "saveAction");
        actionMap = new ActionMapUIResource();
        actionMap.put("saveAction", saveAction);
        SwingUtilities.replaceUIActionMap(saveButton, actionMap);
        SwingUtilities.replaceUIInputMap(saveButton, 2, keyMap);
        keyMap = new ComponentInputMap(saveButton);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(32, 0), "saveAction");
        SwingUtilities.replaceUIInputMap(saveButton, 0, keyMap);
        centerPanel.add(saveButton);
        centerPanel.add(cancelButton);
        this.buttonPanel.add(leftPanel);
        this.buttonPanel.add(centerPanel);
        this.buttonPanel.add(rightPanel);
        this.buttonPanel.setBackground(SignerTheme.BOREUM_PETROL_MENU);
        this.buttonPanel.setOpaque(true);
        HelpAction.enableHelpKey(this.getRootPane(), CONFIG_DEFAULT_HELP_TARGET);
        return this.buttonPanel;
    }

    private void save() {
        LOG.trace("");
        Config config = Config.getInstance();
        List<ProcessI> processes = Document.getInstance().getProcessFactory().getProcesses();
        for (ProcessI process : processes) {
            List<ProcessConfigComponent> configComponents = process.getConfigComponents();
            if (configComponents == null || !process.getLicenceTyp().isVisible()) continue;
            for (ProcessConfigComponent configComp : configComponents) {
                if (!configComp.getLicenceTyp().isVisible() || !configComp.getLicenceTyp().isEditable()) continue;
                configComp.save();
            }
        }
        this.pSubsequentProcess2.save();
        config.setProcessProperties(Document.getInstance().getProcessFactory().getProperties());
        config.setProtocolFile(this.pGeneral.getProtocolFile());
        config.setProtocolLevel(this.pGeneral.getProtocolLevel());
        if (!DebugLevel.none.equals((Object)this.pGeneral.getProtocolLevel())) {
            config.initDebugMode();
        }
        config.setSubsequentProcessList(this.pSubsequentProcess2.getSubsequentProcesses());
        ProxyServer ps = this.pNetwork.getProxyServer();
        if (this.pNetwork.getAutoConfigUrl() != null && !this.pNetwork.getAutoConfigUrl().isEmpty()) {
            LOG.debug("proxy-auto-config: {}", (Object)this.pNetwork.getAutoConfigUrl());
            SignerValidationProcessor validationInstance = SignerValidationProcessor.getInstance();
            if (validationInstance.getServer() != null && validationInstance.getServer().getUrl() != null && !validationInstance.getServer().getUrl().isEmpty()) {
                LOG.trace("evaluate url ... : {}", (Object)validationInstance.getServer().getUrl());
                String error = ps.evalAutoConfigUrl(validationInstance.getServer().getUrl());
                LOG.error("proxy-auto-config : evaluate url error : {}", (Object)error);
                if (error != null) {
                    LOG.debug("show error : dialog.error.pac.eval.message");
                    ErrorDialog.showDialog(this, "error.pac", Messages.getString("dialog.error.pac.eval.message"), error);
                }
                LOG.trace("ValidationProcessor ProxyServer : {}", (Object)validationInstance.getProxyConfiguration());
            } else {
                String message = Messages.getString("dialog.error.pac.no_url.message");
                LOG.debug("show error : dialog.error.pac.no_url.message : {}", (Object)message);
                ErrorDialog.showDialog(this, "error.pac", message, null);
            }
        }
        config.setProxyServer(ps);
        if (this.pGeneral.getLocale() != null && !this.pGeneral.getLocale().equals(Locale.getDefault())) {
            config.setLocale(this.pGeneral.getLocale());
        }
        config.storeDefault();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
    }

    public void showPanel(String tabTitle) {
        if (this.tpConfig != null) {
            for (int i = 0; i < this.tpConfig.getTabCount(); ++i) {
                if (!this.tpConfig.getTitleAt(i).equals(Messages.getString(tabTitle))) continue;
                this.tpConfig.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        JComponentUtils.callAction(e, this.helpAction);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public class CancelAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = -9044341784036976869L;

        public CancelAction(String keyname, Component parent) {
            super(keyname, parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.info("Einstellungen schliessen, ohne zu speichern.");
            ConfigDialog.this.closedByAction = true;
            Config.getInstance().setConfigDialogSize(ConfigDialog.this.getSize());
            ConfigDialog.this.dispose();
        }
    }

    public class SaveAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 6981064717369025015L;

        public SaveAction(String keyname, Component parent) {
            super(keyname, parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDialog.this.closedByAction = true;
            ConfigDialog.this.setGlassPane(new GlassPane());
            ConfigDialog.this.getGlassPane().setVisible(true);
            Config.getInstance().setConfigDialogSize(ConfigDialog.this.getSize());
            Runnable runnable = () -> {
                log.info("Einstellungen speichern.");
                ConfigDialog.this.save();
                ConfigDialog.this.getGlassPane().setVisible(false);
                ConfigDialog.this.setVisible(false);
                ConfigDialog.this.dispose();
                LocaleChanger.getInstance().setLocale(Config.getInstance().getLocale(), true);
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

