/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog.config;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.LeftSideBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.CurvedToggleIconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.LinkButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.TitledCurvedBorder;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentUtils {
    private static final String RESOURCES = "/resources/";
    private static final Logger LOG = LogManager.getLogger(ComponentUtils.class);

    public static void createComponent(JPanel jpanel, JComponent component, String componentKey) {
        ComponentUtils.createComponent(jpanel, component, componentKey, 0, 18, 18, 2);
    }

    public static void createComponentRightLabel(JPanel jpanel, JComponent component, String componentKey, int x) {
        ComponentUtils.createComponent(jpanel, component, componentKey, x, 12, 18, 2);
    }

    public static void createComponentNofill(JPanel jpanel, JComponent component, String componentKey) {
        ComponentUtils.createComponent(jpanel, component, componentKey, 0, 12, 18, 0);
    }

    public static void createComponent(JPanel jpanel, JComponent component, String componentKey, int x, int labelAnchor, int anchor, int fill) {
        ComponentUtils.createComponent(jpanel, component, componentKey, x, labelAnchor, anchor, fill, new Insets(3, 3, 3, 3));
    }

    public static void createComponent(JPanel jpanel, JComponent component, String componentKey, int x, int labelAnchor, int anchor, int fill, Insets insets) {
        if (componentKey != null) {
            JLabel label = new JLabel(Messages.getString("config.dialog." + componentKey));
            jpanel.add((Component)label, new GridBagConstraints(x, -1, 1, 1, 0.0, 0.1, labelAnchor, 0, insets, 0, 0));
        }
        if (component != null) {
            if (componentKey != null) {
                component.setToolTipText(Messages.getResource("config.dialog." + componentKey + ".tooltip"));
            }
            jpanel.add((Component)component, new GridBagConstraints(x + 1, -1, 2, 1, 1.0, 0.0, anchor, fill, insets, 0, 0));
        }
    }

    public static void createComponent(JPanel jpanel, String componentKey) {
        if (componentKey != null) {
            JLabel label = new JLabel(Messages.getString("config.dialog." + componentKey));
            jpanel.add((Component)label, new GridBagConstraints(0, -1, 0, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        }
    }

    public static Icon getIcon(String key) {
        Image image = ComponentUtils.getImage(key);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public static Image getImage(String key) {
        String iconName = Messages.getResource(key + ".icon");
        boolean scaleIcon = Boolean.parseBoolean(Messages.getResource(key + ".icon.scale", Boolean.FALSE.toString()));
        Image originalImage = null;
        if (iconName != null && AbstractSignerAction.class.getResource(RESOURCES + iconName) != null) {
            ImageIcon image = IconScalingUtils.createMultiResIcon(key + ".icon");
            originalImage = image.getImage();
            if (!iconName.endsWith("_24.png") && scaleIcon) {
                String path = RESOURCES + iconName.substring(0, iconName.length() - 4) + "_24.png";
                try (InputStream is = AbstractSignerAction.class.getResourceAsStream(path);){
                    if (is != null) {
                        image = new ImageIcon(AbstractSignerAction.class.getResource(path));
                        originalImage = image.getImage();
                    } else {
                        int imagePx = GUIUtils.toCurrentPx(16);
                        originalImage = originalImage.getScaledInstance(imagePx, imagePx, 4);
                    }
                }
                catch (Exception t) {
                    LOG.debug(t.getMessage());
                }
            }
        } else if (iconName != null) {
            LOG.info("Konnte kein Icon finden fuer Key: {}", (Object)key);
        }
        return originalImage;
    }

    public static Icon getEmptyIcon() {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
    }

    public static TitledBorder createTitledBorder(String componentKey) {
        return BorderFactory.createTitledBorder(Messages.getString("config.dialog." + componentKey + ".title"));
    }

    public static TitledCurvedBorder createTitledCurvedBorder(String componentKey) {
        return new TitledCurvedBorder(Messages.getString("config.dialog." + componentKey + ".title"));
    }

    public static TitledCurvedBorder createTitledCurvedBorderForTitle(String title) {
        return new TitledCurvedBorder(title);
    }

    public static JPanel setTitledFocusableBorder(JPanel panel, String title) {
        TitledCurvedBorder titledBorderFocusless = ComponentUtils.createTitledCurvedBorderForTitle(title);
        panel.setBorder(titledBorderFocusless);
        TitledCurvedBorder titledBorderFocused = ComponentUtils.createTitledCurvedBorderForTitle(title);
        titledBorderFocused.setBorder(CurvedBorder.FOCUSED_BORDER);
        panel.setFocusable(true);
        panel.addFocusListener(ComponentUtils.createFocusListenerForTitled(panel, titledBorderFocusless, titledBorderFocused));
        return panel;
    }

    public static Border createLeftSideBorder() {
        return new LeftSideBorder();
    }

    public static char getMnemonic(String componentKey) {
        String mnemonicString = null;
        char mnemonic = '\u0000';
        try {
            mnemonicString = Messages.getString(componentKey + ".mnemonic");
            mnemonic = mnemonicString.charAt(0);
        }
        catch (Exception ex) {
            mnemonic = '\u0000';
        }
        return mnemonic;
    }

    public static MouseAdapter createMouseAdapterFor(final JComponent component) {
        final Border ownBorder = component.getBorder();
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                component.setBorder(component.hasFocus() && component.isFocusable() && component.isEnabled() ? CurvedBorder.FOCUSED_BORDER : ownBorder);
                if (component instanceof CurvedToggleIconButton) {
                    CurvedToggleIconButton toggleButton = (CurvedToggleIconButton)component;
                    component.setBorder(toggleButton.isSelected() && toggleButton.isEnabled() && toggleButton.isFocusable() ? CurvedBorder.ACTIVE_BORDER : ownBorder);
                } else if (component instanceof IconButton) {
                    IconButton iconButtonSelectable;
                    iconButtonSelectable.setBorder((iconButtonSelectable = (IconButton)component).isSelected() ? CurvedBorder.ACTIVE_BORDER_THIN : ownBorder);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                component.setBorder(component.isFocusable() && component.isEnabled() ? CurvedBorder.FOCUSED_BORDER : ownBorder);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                component.setBorder(CurvedBorder.FOCUSED_BORDER);
                if (component instanceof CurvedToggleIconButton) {
                    component.setBorder(component.isFocusable() && component.isEnabled() ? CurvedBorder.ACTIVE_BORDER : ownBorder);
                }
            }
        };
    }

    public static MouseAdapter createMouseAdapterForButton(final IconButton processButton) {
        final Border ownBorder = processButton.getBorder();
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                processButton.setBorder(ownBorder);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                processButton.setBorder(CurvedBorder.BORDER_PROCESS_FOCUSED);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                processButton.setBorder(CurvedBorder.BORDER_PROCESS_FOCUSED);
            }
        };
    }

    public static MouseAdapter createMouseAdapterForNavigateButton(final IconButton navigateButton) {
        final Icon icon = navigateButton.getIcon();
        final Icon rolloverIcon = navigateButton.getRolloverIcon();
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                navigateButton.setForeground(SignerTheme.WHITE_RESOURCE);
                navigateButton.setBackground(SignerTheme.SIGNER_BLUE);
                navigateButton.setCursor(Cursor.getPredefinedCursor(12));
                if (rolloverIcon == null) {
                    return;
                }
                navigateButton.setIcon(rolloverIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                navigateButton.setForeground(SignerTheme.BOREUM_PETROL_BLACK);
                navigateButton.setBackground(SignerTheme.WHITE_RESOURCE);
                navigateButton.setCursor(Cursor.getDefaultCursor());
                navigateButton.setIcon(icon);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                navigateButton.setCursor(Cursor.getDefaultCursor());
                navigateButton.setBorder(CurvedBorder.WHITE_BORDER);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                navigateButton.setCursor(Cursor.getPredefinedCursor(12));
                navigateButton.setBorder(CurvedBorder.EMPTY_BORDER);
                if (navigateButton.getCursor().getType() == 12) {
                    navigateButton.setForeground(SignerTheme.WHITE_RESOURCE);
                    navigateButton.setBackground(SignerTheme.SIGNER_BLUE);
                    if (rolloverIcon == null) {
                        return;
                    }
                    navigateButton.setIcon(rolloverIcon);
                } else {
                    navigateButton.setForeground(SignerTheme.BOREUM_PETROL_BLACK);
                    navigateButton.setBackground(SignerTheme.WHITE_RESOURCE);
                    navigateButton.setIcon(icon);
                }
            }
        };
    }

    public static MouseAdapter createMouseAdapterForLink(final LinkButton linkButton) {
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                linkButton.setForeground(SignerTheme.COLOR_GREEN);
                linkButton.setBackground(Color.WHITE);
                linkButton.setOpaque(true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                linkButton.setForeground(Color.WHITE);
                linkButton.setBackground(SignerTheme.SIGNER_BLUE);
                linkButton.setOpaque(true);
            }
        };
    }

    public static FocusListener createFocusListenerFor(JComponent component) {
        Border ownBorder = component.getBorder();
        return ComponentUtils.createFocusListenerFor(component, ownBorder, (Border)CurvedBorder.FOCUSED_BORDER);
    }

    public static FocusListener createFocusListenerFor(final JComponent component, final Border focusless, final Border focused) {
        component.setFocusable(true);
        component.setBorder(focusless);
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (component instanceof CurvedToggleIconButton) {
                    CurvedToggleIconButton toggleButton = (CurvedToggleIconButton)component;
                    component.setBorder(toggleButton.isSelected() && toggleButton.isEnabled() && toggleButton.isFocusable() ? CurvedBorder.ACTIVE_BORDER : focusless);
                } else if (component instanceof IconButton) {
                    IconButton iconButtonSelectable;
                    iconButtonSelectable.setBorder((iconButtonSelectable = (IconButton)component).isSelected() ? CurvedBorder.ACTIVE_BORDER_THIN : focusless);
                } else {
                    component.setBorder(focusless);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                component.setBorder(focused);
            }
        };
    }

    public static FocusListener createFocusListenerForIcon(final IconButton iconButton) {
        final Icon icon = iconButton.getIcon();
        final Icon rolloverIcon = iconButton.getRolloverIcon();
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                iconButton.setIcon(icon);
                iconButton.setForeground(SignerTheme.BOREUM_PETROL_BLACK);
                iconButton.setBackground(SignerTheme.WHITE_RESOURCE);
            }

            @Override
            public void focusGained(FocusEvent e) {
                iconButton.setForeground(SignerTheme.WHITE_RESOURCE);
                iconButton.setBackground(SignerTheme.SIGNER_BLUE);
                if (rolloverIcon == null) {
                    return;
                }
                iconButton.setIcon(rolloverIcon);
            }
        };
    }

    public static FocusListener createFocusListenerForTitled(final JPanel panel, final TitledCurvedBorder focusless, final TitledCurvedBorder focused) {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                panel.setBorder(focusless);
            }

            @Override
            public void focusGained(FocusEvent e) {
                panel.setBorder(focused);
            }
        };
    }

    public static FocusListener createFocusListenerFor(JLabel label) {
        label.setBorder(CurvedBorder.EMPTY_BORDER);
        return ComponentUtils.createFocusListenerFor(label, (Border)CurvedBorder.EMPTY_BORDER, (Border)CurvedBorder.FOCUSED_BORDER);
    }

    public static FocusListener createFocusListenerFor(final JLabel label, final Border focusless, final Border focused) {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                label.setBorder(focusless);
            }

            @Override
            public void focusGained(FocusEvent e) {
                label.setBorder(focused);
            }
        };
    }

    public static FocusListener createFocusListenerFor(final JComponent component, final Color focusless, final Color focused) {
        component.setFocusable(true);
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                component.setBackground(focusless);
            }

            @Override
            public void focusGained(FocusEvent e) {
                component.setBackground(focused);
            }
        };
    }

    public static FocusListener createFocusListenerFor(final JRadioButton component, final Color focusless, final Color focused) {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                component.setBackground(focusless);
                component.updateUI();
            }

            @Override
            public void focusGained(FocusEvent e) {
                component.setBackground(focused);
                component.updateUI();
            }
        };
    }

    public static FocusListener createFocusListenerFor(final JPanel parent) {
        parent.setBorder(CurvedBorder.EMPTY_BORDER);
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                parent.setBorder(CurvedBorder.EMPTY_BORDER);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                parent.setBorder(CurvedBorder.FOCUSED_BORDER);
            }
        };
    }

    public static FocusListener createFocusListenerFor(JTextField textField) {
        Border focusless = SignerTheme.TEXTFIELD_FOCUSLESS;
        Border focused = SignerTheme.TEXTFIELD_FOCUSED;
        return ComponentUtils.createFocusListenerFor((JComponent)textField, focusless, focused);
    }

    public static KeyAdapter createKeyListenerFor(final JComponent component) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 9: {
                        if (keyEvent.isShiftDown()) {
                            component.transferFocusBackward();
                            keyEvent.consume();
                            break;
                        }
                        component.transferFocus();
                        keyEvent.consume();
                        break;
                    }
                }
            }
        };
    }

    public static JPanel layoutCheckbox(JCheckBox checkBox) {
        JPanel focusablePanel = new JPanel(new FlowLayout(0, 0, 0));
        return ComponentUtils.layoutCheckbox(checkBox, focusablePanel);
    }

    public static JPanel layoutCheckbox(JCheckBox checkBox, JPanel panel) {
        checkBox.setMargin(new Insets(0, 0, 0, 0));
        checkBox.setFocusPainted(false);
        JPanel focusablePanel = panel == null ? new JPanel(new FlowLayout(0, 0, 0)) : panel;
        focusablePanel.add(checkBox);
        checkBox.addFocusListener(ComponentUtils.createFocusListenerFor(focusablePanel));
        return focusablePanel;
    }

    public static JComponent makeFocusable(JComponent component) {
        component.setFocusable(true);
        CurvedBorder focuslessB = CurvedBorder.EMPTY_BORDER;
        component.setBorder(focuslessB);
        component.addFocusListener(ComponentUtils.createFocusListenerFor(component, (Border)focuslessB, (Border)CurvedBorder.FOCUSED_BORDER));
        return component;
    }

    public static JComponent addFocusListenerFor(JComponent component) {
        Border focuslessB = component.getBorder();
        component.addFocusListener(ComponentUtils.createFocusListenerFor(component, focuslessB, (Border)CurvedBorder.FOCUSED_FIELD_BORDER));
        return component;
    }

    public static void makeFocusable(JComponent component, String title, Color focusless, Color focused) {
    }

    public static Border createTestTitledBorder(String title, Color focuslessBorder, Color focusedBorder) {
        return TitledCurvedBorder.createTestTitledBorder(title, focuslessBorder, focusedBorder);
    }

    public static void printChildren(Component component) {
        ComponentUtils.printChildren(component, "\t");
    }

    private static void printChildren(Component component, String indent) {
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component child = container.getComponent(i);
                ComponentUtils.printChildren2(child, indent + indent);
            }
        }
    }

    private static void printChildren2(Component component, String indent) {
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component child = container.getComponent(i);
                ComponentUtils.printChildren2(child, indent + indent);
                LOG.trace("{}{}{} {}", (Object)indent, (Object)indent, (Object)child.getClass().getSimpleName(), (Object)child.getName());
            }
        }
    }

    public void setOrder(Vector<Component> order) {
        for (Component comp : order) {
            comp.setFocusTraversalKeys(0, new HashSet<AWTKeyStroke>(Arrays.asList(AWTKeyStroke.getAWTKeyStroke(9, 0))));
            comp.setFocusTraversalKeys(1, new HashSet<AWTKeyStroke>(Arrays.asList(AWTKeyStroke.getAWTKeyStroke(9, 64))));
        }
    }
}

