/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.LineBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaitWindow
extends JWindow {
    protected static final Logger LOG = LogManager.getLogger(WaitWindow.class);
    private static final long serialVersionUID = -674134288341719479L;
    private Component owner = null;
    private JLabel l;

    public WaitWindow(Component owner, String keyName) {
        this.getAccessibleContext().setAccessibleName("WaitWindow");
        this.owner = owner;
        this.init(keyName);
    }

    private void init(String keyName) {
        this.getContentPane().setLayout(new BorderLayout());
        ImageIcon icon = null;
        try {
            icon = IconScalingUtils.createMultiResIconFromImgSet(keyName + ".icon");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new LineBorder(Color.black));
        this.l = new JLabel(icon);
        this.l.setOpaque(false);
        p.add((Component)this.l, "Center");
        if (Messages.getResource(keyName + ".text") != null) {
            this.l = new JLabel(Messages.getResource(keyName + ".text"));
            this.l.setHorizontalAlignment(0);
            this.l.setVerticalAlignment(0);
            this.l.setOpaque(false);
            p.add((Component)this.l, "South");
        }
        this.getContentPane().add((Component)p, "Center");
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setAlwaysOnTop(true);
    }

    public void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    public void showWindow() {
        this.setVisible(true);
        Thread newWindowThread = new Thread("WaitWindow"){

            @Override
            public void run() {
                while (WaitWindow.this.isVisible()) {
                    try {
                        WaitWindow.this.update(WaitWindow.this.getGraphics());
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!WaitWindow.this.isVisible()) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        newWindowThread.start();
    }

    public void setText(String text) {
        this.l.setText(text);
    }
}

