/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.dialog.AbstractDialog;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.DateTimeSpinner;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class VerifyTimeDialog
extends AbstractDialog {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = -1;
    public static final int LOCAL_SERVERTIME_OPTION = 1;
    private int status = -1;
    private static final String COMPONENT_KEY = "dialog.verifytime";
    private Date date;
    private DateTimeSpinner spinner;
    private static JCheckBox useLocalTime;
    private OKAction okAction;

    private VerifyTimeDialog(Dialog owner, Date d) {
        super(owner, true, COMPONENT_KEY);
        this.date = d;
        if (this.okAction == null) {
            this.okAction = new OKAction("dialog.verifytime.action.ok", this);
        }
    }

    private VerifyTimeDialog(Frame owner, Date d) {
        super(owner, true, COMPONENT_KEY);
        this.date = d;
        if (this.okAction == null) {
            this.okAction = new OKAction("dialog.verifytime.action.ok", this);
        }
    }

    public static synchronized int showDialog(Dialog p, Date d) {
        VerifyTimeDialog vtd = new VerifyTimeDialog(p, d);
        vtd.status = -1;
        vtd.setVisible(true);
        return vtd.getState();
    }

    public static synchronized int showDialog(Frame p, Date d) {
        VerifyTimeDialog vtd = new VerifyTimeDialog(p, d);
        vtd.status = -1;
        vtd.setVisible(true);
        return vtd.getState();
    }

    public static boolean isLocalTime() {
        return useLocalTime.isSelected();
    }

    public int getState() {
        return this.status;
    }

    public void setState(int s) {
        this.status = s;
    }

    @Override
    JComponent getMainPanel() {
        double[] colWeights = new double[]{0.1, 0.8, 0.1};
        GridBagPanel panel = new GridBagPanel(colWeights);
        AccessibleJLabel headLabel = new AccessibleJLabel(Messages.getString("dialog.verifytime.head_label"));
        headLabel.setFocusable(true);
        panel.addComponent(panel, headLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        useLocalTime = new JCheckBox(Messages.getString("dialog.verifytime.useexplicittime.label"));
        useLocalTime.addActionListener(e -> this.spinner.setEnabled(!useLocalTime.isSelected()));
        JPanel checkBoxPanel = ComponentUtils.layoutCheckbox(useLocalTime);
        this.spinner = new DateTimeSpinner();
        this.enableSpinner();
        panel.addComponent(panel, checkBoxPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.addComponent(panel, this.spinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 20, 5, 20), 0, 0));
        return panel;
    }

    @Override
    String getContextHelp() {
        return Messages.getString("dialog.verifytime.helpcontext");
    }

    @Override
    List<AbstractSignerAction> getActions() {
        ArrayList<AbstractSignerAction> actions = new ArrayList<AbstractSignerAction>();
        if (this.okAction == null) {
            this.okAction = new OKAction("dialog.verifytime.action.ok", this);
        }
        actions.add(this.okAction);
        return actions;
    }

    private void enableSpinner() {
        useLocalTime.setSelected(true);
        this.spinner.setEnabled(false);
    }

    private class OKAction
    extends AbstractSignerAction {
        private final Component component;

        protected OKAction(String key, Component p) {
            super(key, p);
            this.component = p;
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Date parseDate = new Date();
            if (!useLocalTime.isSelected()) {
                String dateTextField = ((JSpinner.DateEditor)VerifyTimeDialog.this.spinner.getEditor()).getTextField().getText();
                try {
                    parseDate = ((JSpinner.DateEditor)VerifyTimeDialog.this.spinner.getEditor()).getFormat().parse(dateTextField);
                }
                catch (ParseException pe) {
                    LOG.error((Object)pe, (Throwable)pe);
                }
                VerifyTimeDialog.this.date.setTime(parseDate.getTime());
            } else {
                VerifyTimeDialog.this.date = null;
            }
            VerifyTimeDialog.this.status = 0;
            this.component.setVisible(false);
        }
    }
}

