/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.gui.dialog.AccessibleJLabel;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftKeyPINDialog
extends JDialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoftKeyPINDialog.class);
    private static final long serialVersionUID = -2928440650683583562L;
    private static final ResourceBundle resources = ResourceBundle.getBundle(SoftKeyPINDialog.class.getName());
    private char[] keyStorePassword = null;
    private JPasswordField curPINField = null;
    private int result = 2;
    private String displayName = null;
    private ServiceType service = null;
    private JCheckBox pinCacheCheckBox;
    private static Image iconImg;

    public SoftKeyPINDialog(String displayName, ServiceType serviceType, boolean usePinCache) {
        super((Frame)Document.getInstance().getFrame(), true);
        this.displayName = displayName;
        this.service = serviceType;
        this.init(Document.getInstance().getFrame());
        this.pinCacheCheckBox.setSelected(usePinCache);
        this.setVisible(true);
    }

    private void init(Frame p) {
        Frame frame = p;
        this.initComponents();
        this.pack();
        this.curPINField.requestFocusInWindow();
        this.setAlwaysOnTop(true);
        this.setResizable(true);
        this.setLocationRelativeTo(frame);
    }

    private JComponent buildInfoPanel() {
        AccessibleJLabel l;
        JPanel certificateInfo = new JPanel(new GridBagLayout());
        Insets insets5 = new Insets(5, 15, 5, 5);
        JPanel certificatePanel = new JPanel(new GridBagLayout());
        certificatePanel = ComponentUtils.setTitledFocusableBorder(certificatePanel, resources.getString("pin.dialog.panel.info"));
        int row = 0;
        String labelText = resources.getString("pin.dialog.label.info");
        if (ServiceType.SOFTKEY == this.service) {
            labelText = resources.getString("pin.dialog.softkey.label.info");
            l = new AccessibleJLabel(labelText + " " + this.displayName);
        } else if (ServiceType.SIGN_SERVICE == this.service) {
            labelText = resources.getString("pin.dialog.netsignkeylabel.info");
            l = new AccessibleJLabel(labelText);
        } else {
            l = new AccessibleJLabel(labelText + " " + this.displayName);
        }
        certificatePanel.add((Component)l, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
        certificateInfo.add(certificatePanel);
        return certificateInfo;
    }

    private JComponent buildCenterPanel() {
        JPanel centerPanel = new JPanel(new BorderLayout());
        Insets insets5 = new Insets(5, 15, 5, 5);
        JPanel pinPanel = new JPanel(new GridBagLayout());
        pinPanel = ComponentUtils.setTitledFocusableBorder(pinPanel, resources.getString("pin.dialog.panel.pin"));
        int row = 0;
        JLabel pinLabel = new JLabel(resources.getString("pin.dialog.label.pin"));
        pinPanel.add((Component)pinLabel, new GridBagConstraints(0, row, 2, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
        ++row;
        JPasswordField pf1 = new JPasswordField(20);
        pf1.addFocusListener(ComponentUtils.createFocusListenerFor(pf1));
        pinLabel.setLabelFor(pf1);
        pf1.setDocument(new PlainDocument(new StringContent(20)));
        pf1.setMinimumSize(pf1.getPreferredSize());
        this.curPINField = pf1;
        pinPanel.add((Component)this.curPINField, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, insets5, 0, 0));
        this.pinCacheCheckBox = new JCheckBox(resources.getString("pin.dialog.checkbox.use.pincache"));
        pinPanel.add((Component)ComponentUtils.layoutCheckbox(this.pinCacheCheckBox), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, insets5, 0, 0));
        centerPanel.add((Component)pinPanel, "Center");
        return centerPanel;
    }

    private JComponent buildControlPanel() {
        JButton buttonOk = new JButton("OK");
        buttonOk.setToolTipText(resources.getString("pin.dialog.ok.bnt.tooltip"));
        this.getRootPane().setDefaultButton(buttonOk);
        buttonOk.addActionListener(action -> {
            this.keyStorePassword = this.curPINField.getPassword();
            this.closeDialog(0);
        });
        JButton buttonCancel = new JButton(resources.getString("pin.dialog.cancel.bnt"));
        buttonCancel.setToolTipText(resources.getString("pin.dialog.cancel.bnt.tooltip"));
        buttonCancel.addActionListener(action -> this.closeDialog(2));
        this.getRootPane().registerKeyboardAction(buttonCancel.getAction(), "Cancel Command", KeyStroke.getKeyStroke(27, 0, false), 2);
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)buttonOk, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        p.add((Component)buttonCancel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        return p;
    }

    private void initComponents() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout(10, 10));
        content.add((Component)this.buildInfoPanel(), "North");
        content.add((Component)this.buildCenterPanel(), "Center");
        content.add((Component)this.buildControlPanel(), "South");
        String title = resources.getString("pin.dialog.title");
        this.setTitle(title);
        if (iconImg != null) {
            ((Frame)this.getOwner()).setIconImage(iconImg);
        }
    }

    protected void closeDialog(int r) {
        this.result = r;
        log.trace(this.result == 0 ? "close mit buttonOk" : "close mit buttonCancel");
        this.setVisible(false);
        this.dispose();
        log.info("PIN-Dialog -> {}", (Object)(this.isUsePinCache() ? "PIN voruebergehend merken." : "PIN nicht merken."));
    }

    public int getResult() {
        return this.result;
    }

    public char[] getPIN() {
        log.info("PIN-Dialog...");
        if (this.keyStorePassword == null || this.keyStorePassword.length == 0) {
            return new char[0];
        }
        return (char[])this.keyStorePassword.clone();
    }

    public static Image getIconImg() {
        return iconImg;
    }

    public static void setIconImg(Image i) {
        iconImg = i;
    }

    public boolean isUsePinCache() {
        log.trace("pinCacheCheckBox selected : {}", (Object)this.pinCacheCheckBox.isSelected());
        return this.pinCacheCheckBox.isSelected();
    }

    public void setUsePinCache(boolean usePinCache) {
        log.trace("set pinCacheCheckBox selected : {}", (Object)usePinCache);
        this.pinCacheCheckBox.setSelected(usePinCache);
    }

    public static enum ServiceType {
        SOFTKEY,
        SIGN_SERVICE;

    }
}

