/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.AccessibleRadioButton;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RenameFileDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    WorkingStep.Repeat returnValue = WorkingStep.Repeat.CANCEL;
    private File file;
    private boolean isZipArchiv = false;
    private AccessibleRadioButton overwriteButton;
    private AccessibleRadioButton skipButton;
    private JCheckBox repeatCheckBox;

    public RenameFileDialog(File inpFile) {
        super(Document.getInstance().getFrame());
        this.file = inpFile;
        this.setTitle(Messages.getString("dialog.file.exist.title"));
        this.init();
        this.setResizable(true);
    }

    public RenameFileDialog(File inpFile, boolean zipfile) {
        this.file = inpFile;
        this.isZipArchiv = zipfile;
        this.setTitle(Messages.getString("dialog.file.exist.zip.title"));
        this.init();
        this.setResizable(true);
    }

    private void init() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel southPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{7};
        gridBagLayout.columnWidths = new int[]{0, 7};
        southPanel.setLayout(gridBagLayout);
        southPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 20, 20));
        this.getContentPane().add((Component)southPanel, "Center");
        if (!this.isZipArchiv) {
            this.repeatCheckBox = new JCheckBox(Messages.getString("dialog.file.exist.repeat"));
            this.repeatCheckBox.setToolTipText(MultiLineTooltips.wrapToolTip(Messages.getString("dialog.file.exist.repeat.tooltip"), 80));
            JPanel checkBoxPanel = ComponentUtils.layoutCheckbox(this.repeatCheckBox);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            southPanel.add((Component)checkBoxPanel, gridBagConstraints1);
        }
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new GridLayout(3, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        southPanel.add((Component)radioButtonPanel, gridBagConstraints);
        this.overwriteButton = new AccessibleRadioButton(Messages.getString("dialog.file.exist.button0"), Messages.getString("dialog.file.exist.button0.tooltip"));
        this.overwriteButton.setName("overwriteButton");
        if (!this.isZipArchiv) {
            buttonGroup.add(this.overwriteButton);
            radioButtonPanel.add(this.overwriteButton);
        }
        this.skipButton = new AccessibleRadioButton();
        this.skipButton.setName("renameButton");
        if (this.isZipArchiv) {
            this.skipButton.setText(Messages.getString("dialog.file.exist.zip.button1"));
            this.skipButton.setToolTipText(Messages.getString("dialog.file.exist.zip.button1.tooltip"));
        } else {
            this.skipButton.setText(Messages.getString("dialog.file.exist.button1"));
            this.skipButton.setToolTipText(Messages.getString("dialog.file.exist.button1.tooltip"));
        }
        buttonGroup.add(this.skipButton);
        radioButtonPanel.add(this.skipButton);
        AccessibleRadioButton cancelProcessButton = new AccessibleRadioButton();
        cancelProcessButton.setName("cancelButton");
        if (this.isZipArchiv) {
            cancelProcessButton.setText(Messages.getString("dialog.file.exist.zip.button2"));
            cancelProcessButton.setToolTipText(Messages.getString("dialog.file.exist.zip.button2.tooltip"));
        } else {
            cancelProcessButton.setText(Messages.getString("dialog.file.exist.button2"));
            cancelProcessButton.setToolTipText(Messages.getString("dialog.file.exist.button2.tooltip"));
        }
        buttonGroup.add(cancelProcessButton);
        radioButtonPanel.add(cancelProcessButton);
        JPanel textPanel = new JPanel();
        textPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 20));
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        gridBagLayout1.columnWidths = new int[]{3, 10};
        gridBagLayout1.rowHeights = new int[]{1, 1, 1};
        textPanel.setLayout(gridBagLayout1);
        this.getContentPane().add((Component)textPanel, "North");
        JLabel aTextArea = new JLabel();
        aTextArea.setOpaque(false);
        if (this.isZipArchiv) {
            aTextArea.setText(Messages.getString("dialog.file.exist.zip.message"));
        } else {
            aTextArea.setText(Messages.getString("dialog.file.exist.message"));
        }
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        textPanel.add((Component)aTextArea, gridBagConstraints2);
        JLabel dateiLabel = new JLabel(Messages.getString("dialog.file.exist.file.name"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 15, 0, 0);
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridx = 0;
        textPanel.add((Component)dateiLabel, gridBagConstraints4);
        AccessibleJLabel dateiNameLabel = new AccessibleJLabel(this.file.getName());
        dateiNameLabel.getAccessibleContext().setAccessibleName(dateiLabel.getText());
        dateiNameLabel.getAccessibleContext().setAccessibleDescription(dateiNameLabel.getText());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints3.ipadx = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridx = 1;
        textPanel.add((Component)dateiNameLabel, gridBagConstraints3);
        JLabel dateiPath = new JLabel(Messages.getString("dialog.file.exist.file.path"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 15, 0, 0);
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.gridx = 0;
        textPanel.add((Component)dateiPath, gridBagConstraints6);
        String absolutePath = this.file.getParentFile().getAbsolutePath();
        String wrappedPath = MultiLineTooltips.wrapToolTip(absolutePath, 80);
        AccessibleJLabel dateitxtpathLabel = new AccessibleJLabel(wrappedPath);
        dateitxtpathLabel.getAccessibleContext().setAccessibleName(dateiPath.getText());
        dateitxtpathLabel.getAccessibleContext().setAccessibleDescription(absolutePath);
        dateitxtpathLabel.setToolTipText(wrappedPath);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints7.ipadx = 0;
        gridBagConstraints7.ipady = 10;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.gridx = 1;
        textPanel.add((Component)dateitxtpathLabel, gridBagConstraints7);
        AccessibleJLabel subTitle = new AccessibleJLabel(Messages.getString("dialog.file.exist.subtitle"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints8.gridy = 3;
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridwidth = 2;
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.anchor = 17;
        textPanel.add((Component)subTitle, gridBagConstraints8);
        JButton okButton = new JButton();
        okButton.setName("OK");
        if (this.isZipArchiv) {
            okButton.setText(Messages.getString("dialog.file.exist.zip.button3"));
            okButton.setToolTipText(Messages.getString("dialog.file.exist.zip.button3.tooltip"));
        } else {
            okButton.setText(Messages.getString("dialog.file.exist.button3"));
            okButton.setToolTipText(Messages.getString("dialog.file.exist.button3.tooltip"));
        }
        GridBagConstraints gridBagConstraintsOK = new GridBagConstraints();
        gridBagConstraintsOK.fill = 0;
        gridBagConstraintsOK.weightx = 1.0;
        gridBagConstraintsOK.gridy = 2;
        gridBagConstraintsOK.gridx = 0;
        gridBagConstraintsOK.insets = new Insets(5, 5, 5, 5);
        southPanel.add((Component)okButton, gridBagConstraintsOK);
        okButton.addActionListener(e -> this.dispose());
        okButton.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                    ((JButton)e.getSource()).doClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.pack();
        this.setLocationRelativeTo(new Frame());
        this.setResizable(true);
        this.setModal(true);
        if (this.isZipArchiv) {
            this.skipButton.setSelected(true);
            okButton.requestFocus();
        } else {
            this.overwriteButton.setSelected(true);
            okButton.requestFocus();
        }
    }

    public WorkingStep.Repeat showDialog() {
        this.setVisible(true);
        this.requestFocus();
        if (this.skipButton.isSelected()) {
            if (!this.isZipArchiv) {
                if (this.repeatCheckBox != null && this.repeatCheckBox.isSelected()) {
                    return WorkingStep.Repeat.SKIP_ALL;
                }
                return WorkingStep.Repeat.SKIP;
            }
            return WorkingStep.Repeat.ZIP_ENTRY_RENAME;
        }
        if (this.overwriteButton != null && this.overwriteButton.isSelected()) {
            if (this.repeatCheckBox != null && this.repeatCheckBox.isSelected()) {
                return WorkingStep.Repeat.OVERWRITE_ALL;
            }
            return WorkingStep.Repeat.OVERWRITE;
        }
        return WorkingStep.Repeat.CANCEL;
    }
}

