/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.model.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class RedundantDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    private static void initGUI(Container contentRoot, JComponent content, int numOptions, int defaultOptions, String key, int messageType, ActionListener actionListener) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)content, "Center");
        panel.add((Component)RedundantDialog.buildIconPanel(messageType, numOptions), "West");
        panel.add((Component)RedundantDialog.buildButtonPanel(numOptions, defaultOptions, key, actionListener), "South");
        contentRoot.add(panel);
    }

    protected static JComponent buildButtonPanel(int numOptions, int defaultOptions, String key, ActionListener actionListener) {
        JPanel buttonPanel = new JPanel();
        JPanel leftPanel = new JPanel(new FlowLayout(3));
        JPanel centerPanel = new JPanel(new FlowLayout(1));
        JPanel rightPanel = new JPanel(new FlowLayout(4));
        buttonPanel.setLayout(new GridLayout(1, 3));
        for (int i = 0; i < numOptions; ++i) {
            JButton aButton = new JButton(Messages.getString("dialog." + key + ".option" + i));
            aButton.addActionListener(actionListener);
            aButton.setName(String.valueOf(i));
            centerPanel.add(aButton);
            if (i != defaultOptions) continue;
            aButton.requestFocusInWindow();
        }
        buttonPanel.add(leftPanel);
        buttonPanel.add(centerPanel);
        buttonPanel.add(rightPanel);
        return buttonPanel;
    }

    protected static JComponent buildIconPanel(int messageType, int numOptions) {
        if (messageType == -1) {
            int n = messageType = numOptions == 1 ? 1 : 3;
        }
        if (messageType == -1) {
            return null;
        }
        AccessibleJLabel iconLabel = new AccessibleJLabel();
        iconLabel.setFocusable(true);
        switch (messageType) {
            case 1: {
                iconLabel.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                iconLabel.getAccessibleContext().setAccessibleName(Messages.getString("dialog.optionPane.information"));
                break;
            }
            case 2: {
                iconLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                iconLabel.getAccessibleContext().setAccessibleName(Messages.getString("dialog.optionPane.warning"));
                break;
            }
            case 3: {
                iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
                iconLabel.getAccessibleContext().setAccessibleName(Messages.getString("dialog.optionPane.question"));
                break;
            }
            default: {
                iconLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                iconLabel.getAccessibleContext().setAccessibleName(Messages.getString("dialog.optionPane.error"));
            }
        }
        iconLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        iconLabel.setOpaque(true);
        return iconLabel;
    }

    public static synchronized int showDialog(Component parent, String key, String title, String message, int numOptions, int paneOption, boolean force, boolean saveConfig) {
        int messageType;
        if (!force && Config.getInstance().isSuppressed(key)) {
            return 0;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints wholeNextRow = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0);
        JLabel messageLabel = RedundantDialog.createLabelWithHtml(message);
        panel.add((Component)messageLabel, wholeNextRow);
        JCheckBox box = null;
        if (saveConfig) {
            box = new JCheckBox(Messages.getString("dialog.doNotShowAnymore"));
            JPanel boxPanel = ComponentUtils.layoutCheckbox(box);
            if (!force) {
                panel.add((Component)boxPanel, wholeNextRow);
            }
        }
        if ((messageType = paneOption) == -1) {
            messageType = numOptions == 1 ? 1 : 3;
        }
        JDialog aDialog = RedundantDialog.createDialogFrom(parent);
        aDialog.setTitle(title);
        InnerActionListener actionListener = new InnerActionListener(aDialog);
        RedundantDialog.initGUI(aDialog.getContentPane(), panel, numOptions, 0, key, messageType, actionListener);
        aDialog.setModal(true);
        aDialog.pack();
        aDialog.setLocationRelativeTo(parent);
        aDialog.setAlwaysOnTop(true);
        aDialog.setAlwaysOnTop(false);
        aDialog.setVisible(true);
        if (saveConfig && box.isSelected()) {
            Config.getInstance().addSuppressedRedundantDialog(key);
        }
        return actionListener.answer;
    }

    public static synchronized int showSimpleOneOptionDialog(Component parent, String title, String message, int paneOption) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints wholeNextRow = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0);
        JLabel messageLabel = RedundantDialog.createLabelWithHtml(message);
        panel.add((Component)messageLabel, wholeNextRow);
        JDialog aDialog = RedundantDialog.createDialogFrom(parent);
        aDialog.setTitle(title);
        InnerActionListener actionListener = new InnerActionListener(aDialog);
        RedundantDialog.initGUI(aDialog.getContentPane(), panel, 1, 0, "about", paneOption, actionListener);
        aDialog.setModal(true);
        aDialog.pack();
        aDialog.setLocationRelativeTo(parent);
        aDialog.setAlwaysOnTop(false);
        aDialog.setVisible(true);
        return actionListener.answer;
    }

    private static JLabel createLabelWithHtml(String message) {
        boolean isHtml;
        JLabel messageLabel = new JLabel();
        ComponentUtils.makeFocusable(messageLabel);
        if (message == null) {
            messageLabel.setText("<html></html>");
            return messageLabel;
        }
        boolean bl = isHtml = message.indexOf("<html") != -1;
        if (isHtml) {
            messageLabel.setText(message);
        } else {
            messageLabel.setText("<html>" + message + "</html>");
        }
        return messageLabel;
    }

    private static JDialog createDialogFrom(Component parent) {
        JDialog aDialog;
        if (parent instanceof Frame) {
            Frame frame = (Frame)parent;
            aDialog = new JDialog(frame);
        } else if (parent instanceof Dialog) {
            Dialog dialog = (Dialog)parent;
            aDialog = new JDialog(dialog);
        } else {
            aDialog = new JDialog();
        }
        ImageIcon titleIcon = (ImageIcon)UIManager.get("Dialog.TitleIcon");
        aDialog.setIconImage(titleIcon.getImage());
        return aDialog;
    }

    static class InnerActionListener
    implements ActionListener {
        private JDialog dialog;
        int answer = -1;

        public InnerActionListener(JDialog dialog) {
            this.dialog = dialog;
        }

        public int getAnswer() {
            return this.answer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = e.getSource();
            if (!(object instanceof JButton)) {
                return;
            }
            JButton bt = (JButton)object;
            bt.getRootPane().setVisible(false);
            this.dialog.setVisible(false);
            this.answer = Integer.parseInt(bt.getName());
        }
    }
}

