/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;

public class PasswordDialog
extends JDialog {
    private static final long serialVersionUID = 7648470829502596631L;
    private static final String STRONGER = "<html><span style=\"color:#00804B;font-size:2em;\">&#9673;&#9673;&#9673;&#9673;&#9673;</span></html> ";
    private static final String STRONG = "<html><span style=\"color:#00804B;font-size:2em;\">&#9673;&#9673;&#9673;&#9673;</span><span style=\"color:#949494;font-size:2em;\">&#9737;</span></html>";
    private static final String MEDIOCRE = "<html><span style=\"color:#00804B;font-size:2em;\">&#9673;&#9673;&#9673;</span><span style=\"color:#949494;font-size:2em;\">&#9737;&#9737;</span></html>";
    private static final String WEAK = "<html><span style=\"color:#DE023A;font-size:2em;\">&#9678;&#9678;</span><span style=\"color:#949494;font-size:2em;\">&#9737;&#9737;&#9737;</span></html>";
    private static final String TOO_WEAK = "<html><span style=\"color:#DE023A;font-size:2em;\">&#9678;</span><span style=\"color:#949494;font-size:2em;\">&#9737;&#9737;&#9737;&#9737;</span></html>";
    private static final String EMPTY = "<html><span style=\"color:#949494;font-size:2em;\">&#9737;&#9737;&#9737;&#9737;&#9737;</span></html>";
    private static final String DIALOG_PASSWORD_QUALITY_EMPTY = "dialog.password.quality.empty";
    private static final String DIALOG_PASSWORD_PIN_EMPTY_TOOLTIP = "dialog.password.pin.empty.tooltip";
    private boolean usePassword = false;
    private String password = null;
    private JPasswordField curPINField = null;
    private JLabel qualityBull;
    private JLabel passwordLabel;
    private JPanel buttonPanel;
    private Frame frame = Document.getInstance().getFrame();
    private final boolean isEncryption;
    private final String fileName;
    private JButton saveButton;
    private JCheckBox plainTextCheckBox;

    public PasswordDialog(String fileName, boolean isEncryption) {
        super((Frame)Document.getInstance().getFrame(), true);
        this.fileName = fileName;
        this.isEncryption = isEncryption;
        this.setTitle(Messages.getString("dialog.password.title"));
        this.initComponents();
        this.initGUI();
        this.pack();
        this.setLocationRelativeTo(this.frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PasswordDialog.this.usePassword = false;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                PasswordDialog.this.usePassword = false;
            }
        });
    }

    private void initComponents() {
        this.passwordLabel = new JLabel(Messages.getString("dialog.password.text"));
        this.curPINField = new JPasswordField(20);
        this.passwordLabel.setLabelFor(this.curPINField);
        if (this.isEncryption) {
            this.curPINField.setToolTipText(Messages.getString(DIALOG_PASSWORD_PIN_EMPTY_TOOLTIP));
        } else {
            this.curPINField.setToolTipText(null);
        }
        this.curPINField.setDocument(new PlainDocument(new StringContent(20)));
        this.curPINField.setEchoChar('*');
        this.curPINField.addFocusListener(ComponentUtils.createFocusListenerFor(this.curPINField));
        this.curPINField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                PasswordDialog.this.checkQuality();
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    PasswordDialog.this.password = PasswordDialog.this.curPINField.getText();
                    PasswordDialog.this.usePassword = PasswordDialog.this.password != null && !PasswordDialog.this.password.isEmpty();
                    PasswordDialog.this.setVisible(false);
                }
            }
        });
        if (this.isEncryption) {
            this.qualityBull = new JLabel(EMPTY);
            this.qualityBull.setToolTipText(Messages.getString(DIALOG_PASSWORD_QUALITY_EMPTY));
            this.qualityBull.getAccessibleContext().setAccessibleName(Messages.getString(DIALOG_PASSWORD_QUALITY_EMPTY));
            this.qualityBull.setFocusable(true);
            this.qualityBull.addFocusListener(ComponentUtils.createFocusListenerFor(this.qualityBull));
        }
        this.plainTextCheckBox = new JCheckBox(" " + Messages.getString("dialog.password.plaintext.title"));
        this.plainTextCheckBox.addActionListener(e -> {
            if (this.plainTextCheckBox.isSelected()) {
                this.curPINField.setEchoChar('\u0000');
            } else {
                this.curPINField.setEchoChar('*');
            }
            this.curPINField.revalidate();
            this.curPINField.repaint();
        });
        ComponentUtils.layoutCheckbox(this.plainTextCheckBox);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 3));
        this.buttonPanel.add(new JPanel());
        this.buttonPanel.add(this.createButtonPanel());
        this.buttonPanel.add(new JPanel());
    }

    private JPanel createButtonPanel() {
        JPanel centerPanel = new JPanel(new GridLayout(1, 2));
        OkAction okAction = new OkAction("button.ok", this.frame);
        CancelAction cancelAction = new CancelAction("button.abort", this.frame);
        this.saveButton = new IconButton();
        this.saveButton.setAction(okAction);
        if (this.isEncryption) {
            this.saveButton.setEnabled(false);
        }
        IconButton cancelButton = new IconButton();
        ((AbstractButton)cancelButton).setAction(cancelAction);
        ((AbstractButton)cancelButton).setEnabled(true);
        centerPanel.add(this.saveButton);
        centerPanel.add(cancelButton);
        return centerPanel;
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JPanel(), "North");
        JPanel pinFieldPanel = new JPanel(new BorderLayout());
        pinFieldPanel.add((Component)this.passwordLabel, "West");
        pinFieldPanel.add((Component)this.curPINField, "Center");
        JPanel eastPanel = new JPanel(new FlowLayout());
        if (this.qualityBull != null) {
            eastPanel.add(this.qualityBull);
        }
        if (this.plainTextCheckBox != null) {
            eastPanel.add((JPanel)this.plainTextCheckBox.getParent());
        }
        pinFieldPanel.add((Component)eastPanel, "East");
        JLabel passwordRequest = new JLabel(MessageFormat.format(Messages.getString("dialog.password.message"), this.fileName));
        passwordRequest.setFocusable(true);
        passwordRequest.addFocusListener(ComponentUtils.createFocusListenerFor(passwordRequest));
        JPanel passwordPanel = new JPanel(new BorderLayout());
        passwordPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 0));
        passwordPanel.add((Component)pinFieldPanel, "South");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 20));
        centerPanel.add((Component)passwordRequest, "North");
        centerPanel.add((Component)passwordPanel, "Center");
        this.getContentPane().add((Component)centerPanel, "Center");
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    protected void checkQuality() {
        if (this.qualityBull != null) {
            this.password = this.curPINField.getText();
            if (this.password != null && !this.password.trim().isEmpty()) {
                this.saveButton.setEnabled(true);
                int passwordQualityScore = this.checkPassword(this.password);
                if (passwordQualityScore == 0) {
                    if (this.password.trim().isEmpty()) {
                        this.updatyQualityDisplay(TOO_WEAK, Messages.getString("dialog.password.quality.tooweak"));
                    } else {
                        this.qualityBull.setText(EMPTY);
                        this.qualityBull.setToolTipText(Messages.getString(DIALOG_PASSWORD_QUALITY_EMPTY));
                        this.curPINField.setToolTipText(Messages.getString(DIALOG_PASSWORD_PIN_EMPTY_TOOLTIP));
                    }
                } else if (passwordQualityScore < 16) {
                    this.updatyQualityDisplay(TOO_WEAK, Messages.getString("dialog.password.quality.tooweak"));
                } else if (passwordQualityScore < 25) {
                    this.updatyQualityDisplay(WEAK, Messages.getString("dialog.password.quality.weak"));
                } else if (passwordQualityScore < 35) {
                    this.updatyQualityDisplay(MEDIOCRE, Messages.getString("dialog.password.quality.mediocre"));
                } else if (passwordQualityScore < 45) {
                    this.updatyQualityDisplay(STRONG, Messages.getString("dialog.password.quality.strong"));
                } else {
                    this.updatyQualityDisplay(STRONGER, Messages.getString("dialog.password.quality.stronger"));
                }
            } else {
                this.usePassword = false;
                this.password = null;
                this.qualityBull.setText(EMPTY);
                this.saveButton.setEnabled(false);
                if (this.isEncryption) {
                    this.curPINField.setToolTipText(Messages.getString(DIALOG_PASSWORD_PIN_EMPTY_TOOLTIP));
                }
            }
        }
    }

    private void updatyQualityDisplay(String tooWeak, String tooltip) {
        this.qualityBull.setText(tooWeak);
        this.qualityBull.setToolTipText(tooltip);
        this.curPINField.setToolTipText(tooltip);
    }

    private int checkPassword(String passwd) {
        int passwordQualityScore = 0;
        Pattern p = Pattern.compile("(.*[!,@,#,$,%,^,&,*,?,_,~].*[!,@,#,$,%,^,&,*,?,_,~])");
        Matcher m = p.matcher(passwd);
        boolean find = m.find();
        if (find) {
            passwordQualityScore += 5;
        }
        if (find = (m = (p = Pattern.compile("([a-z].*[A-Z])|([A-Z].*[a-z])")).matcher(passwd)).find()) {
            passwordQualityScore += 2;
        }
        p = Pattern.compile("([a-zA-Z])");
        m = p.matcher(passwd);
        boolean find1 = m.find();
        p = Pattern.compile("([0-9])");
        m = p.matcher(passwd);
        boolean find2 = m.find();
        if (find1 && find2) {
            passwordQualityScore += 2;
        }
        if (find = (m = (p = Pattern.compile("([a-zA-Z0-9].*[!,@,#,$,%,^,&,*,?,_,~])|([!,@,#,$,%,^,&,*,?,_,~].*[a-zA-Z0-9])")).matcher(passwd)).find()) {
            passwordQualityScore += 2;
        }
        if (find = (m = (p = Pattern.compile(".[!,@,#,$,%,^,&,*,?,_,~]")).matcher(passwd)).find()) {
            passwordQualityScore += 5;
        }
        if (find = (m = (p = Pattern.compile("(.*[0-9].*[0-9].*[0-9])")).matcher(passwd)).find()) {
            passwordQualityScore += 5;
        }
        if (find = (m = (p = Pattern.compile("\\d+")).matcher(passwd)).find()) {
            passwordQualityScore += 5;
        }
        if (find = (m = (p = Pattern.compile("[A-Z]")).matcher(passwd)).find()) {
            passwordQualityScore += 5;
        }
        if (find = (m = (p = Pattern.compile("[a-z]")).matcher(passwd)).find()) {
            ++passwordQualityScore;
        }
        passwordQualityScore = passwd.length() < 2 ? (passwordQualityScore += 0) : (passwd.length() < 4 ? (passwordQualityScore += 3) : (passwd.length() < 7 ? (passwordQualityScore += 6) : (passwd.length() < 9 ? (passwordQualityScore += 12) : (passwordQualityScore += 18))));
        return passwordQualityScore;
    }

    public boolean usePassword() {
        return this.usePassword;
    }

    public String getPassword() {
        return this.password;
    }

    public class OkAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 6981064717369025015L;

        public OkAction(String keyname, Component parent) {
            super(keyname, parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            char[] chars = PasswordDialog.this.curPINField.getPassword();
            PasswordDialog.this.password = chars != null ? String.valueOf(chars) : "";
            PasswordDialog.this.usePassword = PasswordDialog.this.password != null && !PasswordDialog.this.password.isEmpty();
            PasswordDialog.this.setVisible(false);
        }
    }

    public class CancelAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;

        public CancelAction(String keyname, Component parent) {
            super(keyname, parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PasswordDialog.this.usePassword = false;
            PasswordDialog.this.setVisible(false);
        }
    }
}

