/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.AbstractDialog;
import de.bos_bremen.ecard.client.gui.dialog.CancelAction;
import de.bos_bremen.ecard.client.gui.dialog.LicenceDocument;
import de.bos_bremen.ecard.client.gui.dialog.LicenceDocumentKeyListener;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.licence.LicenceKeyEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class LicenceKeyDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JPanel licencePanel;
    private JTextArea licenceText1;
    private JTextArea licenceText2;
    private JTextArea licenceText3;
    private JTextArea licenceText4;
    private OKAction okAction;
    private CancelAction cancelAction;
    private static final String COMPONENT_KEY = "dialog.licencekey";

    public LicenceKeyDialog(Frame owner) {
        super(owner, true, COMPONENT_KEY);
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(owner);
        this.pack();
    }

    @Override
    public JComponent getMainPanel() {
        JEditorPane htmlView = new JEditorPane(new HTMLEditorKit().getContentType(), "");
        this.createLicenceFields(htmlView);
        String licenceDescription = Messages.getString("dialog.licencekey.head_label");
        if (Config.getInstance().isUsePeriod().booleanValue() && Config.getInstance().getPeriod() != null && Config.getInstance().getPeriod() == -1L) {
            licenceDescription = Messages.getString("dialog.licencekey.trial.message");
        }
        htmlView.setText(licenceDescription);
        htmlView.getAccessibleContext().setAccessibleName(licenceDescription);
        htmlView.setBorder(CurvedBorder.EMPTY_BORDER);
        htmlView.addFocusListener(ComponentUtils.createFocusListenerFor(htmlView));
        htmlView.setOpaque(false);
        htmlView.setSelectionColor(SignerTheme.LIST_BACKGROUND2);
        htmlView.setEditable(false);
        Font font = UIManager.getFont("Label.font");
        String bodyRole = "body{ font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)htmlView.getDocument()).getStyleSheet().addRule(bodyRole);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)htmlView, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(20, 20, 20, 20), 0, 0));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)panel, "Center");
        mainPanel.add((Component)this.licencePanel, "South");
        return mainPanel;
    }

    private void createLicenceFields(JEditorPane htmlView) {
        Border focusless = SignerTheme.TEXTFIELD_FOCUSLESS;
        Border focused = SignerTheme.TEXTFIELD_FOCUSED;
        this.licencePanel = new GridBagPanel();
        this.licenceText1 = new JTextArea(1, 4);
        this.licenceText1.addFocusListener(ComponentUtils.createFocusListenerFor((JComponent)this.licenceText1, focusless, focused));
        this.licenceText1.setBorder(focusless);
        this.licenceText2 = new JTextArea(1, 4);
        this.licenceText2.setBorder(focusless);
        this.licenceText2.addFocusListener(ComponentUtils.createFocusListenerFor((JComponent)this.licenceText2, focusless, focused));
        this.licenceText3 = new JTextArea(1, 4);
        this.licenceText3.setBorder(focusless);
        this.licenceText3.addFocusListener(ComponentUtils.createFocusListenerFor((JComponent)this.licenceText3, focusless, focused));
        this.licenceText4 = new JTextArea(1, 4);
        this.licenceText4.setBorder(focusless);
        this.licenceText4.addFocusListener(ComponentUtils.createFocusListenerFor((JComponent)this.licenceText4, focusless, focused));
        this.licencePanel.add((Component)this.licenceText1, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 15, 3), 0, 0));
        this.licencePanel.add((Component)new JLabel("-"), new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 15, 3), 0, 0));
        this.licencePanel.add((Component)this.licenceText2, new GridBagConstraints(2, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 15, 3), 0, 0));
        this.licencePanel.add((Component)new JLabel("-"), new GridBagConstraints(3, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 15, 3), 0, 0));
        this.licencePanel.add((Component)this.licenceText3, new GridBagConstraints(4, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 15, 3), 0, 0));
        this.licencePanel.add((Component)new JLabel("-"), new GridBagConstraints(5, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 15, 3), 0, 0));
        this.licencePanel.add((Component)this.licenceText4, new GridBagConstraints(7, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 15, 3), 0, 0));
        this.licenceText1.setDocument(new LicenceDocument(null, this.licenceText2));
        this.licenceText2.setDocument(new LicenceDocument(this.licenceText1, this.licenceText3));
        this.licenceText3.setDocument(new LicenceDocument(this.licenceText2, this.licenceText4));
        this.licenceText4.setDocument(new LicenceDocument(this.licenceText3, null));
        this.licenceText1.addKeyListener(new LicenceDocumentKeyListener(htmlView, this.licenceText2));
        this.licenceText2.addKeyListener(new LicenceDocumentKeyListener(this.licenceText1, this.licenceText3));
        this.licenceText3.addKeyListener(new LicenceDocumentKeyListener(this.licenceText2, this.licenceText4));
        this.licenceText4.addKeyListener(new LicenceDocumentKeyListener(this.licenceText3, null));
    }

    @Override
    String getContextHelp() {
        return null;
    }

    @Override
    List<AbstractSignerAction> getActions() {
        ArrayList<AbstractSignerAction> actions = new ArrayList<AbstractSignerAction>();
        if (this.okAction == null) {
            this.okAction = new OKAction("dialog.licencekey.action.ok", this);
        }
        if (this.cancelAction == null) {
            this.cancelAction = new CancelAction("dialog.licencekey.action.cancel", this);
        }
        actions.add(this.okAction);
        actions.add(this.cancelAction);
        this.getRootPane().registerKeyboardAction(this.cancelAction, "Cancel Command", KeyStroke.getKeyStroke(27, 0, false), 2);
        return actions;
    }

    public static void main(String ... args) {
        LicenceKeyDialog licenceKeyDialog = new LicenceKeyDialog(null);
        licenceKeyDialog.setVisible(true);
        System.exit(0);
    }

    private class OKAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;
        private final Component comp;

        protected OKAction(String key, Component parentComponent) {
            super(key, parentComponent);
            this.comp = parentComponent;
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object newLicence = "";
            newLicence = (String)newLicence + LicenceKeyDialog.this.licenceText1.getText() + LicenceKeyDialog.this.licenceText2.getText() + LicenceKeyDialog.this.licenceText3.getText() + LicenceKeyDialog.this.licenceText4.getText();
            Preferences signerNode = Preferences.userRoot().node("de/bos_bremen/governikus_signer");
            if (signerNode == null) {
                return;
            }
            try {
                LicenceKeyEngine licenceKeyEngine;
                String oldLicence = signerNode.get("licence", "");
                if (!oldLicence.isEmpty() && ((licenceKeyEngine = new LicenceKeyEngine(oldLicence)).getLicenceKey().equalsIgnoreCase((String)newLicence) || licenceKeyEngine.getFormattedLicenceKey().equalsIgnoreCase((String)newLicence))) {
                    JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable(new JLabel(Messages.getString("dialog.licencekey.licence_equals")));
                    JOptionPane.showMessageDialog(LicenceKeyDialog.this, messageLabel, Messages.getString("dialog.licencekey.licence_equals.title"), 0);
                    return;
                }
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
            }
            try {
                LicenceKeyEngine licenceKeyEngine = new LicenceKeyEngine((String)newLicence);
                signerNode.put("licence", licenceKeyEngine.getLicenceKey());
                SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
                signerNode.put("period", Base64.getEncoder().encodeToString(df.format(new Date()).getBytes(StandardCharsets.UTF_8)));
                JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable(new JLabel(Messages.getString("dialog.licencekey.licence_ok")));
                JOptionPane.showMessageDialog(LicenceKeyDialog.this, messageLabel, Messages.getString("dialog.licencekey.licence_ok.title"), 1);
            }
            catch (IllegalArgumentException ex) {
                JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable(new JLabel(Messages.getString("dialog.licencekey.illegal_licence")));
                JOptionPane.showMessageDialog(LicenceKeyDialog.this, messageLabel, Messages.getString("dialog.licencekey.illegal_licence.title"), 0);
                return;
            }
            catch (Exception ex) {
                LOG.error("", (Throwable)ex);
                return;
            }
            this.comp.setVisible(false);
        }
    }
}

