/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String detailMessage;
    private final int messageType;

    private ErrorDialog(Dialog parent, String title, String message, String detailMessage, int messageType) {
        super(parent, true);
        this.message = message;
        this.detailMessage = detailMessage;
        this.messageType = messageType;
        this.setTitle(title);
        this.initGUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setAlwaysOnTop(true);
    }

    private ErrorDialog(Frame parent, String title, String message, String detailMessage, int messageType) {
        super(parent, true);
        this.message = message;
        this.detailMessage = detailMessage;
        this.messageType = messageType;
        this.setTitle(title);
        this.initGUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setAlwaysOnTop(true);
    }

    private ErrorDialog(Component parent, String title, String message, String detailMessage, int messageType) {
        this.setModal(true);
        this.setIconImage(new ImageIcon(ErrorDialog.class.getResource("/resources/boreum_24.png")).getImage());
        this.message = message;
        this.detailMessage = detailMessage;
        this.messageType = messageType;
        this.setTitle(title);
        this.initGUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initGUI() {
        GUIUtils.setSignerThemeInUIManager();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildCenterPanel(), "Center");
        panel.add((Component)this.buildIconPanel(), "West");
        panel.add((Component)this.buildButtonPanel(), "South");
        this.add(panel);
    }

    protected JComponent buildIconPanel() {
        if (this.messageType == -1) {
            return null;
        }
        AccessibleJLabel result = new AccessibleJLabel();
        result.setFocusable(true);
        switch (this.messageType) {
            case 1: {
                result.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                result.getAccessibleContext().setAccessibleName(Messages.getString("dialog.optionPane.information"));
                break;
            }
            case 2: {
                result.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                result.getAccessibleContext().setAccessibleName(Messages.getString("dialog.optionPane.warning"));
                break;
            }
            case 3: {
                result.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
                result.getAccessibleContext().setAccessibleName(Messages.getString("dialog.optionPane.question"));
                break;
            }
            default: {
                result.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                result.getAccessibleContext().setAccessibleName(Messages.getString("dialog.optionPane.error"));
            }
        }
        result.setBorder(new EmptyBorder(10, 10, 10, 10));
        result.setOpaque(true);
        return result;
    }

    protected JComponent buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JPanel leftPanel = new JPanel(new FlowLayout(3));
        JPanel centerPanel = new JPanel(new FlowLayout(1));
        JPanel rightPanel = new JPanel(new FlowLayout(4));
        buttonPanel.setLayout(new GridLayout(1, 3));
        JButton okButton = new JButton(Messages.getString("dialog.error.option0"));
        centerPanel.add(okButton);
        okButton.addActionListener(e -> this.setVisible(false));
        buttonPanel.add(leftPanel);
        buttonPanel.add(centerPanel);
        buttonPanel.add(rightPanel);
        return buttonPanel;
    }

    protected JComponent buildCenterPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        AccessibleJLabel accessibleJLabel = new AccessibleJLabel();
        accessibleJLabel = this.message.contains("html") ? new AccessibleJLabel(this.message) : new AccessibleJLabel(MultiLineTooltips.wrapToolTip(this.message, 80));
        accessibleJLabel.setFocusable(true);
        p.add((Component)accessibleJLabel, "North");
        if (this.detailMessage != null) {
            JPanel dp = new JPanel(new BorderLayout());
            JCheckBox cb = new JCheckBox(Messages.getString("dialog.error.details"));
            JPanel cbPanel = ComponentUtils.layoutCheckbox(cb);
            JEditorPane ep = new JEditorPane(new HTMLEditorKit().getContentType(), this.detailMessage);
            ep.setText(this.detailMessage);
            ep.addFocusListener(ComponentUtils.createFocusListenerFor(ep));
            Font font = UIManager.getFont("Label.font");
            String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
            ((HTMLDocument)ep.getDocument()).getStyleSheet().addRule(bodyRule);
            ep.setEditable(false);
            ep.setOpaque(false);
            JScrollPane sp = new JScrollPane(ep, 20, 31);
            cb.setSelected(false);
            cb.addActionListener(e -> {
                if (cb.isSelected()) {
                    sp.getViewport().setPreferredSize(new Dimension(dp.getSize().width, 90));
                    sp.getViewport().setMinimumSize(new Dimension(dp.getSize().width, 90));
                    dp.add((Component)sp, "Center");
                } else {
                    dp.remove(sp);
                }
                this.pack();
            });
            dp.add((Component)cbPanel, "North");
            if (cb.isSelected()) {
                dp.add((Component)sp, "Center");
            }
            p.add((Component)dp, "Center");
        }
        return p;
    }

    public static void showDialog(Component parent, String key, String detailMessage) {
        String message = Messages.getString("dialog." + key + ".message");
        String title = Messages.getString("dialog." + key + ".title");
        ErrorDialog.showDialog(parent, key, title, message, detailMessage);
    }

    public static void showDialog(Component parent, String key, String message, String detailMessage) {
        String title = Messages.getString("dialog." + key + ".title");
        ErrorDialog.showDialog(parent, key, title, message, detailMessage);
    }

    public static void showDialog(Component parent, String key, String title, String message, String detailMessage) {
        ErrorDialog errorDialog = null;
        if (parent instanceof Dialog) {
            Dialog dialog = (Dialog)parent;
            errorDialog = new ErrorDialog(dialog, title, message, detailMessage, 0);
        } else if (parent instanceof Frame) {
            Frame frame = (Frame)parent;
            errorDialog = new ErrorDialog(frame, title, message, detailMessage, 0);
        } else {
            errorDialog = new ErrorDialog(parent, title, message, detailMessage, 0);
        }
        errorDialog.setVisible(true);
    }
}

