/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class CurvedBorder
extends AbstractBorder {
    private Color borderColor = UIManager.getColor("CurvedBorder.foreground");
    private int sinkLevel = 2;
    private int arcWidthHeight = 8;
    private int lineWidth = 1;

    public CurvedBorder() {
    }

    public CurvedBorder(int wh) {
        this.arcWidthHeight = wh;
    }

    public CurvedBorder(Color c) {
        this.borderColor = c;
    }

    public CurvedBorder(int w, Color c) {
        this.arcWidthHeight = w;
        this.borderColor = c;
    }

    public void setLineWidth(int width) {
        if (width >= 0 && width < 10) {
            this.lineWidth = width;
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.lineWidth > 0) {
            g.setColor(this.getBorderColor());
            GeneralPath p = new GeneralPath(0);
            RoundRectangle2D.Float roundRec = new RoundRectangle2D.Float();
            ((RoundRectangle2D)roundRec).setRoundRect(x, y, w, h, this.arcWidthHeight, this.arcWidthHeight);
            p.append(roundRec, false);
            ((RoundRectangle2D)roundRec).setRoundRect((double)x + (double)this.lineWidth, (double)y + (double)this.lineWidth, (double)w - (double)(this.lineWidth * 2), (double)h - (double)(this.lineWidth * 2), (double)this.arcWidthHeight - 2.0, (double)this.arcWidthHeight - 2.0);
            p.append(roundRec, true);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fill(p);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.sinkLevel, this.sinkLevel, this.sinkLevel, this.sinkLevel);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets i) {
        i.bottom = i.top = this.sinkLevel;
        i.right = i.top;
        i.left = i.top;
        return i;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderLolor(Color c) {
        this.borderColor = c;
    }

    public int getSinkLevel() {
        return this.sinkLevel;
    }
}

