/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci_view.CIViewSwing;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.dialog.ConnectServerWaitWindow;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.inspect.html.InspectionSheetHTMLAccordeon;
import de.governikus.csl.server.CertificateValidationServer;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.gcf.csl.report.AllSignaturesCheck;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.datatype.DatatypeFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateDialog
extends JDialog {
    private static final String DIALOG_CERTIFICATE = "dialog.certificate.";
    private static final String SAVE_ACTION = "saveAction";
    private static final String OK_ACTION = "okAction";
    private static final String CANCEL_ACTION = "cancelAction";
    private static final String VERIFY_ACTION = "verifyAction";
    private static final Logger LOG = LogManager.getLogger(CertificateDialog.class);
    private static final long serialVersionUID = 1L;
    static DatatypeFactory df;
    private KeyUsage keyUsage;
    private transient FlatCertificate cert;
    private int returnCode = -1;

    public CertificateDialog(JFrame parentFrame, X509Certificate certificate, KeyUsage newKeyUsage) throws CertificateEncodingException, ParseException {
        this(parentFrame, (FlatCertificate)Certificate.forX509((X509Certificate)certificate), newKeyUsage);
    }

    public CertificateDialog(JFrame parentFrame, FlatCertificate certificate, KeyUsage newKeyUsage) {
        super((Frame)parentFrame, true);
        this.cert = certificate;
        this.keyUsage = newKeyUsage;
        if (!(this.keyUsage.equals((Object)KeyUsage.SIGN) || this.keyUsage.equals((Object)KeyUsage.ENCRYPT) || this.keyUsage.equals((Object)KeyUsage.DECRYPT) || this.keyUsage.equals((Object)KeyUsage.VERIFY) || this.keyUsage.equals((Object)KeyUsage.SSL))) {
            this.keyUsage = KeyUsage.SIGN;
        }
        this.initComponents(certificate);
        this.setLocationRelativeTo(parentFrame);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected JComponent buildButtonPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        contentPanel.add((Component)buttonPanel, "Center");
        buttonPanel.setLayout(new FlowLayout(1));
        String key = DIALOG_CERTIFICATE + this.keyUsage.toString().toLowerCase() + ".option0";
        IconButton okButton = new IconButton(key);
        OkAction okAction = new OkAction();
        okButton.addActionListener(okAction);
        okButton.setToolTipText(Messages.getString(key + ".tooltip"));
        InputMap inputInFocusedWindow = okButton.getInputMap(2);
        inputInFocusedWindow.put(KeyStroke.getKeyStroke(27, 0), OK_ACTION);
        inputInFocusedWindow.put(KeyStroke.getKeyStroke("alt O"), OK_ACTION);
        okButton.getActionMap().put(OK_ACTION, okAction);
        InputMap inputWhenFocused = okButton.getInputMap(0);
        inputWhenFocused.put(KeyStroke.getKeyStroke(32, 0), OK_ACTION);
        inputWhenFocused.put(KeyStroke.getKeyStroke(10, 0), OK_ACTION);
        if (!this.keyUsage.equals((Object)KeyUsage.SSL)) {
            Action saveAction = Document.getInstance().getActionFactory().createCertificateSaveAction(this.cert);
            IconButton saveButton = new IconButton();
            saveButton.setAction(saveAction);
            saveButton.setToolTipText(Messages.getString(DIALOG_CERTIFICATE + this.keyUsage.toString().toLowerCase() + ".save.tooltip"));
            inputInFocusedWindow = saveButton.getInputMap(2);
            inputInFocusedWindow.clear();
            inputInFocusedWindow.put(KeyStroke.getKeyStroke(83, 128), SAVE_ACTION);
            saveButton.getActionMap().put(SAVE_ACTION, saveAction);
            inputWhenFocused = saveButton.getInputMap(0);
            inputWhenFocused.put(KeyStroke.getKeyStroke(32, 0), SAVE_ACTION);
            inputWhenFocused.put(KeyStroke.getKeyStroke(10, 0), SAVE_ACTION);
            IconButton verifyButton = new IconButton("dialog.certificate.verify.card");
            String tooltip = Messages.getString("dialog.certificate.verify.card.tooltip");
            VerifyCardAction verifyAction = new VerifyCardAction();
            verifyButton.addActionListener(verifyAction);
            CertificateValidationServer validationServer = SignerValidationProcessor.getInstance().getServer();
            verifyButton.setEnabled(validationServer.isConfigComplete());
            if (verifyButton.isEnabled()) {
                verifyButton.setToolTipText(tooltip);
            } else {
                verifyButton.setToolTipText(Messages.getString("dialog.certificate.verify.card.disabled.tooltip"));
            }
            inputInFocusedWindow = verifyButton.getInputMap(2);
            inputInFocusedWindow.clear();
            inputInFocusedWindow.put(KeyStroke.getKeyStroke(86, 128), VERIFY_ACTION);
            inputInFocusedWindow.put(KeyStroke.getKeyStroke(Messages.getString(DIALOG_CERTIFICATE + this.keyUsage.toString().toLowerCase() + ".card.mnemonic")), VERIFY_ACTION);
            verifyButton.getActionMap().put(VERIFY_ACTION, verifyAction);
            inputWhenFocused = verifyButton.getInputMap(0);
            inputWhenFocused.put(KeyStroke.getKeyStroke(32, 0), VERIFY_ACTION);
            inputWhenFocused.put(KeyStroke.getKeyStroke(10, 0), VERIFY_ACTION);
            buttonPanel.add(verifyButton);
            buttonPanel.add(saveButton);
            buttonPanel.add(okButton);
        } else {
            buttonPanel.add(okButton);
            IconButton cancelButton = new IconButton(DIALOG_CERTIFICATE + this.keyUsage.toString().toLowerCase() + ".option1");
            CancelAction cancelAction = new CancelAction();
            cancelButton.addActionListener(cancelAction);
            inputInFocusedWindow = cancelButton.getInputMap(2);
            inputInFocusedWindow.clear();
            inputInFocusedWindow.put(KeyStroke.getKeyStroke(27, 0), CANCEL_ACTION);
            cancelButton.getActionMap().put(CANCEL_ACTION, cancelAction);
            inputWhenFocused = cancelButton.getInputMap(0);
            inputWhenFocused.put(KeyStroke.getKeyStroke(32, 0), CANCEL_ACTION);
            inputWhenFocused.put(KeyStroke.getKeyStroke(10, 0), CANCEL_ACTION);
            buttonPanel.add(cancelButton);
        }
        return contentPanel;
    }

    private void initComponents(FlatCertificate certificate) {
        JPanel panel = new JPanel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildCenterPanel(certificate), "Center");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        JLabel iconLabel = this.getIconLabel();
        northPanel.add((Component)iconLabel, "West");
        JLabel infoLabel = new JLabel(Messages.getString(DIALOG_CERTIFICATE + this.keyUsage.toString().toLowerCase() + ".message"));
        infoLabel.setFocusable(true);
        infoLabel.getAccessibleContext().setAccessibleDescription(iconLabel.getName());
        infoLabel.addFocusListener(ComponentUtils.createFocusListenerFor(infoLabel));
        northPanel.add((Component)infoLabel, "Center");
        panel.add((Component)northPanel, "North");
        panel.add((Component)this.buildButtonPanel(), "South");
        this.pack();
        Dimension certificateDialogDimension = GUIUtils.createCertificateDialogDimension();
        this.setPreferredSize(certificateDialogDimension);
        this.setSize(certificateDialogDimension);
    }

    private JLabel getIconLabel() {
        JLabel iconLabel;
        ConfigIcon iconType = ConfigIcon.valueOf(Messages.getString(DIALOG_CERTIFICATE + this.keyUsage.name().toLowerCase() + ".icon").toUpperCase());
        switch (iconType) {
            case WARN: {
                iconLabel = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
                iconLabel.setName(Messages.getString("dialog.optionPane.warning"));
                break;
            }
            case ERROR: {
                iconLabel = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
                iconLabel.setName(Messages.getString("dialog.optionPane.error"));
                break;
            }
            case QUESTION: {
                iconLabel = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
                iconLabel.setName(Messages.getString("dialog.optionPane.question"));
                break;
            }
            default: {
                iconLabel = new JLabel(UIManager.getIcon("OptionPane.informationIcon"));
                iconLabel.setName(Messages.getString("dialog.optionPane.information"));
            }
        }
        iconLabel.setPreferredSize(new Dimension(50, 50));
        return iconLabel;
    }

    private JComponent buildCenterPanel(FlatCertificate certificate) {
        String errorAtCertificateDisplay = Messages.getString("error.invalid.certificate");
        this.setTitle(Messages.getString(DIALOG_CERTIFICATE + this.keyUsage.toString().toLowerCase() + ".title"));
        JScrollPane certView = new JScrollPane(22, 30);
        certView.getViewport().removeAll();
        if (certificate != null) {
            try {
                CIViewSwing cvprocessor = new CIViewSwing(certificate, true, true, null, null);
                cvprocessor.run();
                certView.setViewportView(cvprocessor.getView());
            }
            catch (Exception e) {
                certView.setViewportView(new JLabel(errorAtCertificateDisplay));
                LOG.error((Object)e, (Throwable)e);
            }
        }
        SwingUtilities.invokeLater(() -> certView.getVerticalScrollBar().getModel().setValue(0));
        return certView;
    }

    static {
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CertificateDialog.this.returnCode = 0;
            CertificateDialog.this.setVisible(false);
        }
    }

    private class VerifyCardAction
    extends AbstractAction {
        private static final long serialVersionUID = 3343332269363083599L;

        private VerifyCardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            boolean showError = false;
            ConnectServerWaitWindow waitWindow = new ConnectServerWaitWindow((Component)Document.getInstance().getFrame());
            waitWindow.showWindow();
            File protocolFile = this.verifyCertificate(CertificateDialog.this.cert, waitWindow);
            waitWindow.closeWindow();
            if (protocolFile != null) {
                this.showProtocol(protocolFile);
            } else {
                showError = true;
            }
            if (showError) {
                this.showErrorMessage();
            }
        }

        private void showErrorMessage() {
            Document.getInstance().reportError(ErrorCode.VERIFY_CERTIFICATE_ERROR, false, new Object[0]);
        }

        private void showProtocol(File protocolFile) {
            try {
                Utils.openFile(protocolFile);
            }
            catch (IOException e) {
                Document.getInstance().displayErrorMessages(CertificateDialog.this, "error.inspectionsheet.changed", MessageFormat.format(Messages.getString("dialog.error.inspectionsheet.changed.message"), protocolFile.getAbsolutePath()), null);
            }
        }

        private File verifyCertificate(FlatCertificate cert, ConnectServerWaitWindow waitWindow) {
            try {
                ValidateResponse response = SignerValidationProcessor.getInstance().verifyCertificate(cert, null, waitWindow);
                if (response == null) {
                    LOG.info("cancelled by user");
                    return null;
                }
                CumulatedValidationResult overallResult = response.getOverallResult(true);
                if (overallResult == null) {
                    LOG.error("overallResult is null -> return null");
                    return null;
                }
                ArrayList<AllSignaturesCheck> ip = new ArrayList<AllSignaturesCheck>();
                ip.add(new AllSignaturesCheck());
                InspectionSheetHTMLAccordeon output = new InspectionSheetHTMLAccordeon(LocaleChanger.getInstance().getActualLocale());
                output.setResultInterpreter(ip);
                File protocolFile = File.createTempFile("tmpSignerCert", ".html", Step.getTempFolder());
                try (FileOutputStream out = new FileOutputStream(protocolFile);){
                    output.layout(response, (OutputStream)out);
                }
                return protocolFile;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return null;
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CertificateDialog.this.returnCode = -1;
            CertificateDialog.this.setVisible(false);
        }
    }

    static enum ConfigIcon {
        INFO,
        WARN,
        ERROR,
        QUESTION;

    }
}

