/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.HelpAction;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class AbstractDialog
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private String componentKey = "";
    private HelpAction helpAction;
    private Component owner;

    protected AbstractDialog(Dialog dialogOwner, boolean modal, String key) {
        super(dialogOwner, modal);
        this.componentKey = key;
        this.owner = dialogOwner;
        this.prepare();
        this.init();
        this.setLocationRelativeTo(this.owner);
        this.pack();
    }

    protected AbstractDialog(Frame frameOwner, boolean modal, String key) {
        super(frameOwner, modal);
        this.componentKey = key;
        this.owner = frameOwner;
        this.prepare();
        this.init();
        this.setLocationRelativeTo(this.owner);
        this.pack();
    }

    abstract JComponent getMainPanel();

    abstract String getContextHelp();

    abstract List<AbstractSignerAction> getActions();

    private void prepare() {
        this.helpAction = (HelpAction)Document.getInstance().getActionFactory().getContextSensitiveHelpAction();
    }

    private void init() {
        this.setTitle(Messages.getString(this.componentKey + ".title"));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getMainPanel(), "Center");
        panel.add(this.createButtonPanel(), "South");
        JComponentUtils.setKeyListenerToAllComponents(panel, this);
        this.add(panel);
    }

    private Component createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        panel.add(this.createLeftButtonPanel());
        panel.add(this.createRightButtonPanel());
        return panel;
    }

    private Component createRightButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(4));
        for (AbstractSignerAction action : this.getActions()) {
            IconButton bt = new IconButton();
            bt.setAction(action);
            panel.add(bt);
        }
        return panel;
    }

    private Component createLeftButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(3));
        String helpKey = this.getContextHelp();
        if (helpKey != null) {
            IconButton helpButton = new IconButton();
            ((AbstractButton)helpButton).setAction(this.helpAction);
            panel.add(helpButton);
        }
        return panel;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.getContextHelp() != null) {
            JComponentUtils.callAction(e, this.helpAction);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

