/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui.dialog;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.InfoAction;
import de.bos_bremen.ecard.client.gui.IconScalingUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AboutDialog
extends JDialog {
    private static final Logger LOG = LogManager.getLogger(AboutDialog.class);
    private static final long serialVersionUID = 1L;
    private String hyperlink = null;
    private Font plainSelected = (Font)UIManager.get("Label.font");
    private Font boldSelected = (Font)UIManager.get("TitledBorder.font");

    public AboutDialog(JFrame parent, String text) {
        super((Frame)parent, true);
        this.initComponents(text);
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
    }

    public AboutDialog(JFrame parent, String text, boolean modal, boolean alwaysOnTop) {
        super((Frame)parent, true);
        this.setModal(modal);
        this.initComponents(text);
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.setAlwaysOnTop(alwaysOnTop);
    }

    private void initComponents(String text) {
        this.setAboutTitle(System.getProperty("about.title"));
        JLabel aboutBackground = this.createAboutBackground();
        aboutBackground.setLayout(new GridBagLayout());
        this.recalculateFontSelected();
        String[] about = text.split(";");
        JLabel versionLabel = new JLabel(about[0].split(":")[0] + ":   ");
        JLabel version = new JLabel(about[0].split(":")[1]);
        this.makeHeaderAndDataRowAccessible(versionLabel, version);
        JLabel licenceLabel = new JLabel(about[1].split(":")[0] + ":   ");
        JLabel licence = new JLabel(about[1].split(":")[1]);
        this.makeHeaderAndDataRowAccessible(licenceLabel, licence);
        JLabel mcardLabel = new JLabel(about[2].split(":")[0] + ":   ");
        JLabel mcardVersion = new JLabel(about[2].split(":")[1]);
        this.makeHeaderAndDataRowAccessible(mcardLabel, mcardVersion);
        JLabel nameLabel = new JLabel("<html>&copy; " + about[3] + "</html>");
        this.makeAccessible(nameLabel);
        this.hyperlink = about[4];
        String www = about[4].split("//")[1];
        JLabel hyperlinkLabel = this.createHyperlinkLabel(www);
        int row = 1;
        int column = 1;
        aboutBackground.add((Component)versionLabel, new GridBagConstraints(column, row, 1, 1, 1.0, 1.0, 26, 0, new Insets(80, 0, 0, 0), 0, 0));
        aboutBackground.add((Component)version, new GridBagConstraints(column + 1, row, 1, 1, 1.0, 1.0, 25, 0, new Insets(0, 0, 0, 0), 0, 0));
        row = 2;
        column = 1;
        aboutBackground.add((Component)licenceLabel, new GridBagConstraints(column, row, 1, 1, 1.0, 1.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        aboutBackground.add((Component)licence, new GridBagConstraints(column + 1, row, 1, 1, 1.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        row = 3;
        column = 1;
        aboutBackground.add((Component)mcardLabel, new GridBagConstraints(column, row, 1, 1, 1.0, 1.0, 24, 0, new Insets(0, 0, 0, 0), 0, 0));
        aboutBackground.add((Component)mcardVersion, new GridBagConstraints(column + 1, row, 1, 1, 1.0, 1.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        row = 4;
        column = 1;
        aboutBackground.add((Component)nameLabel, new GridBagConstraints(column, row, 2, 1, 1.0, 1.0, 20, 0, new Insets(0, 0, 0, 0), 0, 0));
        row = 5;
        column = 1;
        aboutBackground.add((Component)hyperlinkLabel, new GridBagConstraints(column, row, 2, 1, 1.0, 1.0, 19, 0, new Insets(0, 0, 90, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)aboutBackground, new GridBagConstraints());
        this.pack();
        this.createEscapeFor(aboutBackground);
    }

    private static void openDocument(String url) {
        try {
            LOG.trace("Desktop browse: {}", (Object)url);
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException | URISyntaxException ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    private void createEscapeFor(JLabel aboutBackground) {
        ComponentInputMap keyMap = new ComponentInputMap(aboutBackground);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(27, 0), "escapeAction");
        ActionMapUIResource actionMap = new ActionMapUIResource();
        actionMap.put("escapeAction", new EscapeAction());
        SwingUtilities.replaceUIActionMap(aboutBackground, actionMap);
        SwingUtilities.replaceUIInputMap(aboutBackground, 2, keyMap);
    }

    private JLabel createHyperlinkLabel(final String www) {
        final JLabel hyperlinkLabel = new JLabel();
        this.styleFocusless(hyperlinkLabel, www);
        this.makeAccessible(hyperlinkLabel);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AboutDialog.this.hyperlink == null) {
                    AboutDialog.this.dispose();
                } else {
                    AboutDialog.openDocument(AboutDialog.this.hyperlink);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AboutDialog.this.styleFocused(hyperlinkLabel, www);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AboutDialog.this.styleFocusless(hyperlinkLabel, www);
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode() || 32 == keyEvent.getKeyCode()) {
                    if (AboutDialog.this.hyperlink == null) {
                        AboutDialog.this.dispose();
                    } else {
                        AboutDialog.openDocument(AboutDialog.this.hyperlink);
                    }
                }
            }
        };
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AboutDialog.this.styleFocused(hyperlinkLabel, www);
            }

            @Override
            public void focusLost(FocusEvent e) {
                AboutDialog.this.styleFocusless(hyperlinkLabel, www);
            }
        };
        hyperlinkLabel.addMouseListener(mouseAdapter);
        hyperlinkLabel.addKeyListener(keyAdapter);
        hyperlinkLabel.addFocusListener(focusListener);
        hyperlinkLabel.setCursor(Cursor.getPredefinedCursor(12));
        return hyperlinkLabel;
    }

    private JLabel createAboutBackground() {
        JLabel aboutBackground = new JLabel();
        String background = System.getProperty("about.background");
        if (background == null || background.isEmpty()) {
            aboutBackground.setIcon(new ImageIcon(InfoAction.class.getResource(Messages.getString("dialog.about.background"))));
        } else {
            try {
                aboutBackground.setIcon(IconScalingUtils.createMultiResIconFromImgSet("about.background"));
            }
            catch (Exception e) {
                aboutBackground.setIcon(new ImageIcon(InfoAction.class.getResource(Messages.getString("dialog.about.background"))));
            }
        }
        return aboutBackground;
    }

    private void setAboutTitle(String title) {
        if (title == null || title.isEmpty()) {
            title = Messages.getString("dialog.about.title");
        }
        this.setTitle(title);
    }

    private void styleFocused(JLabel label, String www) {
        label.setText(www);
    }

    private void styleFocusless(JLabel label, String www) {
        label.setText("<html><u>" + www + "</u></html>");
    }

    private void makeHeaderAndDataRowAccessible(JLabel header, JLabel data) {
        this.makeAccessible(header);
        this.makeAccessible(data);
        header.setFont(this.boldSelected);
    }

    private void makeAccessible(JLabel label) {
        label.setFocusable(true);
        label.setFont(this.plainSelected);
        label.setForeground(Color.WHITE);
        label.setBorder(CurvedBorder.EMPTY_BORDER);
        label.addFocusListener(ComponentUtils.createFocusListenerFor(label, (Border)CurvedBorder.EMPTY_BORDER, (Border)CurvedBorder.BORDER_WHITE));
    }

    private void recalculateFontSelected() {
        if (this.plainSelected.getSize() > 22) {
            this.plainSelected = new Font(this.plainSelected.getFamily(), 0, 22);
            this.boldSelected = new Font(this.plainSelected.getFamily(), 1, 22);
        }
    }

    private class EscapeAction
    extends AbstractAction {
        private static final long serialVersionUID = -6051099652941609482L;

        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AboutDialog.this.setVisible(false);
        }
    }
}

