/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.debug_mode.DebugLevel;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.ChangeFontAction;
import de.bos_bremen.ecard.client.action.HelpAction;
import de.bos_bremen.ecard.client.control.process.ProcessListener;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.FontSize;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.step.WorkingStepView;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.StatusLine;
import de.bos_bremen.ecard.client.gui.view.component.TopSideBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.label.AccessibleJLabel;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.util.GlassPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StepPanel
extends JPanel
implements ProcessListener,
StepChangedListener,
PropertyChangeListener {
    private static final Logger LOG = LogManager.getLogger(StepPanel.class);
    private final transient Step step;
    private JComponent stepContent;
    private JPanel buttonPanelBottom;
    private final IconButton undo = new IconButton();
    private final IconButton prev = new IconButton();
    private final IconButton next = new IconButton();
    private IconButton run = null;
    private final IconButton cancel = new IconButton();
    private final IconButton ok = new IconButton();
    private JButton helpButton = new IconButton();
    private JButton showProtocol = new IconButton();
    private JButton sendProtocol = new IconButton();
    private IconButton smallFont = new IconButton();
    private IconButton normalFont = new IconButton();
    private IconButton bigFont = new IconButton();
    private final StatusLine statusLine;
    private GlassPane glassPane = null;

    public StepPanel(Step newStep) {
        super(new BorderLayout());
        this.step = newStep;
        this.step.setJComponent();
        this.step.addStateChangeListener(this);
        this.step.getParent().addProcessListener(this);
        this.statusLine = new StatusLine();
        this.initGUI();
    }

    private void initGUI() {
        this.stepContent = this.step.getJComponent();
        this.buttonPanelBottom = this.createButtonPanel();
        this.add((Component)this.stepContent, "Center");
        this.add((Component)this.buttonPanelBottom, "South");
        this.processChange();
        LocaleChanger.getInstance().addObserver(this);
        this.setKeys();
        this.enableButton();
    }

    private JPanel createButtonPanel() {
        this.buttonPanelBottom = new JPanel();
        this.buttonPanelBottom.setLayout(new BorderLayout());
        JPanel runButtonPanel = new JPanel();
        if (!this.showRunButtonSeparate()) {
            AccessibleJLabel runDescription = new AccessibleJLabel(Messages.getString("step." + this.step.getStepName().toString() + ".rundescription.text"));
            runButtonPanel.setLayout(new BorderLayout());
            runButtonPanel.add((Component)runDescription, "Center");
        } else {
            this.run = new IconButton();
            IconButton createdRunButton = this.configureRunButton();
            runButtonPanel.setLayout(new FlowLayout(1));
            runButtonPanel.add(createdRunButton);
            this.buttonPanelBottom.add((Component)runButtonPanel, "Center");
        }
        this.createArrowAndActionButtons();
        JPanel arrows = new JPanel(new GridBagLayout());
        this.addArrowAndActionButtons(arrows);
        this.buttonPanelBottom.add((Component)arrows, "South");
        return this.buttonPanelBottom;
    }

    private void addArrowAndActionButtons(JPanel arrows) {
        Insets insets = new Insets(3, 3, 3, 3);
        int position = 0;
        arrows.setBorder(new TopSideBorder(1, UIManager.getColor("CurvedBorder.foreground")));
        JComponentUtils.setLookByLicence(this.smallFont, LicenceTyp.enable, arrows, new GridBagConstraints(position, 0, 1, 1, 0.0, 1.0, 16, 0, insets, 0, 0));
        JComponentUtils.setLookByLicence(this.normalFont, LicenceTyp.enable, arrows, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 16, 0, insets, 0, 0));
        JComponentUtils.setLookByLicence(this.bigFont, LicenceTyp.enable, arrows, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 16, 0, insets, 0, 0));
        arrows.add((Component)this.helpButton, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 16, 0, insets, 0, 0));
        JComponentUtils.setLookByLicence(this.showProtocol, Document.getInstance().getProductFunctions().enableGeneralActionsSettingsProtocol(), arrows, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 16, 0, insets, 0, 0));
        DebugLevel pl = Config.getInstance().getProtocolLevel();
        boolean showProtocolActions = !pl.equals((Object)DebugLevel.none);
        this.showProtocol.setEnabled(Document.getInstance().getProductFunctions().enableGeneralActionsSettingsProtocol().isEditable() && showProtocolActions);
        JComponentUtils.setLookByLicence(this.sendProtocol, Document.getInstance().getProductFunctions().enableGeneralActionsSettingsProtocol(), arrows, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 16, 0, insets, 0, 0));
        this.sendProtocol.setEnabled(Document.getInstance().getProductFunctions().enableGeneralActionsSettingsProtocol().isEditable() && showProtocolActions);
        arrows.add((Component)this.statusLine, new GridBagConstraints(++position, 0, 1, 1, 1.0, 1.0, 16, 1, insets, 0, 0));
        this.statusLine.setVisible(false);
        arrows.add((Component)this.undo, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 14, 0, insets, 0, 0));
        arrows.add((Component)this.prev, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 14, 0, insets, 0, 0));
        if (!this.showRunButtonSeparate()) {
            this.run = this.configureRunButton();
            arrows.add((Component)this.run, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 14, 0, insets, 0, 0));
        } else {
            arrows.add((Component)this.next, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 14, 0, insets, 0, 0));
        }
        arrows.add((Component)this.cancel, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 14, 0, insets, 0, 0));
        arrows.add((Component)this.ok, new GridBagConstraints(++position, 0, 1, 1, 0.0, 1.0, 14, 0, insets, 0, 0));
    }

    private boolean showRunButtonSeparate() {
        return Messages.getResource("step." + this.step.getStepName().toString() + ".rundescription.text") == null;
    }

    private void createArrowAndActionButtons() {
        this.helpButton = new IconButton();
        this.helpButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        AbstractSignerAction kontextHelpAction = Document.getInstance().getActionFactory().getContextSensitiveHelpAction();
        kontextHelpAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 512));
        this.helpButton.setToolTipText(Messages.getResource("button.help.kontext.tooltip"));
        this.helpButton.setAction(kontextHelpAction);
        this.helpButton.setText(null);
        this.smallFont = this.createFontButton(FontSize.SMALL);
        this.normalFont = this.createFontButton(FontSize.NORMAL);
        this.bigFont = this.createFontButton(FontSize.BIG);
        final ButtonGroup fontGroup = new ButtonGroup();
        fontGroup.add(this.smallFont);
        fontGroup.add(this.normalFont);
        fontGroup.add(this.bigFont);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                switch (Document.getInstance().getFontSize()) {
                    case SMALL: {
                        fontGroup.setSelected(StepPanel.this.smallFont.getModel(), true);
                        StepPanel.this.smallFont.setSelected(true);
                        StepPanel.this.smallFont.requestFocus();
                        break;
                    }
                    case BIG: {
                        fontGroup.setSelected(StepPanel.this.bigFont.getModel(), true);
                        StepPanel.this.bigFont.setSelected(true);
                        StepPanel.this.bigFont.requestFocus();
                        break;
                    }
                    default: {
                        fontGroup.setSelected(StepPanel.this.normalFont.getModel(), true);
                        StepPanel.this.normalFont.setSelected(true);
                        StepPanel.this.normalFont.requestFocus();
                    }
                }
            }
        };
        SwingUtilities.invokeLater(r);
        if (Document.getInstance().getProductFunctions().enableGeneralActionsSettingsProtocol().isVisible() && Document.getInstance().getProductFunctions().enableGeneralActionsSettingsProtocol().isEditable() && !Document.getInstance().getProductFunctions().enableGeneralMenu().isVisible()) {
            DebugLevel pl = Config.getInstance().getProtocolLevel();
            boolean showProtocolActions = !pl.equals((Object)DebugLevel.none);
            this.showProtocol = new IconButton();
            this.showProtocol.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.showProtocol.setAction(Document.getInstance().getActionFactory().createShowProtocolAction(false));
            this.showProtocol.setText(null);
            this.showProtocol.setEnabled(showProtocolActions);
            this.sendProtocol = new IconButton();
            this.sendProtocol.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.sendProtocol.setAction(Document.getInstance().getActionFactory().createSendProtocolAction(false));
            this.sendProtocol.setText(null);
            this.sendProtocol.setEnabled(showProtocolActions);
        }
        this.undo.setAction(new UndoAction((Component)this));
        this.undo.setEnabled(true);
        this.prev.setAction(new PrevAction((Component)this));
        this.next.setAction(new NextAction((Component)this));
        this.next.setEnabled(false);
        this.next.setVisible(true);
        this.cancel.setAction(new CancelAction((Component)this));
        this.ok.setAction(new OkAction((Component)this));
        this.ok.setEnabled(false);
    }

    private IconButton createFontButton(FontSize fontSize) {
        IconButton fontButton = new IconButton(false);
        ChangeFontAction fontAction = Document.getInstance().getActionFactory().createChangeFontAction(false, fontSize);
        fontButton.setAction(fontAction);
        fontButton.setText(null);
        fontButton.setEnabled(true);
        return fontButton;
    }

    private IconButton configureRunButton() {
        this.run = new IconButton();
        this.run.setAction(new RunAction((Component)this));
        this.run.setEnabled(Document.getInstance().getProcessPolicy() != ProcessPolicy.runProcess);
        this.run.setFocusPainted(false);
        this.run.setVerticalTextPosition(0);
        this.run.setHorizontalTextPosition(4);
        this.run.setBorder(CurvedBorder.BORDER_BLUE);
        this.run.addFocusListener(ComponentUtils.createFocusListenerFor(this.run));
        this.run.addMouseListener(ComponentUtils.createMouseAdapterFor(this.run));
        this.run.setContentAreaFilled(false);
        return this.run;
    }

    private void setKeys() {
        int condition = 2;
        KeyStroke ksNext = KeyStroke.getKeyStroke(39, 512);
        this.getInputMap(condition).put(ksNext, "next");
        this.getActionMap().put("next", new NextButtonAction());
        KeyStroke ksDown = KeyStroke.getKeyStroke(40, 512);
        this.getInputMap(condition).put(ksDown, "down");
        this.getActionMap().put("down", new DownAction((Component)this));
        KeyStroke ksPrev = KeyStroke.getKeyStroke(37, 512);
        this.getInputMap(condition).put(ksPrev, "prev");
        this.getActionMap().put("prev", new PreviousButtonAction());
        KeyStroke ksUp = KeyStroke.getKeyStroke(38, 512);
        this.getInputMap(condition).put(ksUp, "up");
        this.getActionMap().put("up", new UpAction((Component)this));
        KeyStroke ksCancel = KeyStroke.getKeyStroke(8, 512);
        this.getInputMap(condition).put(ksCancel, "cancel");
        this.getActionMap().put("cancel", new CancelButtonAction());
        KeyStroke ksRun = KeyStroke.getKeyStroke(10, 512);
        this.getInputMap(condition).put(ksRun, "run");
        this.getActionMap().put("run", new RunButtonAction());
    }

    @Override
    public void processChange() {
        this.enableButton();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.enableButton();
    }

    private boolean isSecondToLastStep() {
        List<Step> allSteps = this.step.getParent().getSteps();
        ArrayList<Step> allShownSteps = new ArrayList<Step>();
        for (Step s : allSteps) {
            if (!s.getLicenceTyp().isVisible()) continue;
            allShownSteps.add(s);
        }
        return allShownSteps.size() > 1 && allShownSteps.get(allShownSteps.size() - 2) == this.step;
    }

    private void enableButton() {
        boolean runProcess;
        boolean complete = this.step.isStateComplete();
        boolean finished = this.step.getParent().getState().equals((Object)FrameworkStatus.FrameworkState.finished);
        boolean hasNext = this.step.getParent().hasNextStep();
        boolean hasPrev = this.step.getParent().hasPreviousStep();
        boolean isSecondToLastStep = this.isSecondToLastStep();
        boolean canProcess = this.step.getParent().canProcess();
        boolean bl = runProcess = Document.getInstance().getProcessPolicy() != ProcessPolicy.runProcess;
        if (!this.step.getParent().canRunProcess()) {
            runProcess = true;
        }
        this.prev.setVisible(hasPrev);
        this.next.setHidden(!hasNext);
        this.next.setEnabled(complete && (!isSecondToLastStep || canProcess));
        this.ok.setVisible(finished);
        this.cancel.setVisible(!finished);
        this.ok.setEnabled(finished);
        this.cancel.setEnabled(!finished);
        this.undo.setVisible(this.step instanceof WorkingStep);
        this.undo.setEnabled(true);
        this.run.setVisible(this.step instanceof WorkingStep);
        this.run.setEnabled(complete && runProcess);
        if (!canProcess && this.step.getInCompleteDetails() != null) {
            this.run.setToolTipText(null);
            StringBuilder tooltip = new StringBuilder("<html>" + this.step.getInCompleteDetails() + "</html>");
            this.run.setToolTipText(tooltip.toString());
            this.next.setToolTipText(tooltip.toString());
        } else {
            this.run.setToolTipText((String)this.run.getAction().getValue("ShortDescription"));
            this.next.setToolTipText((String)this.next.getAction().getValue("ShortDescription"));
        }
        if (!finished && complete || finished) {
            this.statusLine.notifyProgress(null, 0.0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.buttonPanelBottom != null) {
            this.remove(this.buttonPanelBottom);
            this.buttonPanelBottom = this.createButtonPanel();
        }
        this.enableButton();
        if (this.buttonPanelBottom != null) {
            this.add((Component)this.buttonPanelBottom, "South");
        }
        this.repaint();
        this.revalidate();
    }

    @Override
    public void setActive(boolean active) {
        Component rootPane = SwingUtilities.getRootPane(this);
        if (rootPane == null) {
            Component comp = SwingUtilities.getRoot(this);
            rootPane = comp != null ? comp : this.getRootPane();
        }
        if (active) {
            LOG.trace("");
            String id = this.step.getParent().getProcessName().toString() + "." + this.step.getStepName().toString() + ".helpcontext";
            if (Messages.getResource(id) != null) {
                HelpAction.enableHelpKey(rootPane, Messages.getResource(id));
            } else {
                LOG.debug("{} fehlt in den Properties", (Object)id);
                HelpAction.enableHelpKey(rootPane, "");
            }
        }
        this.statusLine.setVisible(!this.step.getParent().hasNextStep());
    }

    @Override
    public void requestFocus() {
        this.stepContent.requestFocus();
    }

    private class UndoAction
    extends AbstractSignerAction {
        protected UndoAction(Component parent) {
            super("button.step.undo", parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            StepPanel.this.step.getParent().restartProcess();
            StepFormular stepFormular = StepPanel.this.step.getForm();
            if (stepFormular instanceof ProcessFormular) {
                ProcessFormular processFormular = (ProcessFormular)((Object)stepFormular);
                processFormular.notifyAllChangeListener();
            }
            StepPanel.this.statusLine.notifyProgress(null, 0.0);
        }
    }

    private class PrevAction
    extends AbstractSignerAction {
        protected PrevAction(Component parent) {
            super("button.step.prev", parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (StepPanel.this.step.getParent().hasPreviousStep()) {
                StepPanel.this.step.getParent().previousIncompleteStep();
            }
        }
    }

    private class NextAction
    extends AbstractSignerAction {
        protected NextAction(Component parent) {
            super("button.step.next", parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (StepPanel.this.step.getParent().hasNextStep()) {
                StepPanel.this.step.getParent().nextUncompleteStep();
            }
        }
    }

    private class CancelAction
    extends AbstractSignerAction {
        protected CancelAction(Component parent) {
            super("button.step.cancel", parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LOG.info("{} : {}", (Object)StepPanel.this.step.getParent().getProcessName(), (Object)StepPanel.this.step.getStepName());
            StepPanel.this.step.getParent().cancelProcess();
            Document.getInstance().getProcessFactory().getProcessChoose().showProcess(RootProcessName.getInstance());
        }
    }

    private class OkAction
    extends AbstractSignerAction {
        protected OkAction(Component parent) {
            super("button.step.ok", parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            StepPanel.this.step.getParent().isFinished(true);
            Document.getInstance().getProcessFactory().getProcessChoose().showProcess(RootProcessName.getInstance());
        }
    }

    private class RunAction
    extends AbstractSignerAction {
        protected RunAction(Component parent) {
            super("step." + StepPanel.this.step.getStepName() + ".action.run", parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            StepPanel.this.cancel.setEnabled(false);
            StepPanel.this.run.setVisible(true);
            StepPanel.this.run.setEnabled(false);
            StepPanel.this.undo.setVisible(true);
            StepPanel.this.undo.setEnabled(true);
            Thread runner = new Thread(){

                @Override
                public void run() {
                    if (!StepPanel.this.step.getParent().hasNextStep()) {
                        if (Document.getInstance().getFrame() != null) {
                            StepPanel.this.glassPane = new GlassPane();
                            Document.getInstance().getFrame().setGlassPane(StepPanel.this.glassPane);
                            Document.getInstance().getFrame().getGlassPane().setVisible(true);
                        } else {
                            StepPanel.this.glassPane = null;
                        }
                        if (StepPanel.this.glassPane != null) {
                            StepPanel.this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
                        }
                        FocusTraversalPolicy oldPolicy = StepPanel.this.buttonPanelBottom.getFocusTraversalPolicy();
                        StepPanel.this.buttonPanelBottom.setFocusTraversalPolicy(null);
                        ((WorkingStepView)StepPanel.this.stepContent).startProcess();
                        if (StepPanel.this.glassPane != null) {
                            StepPanel.this.glassPane.setCursor(Cursor.getPredefinedCursor(0));
                            StepPanel.this.glassPane.setVisible(false);
                            StepPanel.this.glassPane.setProgress(0);
                        }
                        StepPanel.this.buttonPanelBottom.setFocusTraversalPolicy(oldPolicy);
                    }
                }
            };
            runner.start();
        }
    }

    private class NextButtonAction
    extends AbstractAction {
        private NextButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StepPanel.this.next.doClick();
        }
    }

    private class DownAction
    extends AbstractSignerAction {
        protected DownAction(Component parent) {
            super("button.step.down", parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            boolean isSecondToLast = StepPanel.this.isSecondToLastStep();
            if ((!isSecondToLast || StepPanel.this.step.getParent().canProcess()) && StepPanel.this.step.getParent().hasNextStep()) {
                StepPanel.this.step.getParent().nextStep();
            }
        }
    }

    private class PreviousButtonAction
    extends AbstractAction {
        private PreviousButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StepPanel.this.prev.doClick();
        }
    }

    private class UpAction
    extends AbstractSignerAction {
        protected UpAction(Component parent) {
            super("button.step.up", parent);
            this.setKeyAndIcon(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (StepPanel.this.step.getParent().hasPreviousStep()) {
                StepPanel.this.step.getParent().previousStep();
            }
        }
    }

    private class CancelButtonAction
    extends AbstractAction {
        private CancelButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StepPanel.this.cancel.doClick();
        }
    }

    private class RunButtonAction
    extends AbstractAction {
        private RunButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StepPanel.this.run.doClick();
        }
    }
}

