/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.gui.FontSize;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.OceanTheme;

public class SignerTheme
extends OceanTheme {
    private static final Color SIGNER_WHITE_1 = new Color(252, 252, 252);
    private static final ColorUIResource BACKGROUND_COLOR = new ColorUIResource(Color.WHITE);
    private String fontName;
    private int fontStyle;
    private FontUIResource signerFont;
    private FontSize fontSize;
    public static final Color SIGNER_BLUE = new Color(15, 97, 113);
    public static final Color BOREUM_PETROL = new Color(0, 95, 113);
    public static final Color BOREUM_PETROL_RESOURCE = new ColorUIResource(BOREUM_PETROL);
    public static final Color BOREUM_PETROL_2 = new Color(1, 77, 92);
    public static final Color BOREUM_PETROL_LIGHT = new Color(63, 162, 181);
    public static final Color BOREUM_PETROL_MENU = new Color(237, 247, 250);
    public static final Color BOREUM_PETROL_BLACK = new Color(0, 51, 61);
    private static final ColorUIResource SIGNER_BLACK = new ColorUIResource(BOREUM_PETROL_BLACK);
    public static final ColorUIResource BOREUM_PETROL_BLACK_UI = new ColorUIResource(BOREUM_PETROL_BLACK);
    public static final Color SIGNER_BLUE_1 = new Color(43, 120, 142);
    public static final ColorUIResource SIGNER_BLUE_2 = new ColorUIResource(new Color(70, 112, 140));
    public static final Color SIGNER_WHITE_2 = new Color(238, 238, 238);
    private static final List<Object> BUTTON_GRADIENT = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), SIGNER_WHITE_1, SIGNER_WHITE_1, SIGNER_WHITE_2);
    public static final Color GRAY_3 = new Color(148, 148, 148);
    public static final Color GRAY_3_RESOURCE = new ColorUIResource(GRAY_3);
    public static final Color GRAY_5 = new Color(111, 111, 111);
    public static final Color GRAY_7 = new Color(89, 89, 89);
    public static final Color GRAY_7_RESOURCE = new ColorUIResource(GRAY_7);
    public static final Color WHITE_RESOURCE = new ColorUIResource(Color.WHITE);
    public static final Color COLOR_GREEN = new Color(0, 104, 0);
    public static final ColorUIResource COLOR_RED = new ColorUIResource(new Color(182, 0, 0));
    public static final Color LIST_BACKGROUND2 = new Color(225, 244, 250);
    public static final Color LIST_BACKGROUND3 = new Color(221, 232, 243);
    public static final Border TEXTFIELD_FOCUSLESS = new JTextField().getBorder();
    public static final Border TEXTFIELD_FOCUSED = BorderFactory.createEtchedBorder(1, CurvedBorder.FOCUSED_COLOR, Color.DARK_GRAY);

    public SignerTheme() {
        try {
            this.fontSize = Document.getInstance().getFontSize();
        }
        catch (Exception e) {
            this.fontSize = FontSize.SMALL;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        List<String> fontList = Arrays.asList(fontNames);
        this.fontStyle = 0;
        if (fontList.contains("Verdana")) {
            this.fontName = "Verdana";
        } else if (fontList.contains("Arial Narrow")) {
            this.fontName = "Arial Narrow";
        } else {
            this.fontName = "Dialog";
            this.fontStyle = 1;
        }
        int contentSize = this.fontSize.getHeaderSize();
        int boldContentSize = contentSize + 1;
        this.signerFont = new FontUIResource(new Font(this.fontName, this.fontStyle, contentSize));
        FontUIResource fontItalicResource = new FontUIResource(this.fontName, 2, contentSize);
        FontUIResource fontBoldResource = new FontUIResource(new Font(this.fontName, 1, boldContentSize));
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            String keyString;
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, this.signerFont);
            if (!(key instanceof String) || !(keyString = (String)key).contains("accelerator")) continue;
            UIManager.put(key, fontItalicResource);
        }
        UIManager.put("DescriptionHeader.font", fontBoldResource);
        UIManager.put("TitledBorder.font", fontBoldResource);
        UIManager.put("Label.disabledForeground", GRAY_7_RESOURCE);
        UIManager.put("Label.background", BACKGROUND_COLOR);
        UIManager.put("SplitPane.background", BACKGROUND_COLOR);
        UIManager.put("ScrollBar.background", BACKGROUND_COLOR);
        UIManager.put("ScrollPane.background", BACKGROUND_COLOR);
        UIManager.put("MenuBar.background", BOREUM_PETROL_MENU);
        UIManager.put("Spinner.background", BACKGROUND_COLOR);
        UIManager.put("OptionPane.background", BACKGROUND_COLOR);
        UIManager.put("DesktopIcon.background", BACKGROUND_COLOR);
        UIManager.put("Slider.background", BACKGROUND_COLOR);
        UIManager.put("Menu.background", BACKGROUND_COLOR);
        UIManager.put("RadioButton.background", BACKGROUND_COLOR);
        UIManager.put("CheckBox.background", BACKGROUND_COLOR);
        UIManager.put("ToolBar.background", BACKGROUND_COLOR);
        UIManager.put("ToolTip.background", BACKGROUND_COLOR);
        UIManager.put("ToolTip.backgroundInactive", BACKGROUND_COLOR);
        UIManager.put("ToolTip.foreground", BOREUM_PETROL_BLACK_UI);
        UIManager.put("ToolTip.foregroundInactive", BOREUM_PETROL_BLACK_UI);
        UIManager.put("ToolTip.hideAccelerator", Boolean.FALSE);
        BorderUIResource tooltipBorder = new BorderUIResource(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SIGNER_BLUE_1, 1), new EmptyBorder(5, 10, 5, 10)));
        UIManager.put("ToolTip.border", tooltipBorder);
        UIManager.put("PopupMenu.background", BACKGROUND_COLOR);
        UIManager.put("CheckBoxMenuItem.background", BACKGROUND_COLOR);
        UIManager.put("Panel.background", BACKGROUND_COLOR);
        UIManager.put("ColorChooser.background", BACKGROUND_COLOR);
        UIManager.put("Table.selectionBackground", SIGNER_BLUE);
        UIManager.put("Table.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("TextArea.selectionBackground", SIGNER_BLUE);
        UIManager.put("TextArea.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("TextField.selectionBackground", SIGNER_BLUE);
        UIManager.put("TextField.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("PasswordField.selectionBackground", SIGNER_BLUE);
        UIManager.put("PasswordField.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("ComboBox.selectionBackground", SIGNER_BLUE);
        UIManager.put("ComboBox.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("ProgressBar.selectionBackground", SIGNER_BLUE);
        UIManager.put("ProgressBar.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("List.selectionBackground", SIGNER_BLUE);
        UIManager.put("List.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("Menu.selectionBackground", SIGNER_BLUE);
        UIManager.put("Menu.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("MenuItem.selectionBackground", SIGNER_BLUE);
        UIManager.put("MenuItem.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("MenuItem.acceleratorForeground", SIGNER_BLUE);
        UIManager.put("MenuItem.acceleratorSelectionForeground", BACKGROUND_COLOR);
        UIManager.put("RadioButtonMenuItem.selectionBackground", SIGNER_BLUE);
        UIManager.put("RadioButtonMenuItem.selectionForeground", BACKGROUND_COLOR);
        UIManager.put("RadioButtonMenuItem.acceleratorForeground", SIGNER_BLUE);
        UIManager.put("RadioButtonMenuItem.acceleratorSelectionForeground", BACKGROUND_COLOR);
        UIManager.put("MenuItem.background", BACKGROUND_COLOR);
        UIManager.put("Viewport.background", BACKGROUND_COLOR);
        this.updateButtonUIManager();
        this.updateScrollBarUIanager();
        this.updateGeneralUIManager();
        UIManager.put("ToggleButton.borderColor", SIGNER_BLUE_2);
        UIManager.put("ToggleButton.disabledToolBarBorderBackground", GRAY_3_RESOURCE);
        UIManager.put("ToggleButton.disabledText", GRAY_7_RESOURCE);
        UIManager.put("ToggleButton.disabledSelectedText", GRAY_7);
        UIManager.put("ToggleButton.text", SIGNER_BLACK);
        UIManager.put("ToggleButton.selectedText", SIGNER_BLACK);
        UIManager.put("ToggleButton.gradient", BUTTON_GRADIENT);
        UIManager.put("ProgressBar.background", BACKGROUND_COLOR);
        UIManager.put("RadioButtonMenuItem.background", BACKGROUND_COLOR);
        UIManager.put("TabbedPane.tabAreaBackground", BACKGROUND_COLOR);
        UIManager.put("TabbedPane.selected", Color.WHITE);
        UIManager.put("TabbedPane.selectHighlight", BOREUM_PETROL_RESOURCE);
        UIManager.put("TabbedPane.borderHightlightColor", new ColorUIResource(BOREUM_PETROL_2));
        UIManager.put("TabbedPane.focus", new ColorUIResource(BOREUM_PETROL_LIGHT));
        UIManager.put("TabbedPane.selectedTabPadInsets ", new InsetsUIResource(0, 4, 0, 4));
        UIManager.put("TabbedPane.tabPadInsets ", new InsetsUIResource(0, 4, 2, 4));
        UIManager.put("TabbedPane.selectionFollowsFocus", Boolean.TRUE);
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        UIManager.put("TabbedPane.tabAreaInsets ", new InsetsUIResource(0, 0, 0, 0));
        UIManager.put("TabbedPane.shadow", GRAY_3_RESOURCE);
        UIManager.put("TabbedPane.darkShadow", GRAY_3_RESOURCE);
        UIManager.put("TabbedPane.light", BACKGROUND_COLOR);
        UIManager.put("TabbedPane.highlight", BACKGROUND_COLOR);
        UIManager.put("TabbedPane.lightHighlight", BACKGROUND_COLOR);
        UIManager.put("TabbedPane.unselectedBackground", new ColorUIResource(BOREUM_PETROL_MENU));
        UIManager.put("ComboBox.background", BACKGROUND_COLOR);
        UIManager.put("ComboBox.foreground", SIGNER_BLACK);
        UIManager.put("ComboBox.listForeground", BACKGROUND_COLOR);
        UIManager.put("ComboBox.listBackground", SIGNER_BLACK);
        UIManager.put("TableHeader.background", BACKGROUND_COLOR);
        UIManager.put("scrollbar", BACKGROUND_COLOR);
        UIManager.put("ComboBox.buttonBackground", BACKGROUND_COLOR);
        UIManager.put("TextField.inactiveBackground", BACKGROUND_COLOR);
        UIManager.put("MenuBar.borderColor", BACKGROUND_COLOR);
        UIManager.put("InternalFrame.inactiveTitleBackground", BACKGROUND_COLOR);
        UIManager.put("inactiveCaption", BACKGROUND_COLOR);
        UIManager.put("menu", BACKGROUND_COLOR);
        UIManager.put("ComboBox.disabledBackground", BACKGROUND_COLOR);
        UIManager.put("control", BACKGROUND_COLOR);
        UIManager.put("ScrollBar.track", BACKGROUND_COLOR);
        UIManager.put("FormattedTextField.inactiveBackground", BACKGROUND_COLOR);
        UIManager.put("ScrollBar.foreground", BACKGROUND_COLOR);
        UIManager.put("PasswordField.inactiveBackground", BACKGROUND_COLOR);
        UIManager.put("ColorChooser.swatchesDefaultRecentColor", BACKGROUND_COLOR);
        UIManager.put("windowBorder", BACKGROUND_COLOR);
        UIManager.put("Spinner.foreground", BACKGROUND_COLOR);
        UIManager.put("ToolBar.floatingBackground", BACKGROUND_COLOR);
        UIManager.put("ToolBar.borderColor", BACKGROUND_COLOR);
        UIManager.put("ToolBar.dockingBackground", BACKGROUND_COLOR);
        UIManager.put("InternalFrame.borderColor", BACKGROUND_COLOR);
        UIManager.put("TitledBorder.titleColor", SIGNER_BLUE_1);
        UIManager.put("TitledCurvedBorderText.foreground", SIGNER_BLUE_1);
        UIManager.put("CurvedBorder.foreground", GRAY_3);
        UIManager.put("TitledCurvedBorder.foreground", GRAY_3);
        UIManager.put("LinkButtonText.foreground", COLOR_GREEN);
        UIManager.put("LinkButtonText.foreground.transparent", BACKGROUND_COLOR);
        UIManager.put("Separator.foreground", GRAY_7);
        UIManager.put("TextField.error.background", COLOR_RED);
        UIManager.put("TextField.error.foreground", Color.WHITE);
        UIManager.put("OptionPane.informationIcon", GUIUtils.INFORMATION_ICON);
        UIManager.put("OptionPane.warningIcon", GUIUtils.WARNING_ICON);
        UIManager.put("OptionPane.questionIcon", GUIUtils.QUESTION_ICON);
        UIManager.put("OptionPane.errorIcon", GUIUtils.ERROR_ICON);
        UIManager.put("Dialog.TitleIcon", new ImageIcon(SignerTheme.class.getResource("/resources/boreum_24.png")));
        this.setLocaleGERMANintoFileChooser();
    }

    public static int getScreenResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public static float getScreenResolutionFactor() {
        return (float)((int)((double)SignerTheme.getScreenResolution() / 72.0 * 100.0)) / 100.0f;
    }

    protected static int getFontsizeRelativeToResolution(int screenResolution) {
        int screenRes = screenResolution;
        float screenResFactor = (float)((int)((double)screenRes / 72.0 * 100.0)) / 100.0f;
        return (int)Math.round(12.0 * (double)screenResFactor);
    }

    protected static int getFontSizeRelativToResolution() {
        return SignerTheme.getFontsizeRelativeToResolution(Toolkit.getDefaultToolkit().getScreenResolution());
    }

    private void setLocaleGERMANintoFileChooser() {
        if (!Locale.GERMAN.equals(LocaleChanger.getInstance().getActualLocale())) {
            return;
        }
        if (!System.getProperty("java.version").startsWith("11")) {
            return;
        }
        UIManager.put("FileChooser.openButtonText", "\u00d6ffnen");
        UIManager.put("FileChooser.cancelButtonText", "Abbrechen");
        UIManager.put("FileChooser.saveButtonText", "Speichern");
        UIManager.put("FileChooser.cancelButtonToolTipText", "Abbrechen der Auswahl");
        UIManager.put("FileChooser.saveButtonToolTipText", "Ausgew\u00e4hlte Datei speichern");
        UIManager.put("FileChooser.openButtonToolTipText", "Ausgew\u00e4hlte Datei \u00f6ffnen");
        UIManager.put("FileChooser.upFolderToolTipText", "Eine Ebene h\u00f6her");
        UIManager.put("FileChooser.homeFolderToolTipText", "Home");
        UIManager.put("FileChooser.newFolderToolTipText", "Neuen Ordner erstellen");
        UIManager.put("FileChooser.listViewButtonToolTipText", "Liste");
        UIManager.put("FileChooser.detailsViewButtonToolTipText", "Details");
        UIManager.put("FileChooser.lookInLabelText", "Suchen in:");
        UIManager.put("FileChooser.fileNameHeaderText", "Dateiname");
        UIManager.put("FileChooser.fileNameLabelText", "Dateiname:");
        UIManager.put("FileChooser.filesOfTypeLabelText", "Dateityp:");
        UIManager.put("FileChooser.acceptAllFileFilterText", "Alle Dateien (*.*)");
    }

    private void updateButtonUIManager() {
        UIManager.put("Button.gradient", BUTTON_GRADIENT);
        UIManager.put("Button.disabledText", GRAY_7_RESOURCE);
        UIManager.put("Button.disabledForeground", GRAY_7);
        UIManager.put("Button.focus", BOREUM_PETROL_RESOURCE);
        UIManager.put("Button.select", new ColorUIResource(BOREUM_PETROL_LIGHT));
        UIManager.put("Button.background", BACKGROUND_COLOR);
        UIManager.put("Button.foreground", BOREUM_PETROL_BLACK_UI);
        UIManager.put("Button.border", new BorderUIResource(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SIGNER_BLUE_1, 1), new EmptyBorder(3, 10, 3, 10))));
        UIManager.put("Button.defaultButtonFollowsFocus", BOREUM_PETROL_RESOURCE);
        UIManager.put("Button.contentAreaFilled", false);
        UIManager.put("Button.opaque", true);
    }

    private void updateScrollBarUIanager() {
        UIManager.put("ScrollBar.gradient", BUTTON_GRADIENT);
        UIManager.put("ScrollBar.thumb", WHITE_RESOURCE);
        UIManager.put("ScrollBar.thumbDarkShadow", WHITE_RESOURCE);
        UIManager.put("ScrollBar.thumbHighlight", WHITE_RESOURCE);
        UIManager.put("ScrollBar.thumbLightShadow", WHITE_RESOURCE);
        UIManager.put("ScrollBar.thumbShadow", GRAY_3_RESOURCE);
        UIManager.put("ScrollBar.background", WHITE_RESOURCE);
        UIManager.put("ScrollBar.foreground", WHITE_RESOURCE);
        UIManager.put("ScrollBar.trackForeground", WHITE_RESOURCE);
        UIManager.put("ScrollBar.trackHighlightForeground", WHITE_RESOURCE);
        UIManager.put("ScrollBar.track", WHITE_RESOURCE);
        UIManager.put("ScrollBar.trackHighlight", WHITE_RESOURCE);
        UIManager.put("ScrollBar.darkShadow", GRAY_3_RESOURCE);
        UIManager.put("ScrollBar.highlight", WHITE_RESOURCE);
        UIManager.put("ScrollBar.shadow", WHITE_RESOURCE);
        UIManager.put("ScrollBar.width", 20);
        UIManager.put("ScrollBar.decrementButtonGap", 10);
        UIManager.put("ScrollBar.incrementButtonGap", 10);
    }

    private void updateGeneralUIManager() {
        UIManager.put("Component.hideMnemonics", false);
        UIManager.put("Component.arrowType", "triangle");
    }
}

