/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessListener;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.AllStepsPanel;
import de.bos_bremen.ecard.client.gui.ButtonPanel;
import de.bos_bremen.ecard.client.gui.StepPanel;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.NavigationPanel;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessPanel
implements ProcessListener,
StepChangedListener,
PropertyChangeListener {
    private static final Logger LOG = LogManager.getLogger(ProcessPanel.class);
    private final ProcessI process;
    private JPanel processStepButtonsPanel;
    private final JPanel westPanel;
    private AllStepsPanel stepContentPanel;
    private CardLayout cardLayout;
    private HashMap<String, ButtonPanel> processStepButtons;

    public ProcessPanel(ProcessI nextProcess) {
        LOG.trace("====== View ======");
        LOG.info("init process: {} : {}", (Object)nextProcess, (Object)Document.getInstance().getCurrentFrameworkState());
        this.process = nextProcess;
        this.process.addProcessListener(this);
        this.initContent();
        this.initStepButtons();
        for (Step step : this.process.getSteps()) {
            StepPanel stepPanel = new StepPanel(step);
            this.stepContentPanel.add((Component)stepPanel, step.getStepName().getName());
            step.addStateChangeListener(this);
        }
        this.westPanel = new JPanel();
        this.westPanel.setLayout(new BorderLayout());
        NavigationPanel borderPanel = new NavigationPanel(this.process.getProcessName());
        borderPanel.setContent(this.processStepButtonsPanel);
        this.westPanel.add((Component)borderPanel, "Center");
        LocaleChanger.getInstance().addObserver(this);
        LOG.trace("================");
    }

    private void initContent() {
        this.processStepButtonsPanel = new JPanel(new GridBagLayout());
        this.processStepButtons = new HashMap();
        this.cardLayout = new CardLayout();
        this.stepContentPanel = new AllStepsPanel(this.cardLayout);
    }

    private void initStepButtons() {
        this.processStepButtonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        StepButtonGroup bg = new StepButtonGroup();
        List<Step> steps = this.process.getSteps();
        int stepCounter = 0;
        boolean isFirstStep = true;
        for (int i = 0; i < steps.size(); ++i) {
            Step step = steps.get(i);
            if (!step.getLicenceTyp().isVisible()) continue;
            ButtonPanel stepButton = new ButtonPanel(this, step, stepCounter++, isFirstStep, i == steps.size() - 1, bg);
            isFirstStep = false;
            gbc.gridy = i;
            this.processStepButtonsPanel.add((Component)stepButton, gbc);
            this.processStepButtons.put(step.getStepName().getName(), stepButton);
        }
        this.updateButton();
    }

    public JComponent getNavigationView() {
        return this.westPanel;
    }

    public JComponent getDetailView() {
        return this.stepContentPanel;
    }

    @Override
    public void processChange() {
        Step step = this.process.getCurrentStep();
        this.cardLayout.show(this.stepContentPanel, step.getStepName().getName());
        if (this.processStepButtons.get(step.getStepName().getName()) != null) {
            this.processStepButtons.get(step.getStepName().getName()).setSelected(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.updateButton();
    }

    private void updateButton() {
        for (Step step : this.process.getSteps()) {
            StringBuilder tooltip;
            ButtonPanel panel = this.processStepButtons.get(step.getStepName().getName());
            if (panel == null) continue;
            if (this.process.getCurrentStep().equals(step)) {
                panel.setActive(true);
            }
            if (step instanceof WorkingStep) {
                WorkingStep workingStep = (WorkingStep)step;
                if (!this.process.canProcess()) {
                    panel.setEnabled(false);
                    tooltip = new StringBuilder("<html>");
                    List<String> completeDetails = workingStep.getParent().getCompleteDetails();
                    for (String reason : completeDetails) {
                        tooltip.append(reason + "<br>");
                    }
                    tooltip.append("</html>");
                    panel.setToolTipText(completeDetails == null || completeDetails.isEmpty() ? null : Utils.htmlToAscii(tooltip.toString()));
                    continue;
                }
                if (!workingStep.isStateComplete()) {
                    panel.setToolTipText(Utils.htmlToAscii("<html>" + workingStep.getInCompleteDetails() + "</html>"));
                    continue;
                }
                panel.setEnabled(true);
                panel.setToolTipText(null);
                continue;
            }
            if (!step.isStateComplete()) {
                tooltip = new StringBuilder("<html>" + step.getInCompleteDetails() + "</html>");
                panel.setToolTipText(tooltip.toString());
                continue;
            }
            panel.setToolTipText(null);
        }
        if (this.process.getLicenceTyp().isVisible() && !this.process.getCurrentStep().getLicenceTyp().isVisible()) {
            this.process.previousStep();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.processStepButtonsPanel.removeAll();
        for (ButtonPanel buttonPanel : this.processStepButtons.values()) {
            buttonPanel.removeProcessListener();
            buttonPanel.removeStateChangeListener();
        }
        this.processStepButtons.clear();
        this.initStepButtons();
        this.processStepButtonsPanel.revalidate();
    }

    @Override
    public void setActive(boolean active) {
    }

    public void requestFocus() {
        StepPanel stepPanel;
        Component component;
        Component[] components;
        Step step = this.process.getCurrentStep();
        this.cardLayout.show(this.stepContentPanel, step.getStepName().getName());
        Component[] componentArray = components = this.stepContentPanel.getComponents();
        int n = componentArray.length;
        for (int i = 0; !(i >= n || (component = componentArray[i]) instanceof StepPanel && (stepPanel = (StepPanel)component).isVisible()); ++i) {
        }
    }

    public Container getParent() {
        return this.processStepButtonsPanel.getParent();
    }

    public class StepButtonGroup
    extends ButtonGroup {
        private static final long serialVersionUID = -7499109778321269525L;
        private List<JToggleButton> buttonListInGroup;

        public void createListFromGroup() {
            this.buttonListInGroup = new ArrayList<JToggleButton>(this.getButtonCount());
            Enumeration<AbstractButton> elements = this.getElements();
            while (elements.hasMoreElements()) {
                this.buttonListInGroup.add((JToggleButton)elements.nextElement());
            }
        }

        public JToggleButton getNextFrom(JToggleButton focused) {
            ListIterator<JToggleButton> listIterator = this.buttonListInGroup.listIterator();
            while (listIterator.hasNext()) {
                JToggleButton current = listIterator.next();
                if (!focused.getName().equals(current.getName())) continue;
                break;
            }
            if (listIterator.hasNext()) {
                return listIterator.next();
            }
            return null;
        }

        public JToggleButton getPreviousFrom(JToggleButton focused) {
            ListIterator<JToggleButton> listIterator = this.buttonListInGroup.listIterator();
            while (listIterator.hasNext()) {
                JToggleButton current = listIterator.next();
                if (!focused.getName().equals(current.getName())) continue;
                break;
            }
            if (listIterator.hasPrevious()) {
                JToggleButton previous = listIterator.previous();
                if (focused.getName().equals(previous.getName()) && listIterator.hasPrevious()) {
                    return listIterator.previous();
                }
            }
            return null;
        }

        public JToggleButton getFirst() {
            return this.buttonListInGroup.get(0);
        }

        public JToggleButton getLast() {
            int size = this.buttonListInGroup.size();
            return this.buttonListInGroup.get(size - 1);
        }
    }
}

