/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.HelpAction;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.gui.DynamicView;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.NavigationView;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessChooseView
implements ActionListener,
PropertyChangeListener {
    private static final String ACTION = "action.";
    private final DynamicView detailView;
    private JPanel processChoosePanel;
    private final NavigationView navigationView;
    private final HashMap<ProcessName, ProcessI> processList = new HashMap();
    private ProcessName activeProcess;
    private static final Logger LOG = LogManager.getLogger(ProcessChooseView.class);

    public ProcessChooseView(NavigationView navView, DynamicView detail) {
        this.detailView = detail;
        this.navigationView = navView;
        this.initContent();
        this.initButtons();
        this.initGUI();
        LocaleChanger.getInstance().addObserver(this);
    }

    private void initContent() {
        this.processChoosePanel = new JPanel();
        this.processChoosePanel.setLayout(new GridLayout(2, 2));
        this.processChoosePanel.setBackground(CurvedBorder.BOREUM_PETROL);
    }

    private void initButtons() {
        List<ProcessI> processes = Document.getInstance().getProcessFactory().getProcesses();
        if (processes != null) {
            for (ProcessI processI : processes) {
                if (processI.getProcessName().getProcessIndex() >= 4) continue;
                this.initButton(processI.getLicenceTyp(), processI.getProcessName());
            }
        }
    }

    private void initButton(LicenceTyp licenceTyp, ProcessName processName) {
        if (licenceTyp.isVisible()) {
            if (licenceTyp.isEditable()) {
                this.processChoosePanel.add(this.createProcessButton(processName, true));
            } else {
                this.processChoosePanel.add(ProcessChooseView.createProcessLabel(processName, false));
            }
        } else {
            this.processChoosePanel.add(ProcessChooseView.createProcessLabel(RootProcessName.getInstance(), true));
        }
    }

    private void initGUI() {
        this.detailView.setView(this.processChoosePanel, RootProcessName.getInstance());
    }

    private static JLabel createProcessLabel(ProcessName process, boolean showProcessDisplayName) {
        Icon icon = ComponentUtils.getIcon("view.processchooser." + process.getName() + ".big");
        JLabel processIconLabel = new JLabel(icon);
        processIconLabel.setText(showProcessDisplayName ? process.getDisplayName() : null);
        processIconLabel.setOpaque(true);
        processIconLabel.setEnabled(false);
        return processIconLabel;
    }

    private JButton createProcessButton(final ProcessName process, boolean useBigIcons) {
        IconButton processButton = null;
        processButton = useBigIcons ? new IconButton("view.processchooser." + process.getName() + ".big") : new IconButton("view.processchooser." + process.getName());
        processButton.setBorder(CurvedBorder.BORDER_PROCESS_FOCUSLESS);
        processButton.addFocusListener(ComponentUtils.createFocusListenerFor((JComponent)processButton, processButton.getBorder(), (Border)CurvedBorder.BORDER_PROCESS_FOCUSED));
        processButton.addFocusListener(ComponentUtils.createFocusListenerForIcon(processButton));
        processButton.addMouseListener(ComponentUtils.createMouseAdapterForButton(processButton));
        processButton.setFocusPainted(false);
        this.makeReadable(processButton, process.getName());
        processButton.setActionCommand(process.getName());
        processButton.addActionListener(this);
        String key = Messages.getResource(ACTION + process.getName() + ".key");
        if (key != null && !key.isEmpty()) {
            KeyStroke ks = KeyStroke.getKeyStroke(key);
            processButton.getInputMap(2).put(ks, ACTION + process.getName());
        }
        processButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (10 == keyEvent.getKeyCode() || 32 == keyEvent.getKeyCode()) {
                    ProcessI processToShow = Document.getInstance().getProcessFactory().getProcess(process.getName());
                    if (processToShow != null) {
                        LOG.debug("show: {}", (Object)processToShow.getProcessName());
                        ProcessChooseView.this.showProcess(processToShow.getProcessName());
                    }
                    keyEvent.consume();
                }
            }
        });
        return processButton;
    }

    private void makeReadable(JComponent conponent, String processName) {
        String actionProcess = ACTION + processName;
        String name = Messages.getString(actionProcess, actionProcess);
        conponent.setName(name);
        conponent.getAccessibleContext().setAccessibleName(name);
        String actionTooltip = Messages.getString(actionProcess + ".tooltip", actionProcess + ".tooltip");
        conponent.setToolTipText(MultiLineTooltips.wrapToolTip(actionTooltip));
        conponent.getAccessibleContext().setAccessibleDescription(actionTooltip);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProcessI process = Document.getInstance().getProcessFactory().getProcess(e.getActionCommand());
        if (process == null) {
            LOG.error("Konnte keinen Process fuer {} finden", (Object)e.getActionCommand());
            this.showProcess(RootProcessName.getInstance());
        } else {
            this.showProcess(process.getProcessName());
        }
    }

    public void showProcess(ProcessName processName) {
        ProcessI process;
        LOG.info("show Process : {} ...", (Object)processName);
        ProcessI oldprocess = this.processList.get(this.activeProcess);
        if (oldprocess != null && !oldprocess.getProcessName().equals(processName)) {
            LOG.info("stop Process : {}", (Object)oldprocess.getProcessName());
            oldprocess.stopProcess();
        }
        this.activeProcess = processName;
        LOG.info("active Process : old -{}- : new -{}-", (Object)oldprocess, (Object)processName);
        LOG.info("****** {} ******", (Object)processName);
        this.navigationView.showView(processName);
        this.detailView.showView(processName);
        if (RootProcessName.getInstance().equals(this.activeProcess)) {
            HelpAction.enableHelpKey(this.detailView.getView(), "");
        }
        if ((process = this.processList.get(this.activeProcess)) == null) {
            return;
        }
        ProcessFormular formular = Document.getInstance().getProcessFactory().getProcessesFormular(process);
        process.startProcess(formular);
        LOG.debug("show Process {} : {}", (Object)processName, (Object)Document.getInstance().getCurrentFrameworkState());
    }

    public ProcessName getActiveProcess() {
        return this.activeProcess;
    }

    public void addProcess(ProcessI process) {
        this.processList.put(process.getProcessName(), process);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.processChoosePanel.removeAll();
        this.initButtons();
        this.processChoosePanel.revalidate();
    }

    public void requestFocus() {
        this.detailView.requestFocus();
    }
}

