/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLineTooltips {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiLineTooltips.class);
    public static final int TOOLTIP_MAX_SIZE = 40;
    private static final int SPACE_BUFFER = 5;

    private MultiLineTooltips() {
        throw new IllegalStateException("Utility class");
    }

    public static String wrapToolTip(String tooltipText, boolean isCenter) {
        return MultiLineTooltips.wrapToolTip(tooltipText, 40, isCenter);
    }

    public static String wrapToolTip(String tooltipText) {
        return MultiLineTooltips.wrapToolTip(tooltipText, 40, false);
    }

    public static String wrapToolTip(String tooltipText, int tooltipWidth, boolean isCenter) {
        if (tooltipText == null || tooltipText.isEmpty()) {
            return tooltipText;
        }
        if (tooltipText.length() <= tooltipWidth + 5) {
            return tooltipText;
        }
        List<String> wrappedTooltip = MultiLineTooltips.breakLines(tooltipText, tooltipWidth);
        return MultiLineTooltips.tooltipToHtml(wrappedTooltip, isCenter);
    }

    public static String wrapToolTip(String tooltipText, int tooltipWidth) {
        return MultiLineTooltips.wrapToolTip(tooltipText, tooltipWidth, false);
    }

    private static List<String> breakLines(String tooltipText, int tooltipWidth) {
        ArrayList<String> wrappedTooltip = new ArrayList<String>();
        while (tooltipText.length() >= tooltipWidth + 5) {
            String tipNew;
            String overLong = tooltipText.substring(0, tooltipWidth + 5);
            int lastSpace = overLong.lastIndexOf(32) + 1;
            int lastSlash = overLong.lastIndexOf(47) + 1;
            int lastBreak = overLong.lastIndexOf("\n") + 1;
            if (lastBreak > 0) {
                lastSpace = lastBreak;
            } else if (lastSpace == 0 && lastSlash > 0) {
                lastSpace = lastSlash;
            } else if (lastSpace == 0 && lastSlash == 0 && lastBreak == 0) {
                lastSpace = tooltipWidth;
            }
            if (tooltipText.length() < tooltipWidth) continue;
            String row = tooltipText.substring(0, lastSpace);
            tooltipText = tipNew = MultiLineTooltips.removePrefix(row, tooltipText);
            if (row == null) continue;
            wrappedTooltip.add(row.replace("\n", ""));
        }
        wrappedTooltip.add(tooltipText);
        return wrappedTooltip;
    }

    public static String wrappString(String text, int textWidth) {
        List<String> list = MultiLineTooltips.breakLines(text, textWidth);
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < list.size() - 1; ++i) {
            sb.append(list.get(i) + "\n");
            log.trace(list.get(i));
        }
        sb.append(list.get(list.size() - 1));
        log.trace("");
        return sb.toString();
    }

    public static String stringToHtml(String text, boolean isCenter) {
        StringBuilder sb = new StringBuilder("");
        String result = text.replace("\n", "<br>");
        sb.append(MultiLineTooltips.htmlStart(isCenter));
        sb.append(result);
        sb.append(MultiLineTooltips.htmlEnd(isCenter));
        log.trace("");
        return sb.toString();
    }

    public static String stringToHtml(String text) {
        return MultiLineTooltips.stringToHtml(text, false);
    }

    private static String tooltipToHtml(List<String> wrappedTooltip, boolean isCenter) {
        StringBuilder sb = new StringBuilder(MultiLineTooltips.htmlStart(isCenter));
        for (int i = 0; i < wrappedTooltip.size() - 1; ++i) {
            if (wrappedTooltip.get(i).contains("\n")) {
                sb.append(wrappedTooltip.get(i).replace("\n", "<br>"));
                continue;
            }
            sb.append(wrappedTooltip.get(i) + "<br>");
        }
        sb.append(wrappedTooltip.get(wrappedTooltip.size() - 1));
        sb.append(MultiLineTooltips.htmlEnd(isCenter));
        return sb.toString();
    }

    public static String removePrefix(String prefix, String tooltip) {
        if (tooltip == null || prefix == null || !tooltip.startsWith(prefix)) {
            return tooltip;
        }
        return tooltip.substring(prefix.length());
    }

    private static String htmlStart(boolean isCenter) {
        return isCenter ? "<html><center>" : "<html>";
    }

    private static String htmlEnd(boolean isCenter) {
        return isCenter ? "</center></html>" : "</html>";
    }
}

