/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class IconScalingUtils {
    private static final String RESOURCES = "/resources/";
    private static final Logger LOG = LogManager.getLogger(IconScalingUtils.class);
    private static final Map<String, Image> renderedImages = new HashMap<String, Image>();
    private static int iterations = 0;

    private IconScalingUtils() {
    }

    public static BaseMultiResolutionImage createMultiResImage(URL imageLocation, int initialWidth, int initialHeight) {
        float screenResFactor = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0f;
        List<Integer> widths = List.of(Integer.valueOf((int)((double)initialWidth * 1.0)), Integer.valueOf((int)((float)initialWidth * screenResFactor)));
        List<Integer> heights = List.of(Integer.valueOf((int)((double)initialHeight * 1.0)), Integer.valueOf((int)((float)initialHeight * screenResFactor)));
        ArrayList<Image> images = new ArrayList<Image>();
        for (int i = 0; i < widths.size(); ++i) {
            PNGTranscoder t = new PNGTranscoder();
            t.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(widths.get(i).intValue()));
            t.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(heights.get(i).intValue()));
            TranscoderInput input = new TranscoderInput(imageLocation.toString());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)outputStream);
            try {
                t.transcode(input, output);
            }
            catch (TranscoderException transcoderException) {
                // empty catch block
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.toByteArray());
            while (image.getWidth(null) == -1) {
            }
            LOG.trace("Rendered {} images", (Object)(++iterations));
            images.add(image);
        }
        return new BaseMultiResolutionImage(images.toArray(new Image[0]));
    }

    public static ImageIcon createMultiResIcon(String imageKey) {
        URL imageLocation;
        String iconName = Messages.getResource(imageKey);
        if (iconName == null) {
            iconName = System.getProperty(imageKey);
        }
        if ((imageLocation = AbstractSignerAction.class.getResource(RESOURCES + iconName)) != null && imageLocation.toString().endsWith(".svg")) {
            String imageWidth = Messages.getResource(imageKey + ".width");
            String imageHeight = Messages.getResource(imageKey + ".height");
            if (imageWidth != null && imageHeight != null) {
                return IconScalingUtils.createMultiResIcon(imageKey, Integer.parseInt(imageWidth), Integer.parseInt(imageHeight));
            }
            LOG.trace("Angabe W x H sind nicht g\u00fcltig : -{}- x -{}-", (Object)imageWidth, (Object)imageHeight);
            LOG.trace("Could not find properties for width and height of svg image: {}", (Object)imageLocation);
        } else if (imageLocation != null) {
            LOG.trace("SVG ist nicht vorhanden f\u00fcr : {}", (Object)imageLocation);
            LOG.trace("Could not create MultiResolutionIcon from File: {}", (Object)imageLocation);
            return new ImageIcon(imageLocation);
        }
        return null;
    }

    public static ImageIcon createMultiResIcon(String imageKey, int imageWidth, int imageHeight) {
        String iconName = Messages.getString(imageKey);
        Image renderedImage = renderedImages.get(iconName + imageWidth);
        if (renderedImage != null) {
            return new ImageIcon(renderedImage);
        }
        LOG.trace("-{}- wurde angefragt, aber nicht gefunden", (Object)imageKey);
        URL imageLocation = AbstractSignerAction.class.getResource(RESOURCES + iconName);
        if (imageLocation != null && imageLocation.toString().endsWith(".svg")) {
            BaseMultiResolutionImage image = IconScalingUtils.createMultiResImage(imageLocation, imageWidth, imageHeight);
            renderedImages.put(iconName + imageWidth, image);
            return new ImageIcon(image);
        }
        if (imageLocation != null) {
            return new ImageIcon(imageLocation);
        }
        return null;
    }

    public static ImageIcon createMultiResIconFromImgSet(String imageKey) {
        String iconName = Messages.getResource(imageKey);
        if (iconName == null) {
            iconName = System.getProperty(imageKey);
        }
        ArrayList<String> iconNames = new ArrayList<String>();
        for (int scale = 100; scale <= 300; scale += 25) {
            String name = iconName.replace("xxx", String.valueOf(scale));
            iconNames.add(name);
        }
        ArrayList<Image> images = new ArrayList<Image>();
        for (String name : iconNames) {
            URL imageLocation = AbstractSignerAction.class.getResource(RESOURCES + name);
            if (imageLocation == null) continue;
            images.add(new ImageIcon(imageLocation).getImage());
        }
        if (!images.isEmpty()) {
            return new ImageIcon(new BaseMultiResolutionImage(images.toArray(new Image[0])));
        }
        return null;
    }

    public static ImageIcon dimMultiResIcon(ImageIcon icon) {
        if (icon == null) {
            return null;
        }
        Image image = icon.getImage();
        if (!(image instanceof BaseMultiResolutionImage)) {
            return null;
        }
        BaseMultiResolutionImage baseMultiResolutionImage = (BaseMultiResolutionImage)image;
        List<Image> images = baseMultiResolutionImage.getResolutionVariants();
        ArrayList<Image> dimmedImages = new ArrayList<Image>();
        for (Image image2 : images) {
            BufferedImage bImage = IconScalingUtils.toBufferedImage(image2);
            GrayFilter grayFilter = new GrayFilter(true, 55);
            FilteredImageSource imageProducer = new FilteredImageSource(bImage.getSource(), grayFilter);
            dimmedImages.add(Toolkit.getDefaultToolkit().createImage(imageProducer));
        }
        return new ImageIcon(new BaseMultiResolutionImage(dimmedImages.toArray(new Image[0])));
    }

    private static BufferedImage toBufferedImage(Image image) {
        BufferedImage bImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bImage;
    }
}

