/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.gui.FontSize;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class GUIUtils {
    public static final Icon INFORMATION_ICON = ComponentUtils.getIcon("dialog.optionPane.information");
    public static final Icon QUESTION_ICON = ComponentUtils.getIcon("dialog.optionPane.question");
    public static final Icon WARNING_ICON = ComponentUtils.getIcon("dialog.optionPane.warning");
    public static final Icon ERROR_ICON = ComponentUtils.getIcon("dialog.optionPane.error");

    private GUIUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Dimension convertRelativeToScreenSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            return new Dimension();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenSize.width <= width || screenSize.height <= height) {
            int min = Math.min(screenSize.width, screenSize.height);
            double h = (double)min * 0.9;
            double w = h * 1.35;
            return new Dimension((int)w, (int)h);
        }
        return new Dimension(width, height);
    }

    public static void makeReadable(JComponent component, String test) {
        component.setName(test);
        component.setToolTipText(test + " - Tooltip");
        component.getAccessibleContext().setAccessibleName(test + " - Name");
        component.getAccessibleContext().setAccessibleDescription(test + " - Beschreibung");
    }

    public static void makeFocusable(JComponent component) {
        component.setFocusable(true);
        component.setBorder(CurvedBorder.DEFAULT_BORDER);
        component.addFocusListener(ComponentUtils.createFocusListenerFor(component));
    }

    public static Dimension createChooserDimension(Component parent) {
        if (parent == null) {
            parent = Document.getInstance().getFrame();
        }
        Dimension parentMinimumSize = parent == null ? GUIUtils.createDialogMinDimension() : (parent.getMinimumSize() == null ? parent.getSize() : parent.getMinimumSize());
        double w = (double)parentMinimumSize.width * 0.9;
        double h = (double)parentMinimumSize.height * 0.9;
        return new Dimension((int)w, (int)h);
    }

    public static Dimension createChooserDimension() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double w = (double)screenSize.width * 0.65 * 0.9;
        double h = w * 0.9 / 1.35;
        return new Dimension((int)w, (int)h);
    }

    public static Dimension createConfigDialogDimension(Dimension parent) {
        double w = parent.getWidth();
        double h = parent.getHeight();
        if (w == 0.0) {
            return GUIUtils.createConfigDialogMinDimension();
        }
        Dimension configDialogSize = Config.getInstance().getConfigDialogSize();
        if (configDialogSize != null) {
            return configDialogSize;
        }
        double screenH = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double screenW = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        FontSize fontSize = Document.getInstance().getFontSize();
        switch (fontSize) {
            case SMALL: {
                w = parent.getWidth() - 70.0;
                h = parent.getHeight() + 90.0;
                h = Math.min(h, screenH);
                break;
            }
            case NORMAL: {
                w = parent.getWidth() + 50.0;
                h = parent.getHeight() + 190.0;
                w = Math.min(w, screenW);
                h = Math.min(h, screenH);
                break;
            }
            case BIG: {
                w = parent.getWidth() + 170.0;
                h = parent.getHeight() + 280.0;
                w = Math.min(w, screenW);
                h = Math.min(h, screenH);
                break;
            }
        }
        return new Dimension((int)w, (int)h);
    }

    public static Dimension createConfigDialogMinDimension() {
        double w = Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 0.6;
        double h = Toolkit.getDefaultToolkit().getScreenSize().getHeight() * 0.8;
        return new Dimension((int)w, (int)h);
    }

    public static Dimension createDialogMinDimension() {
        double w = Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 0.7;
        double h = Toolkit.getDefaultToolkit().getScreenSize().getHeight() * 0.7;
        return new Dimension((int)w, (int)h);
    }

    public static Dimension createRelativeToParent(Dimension parentDimension) {
        double w = parentDimension.getWidth() * 0.9;
        double h = parentDimension.getHeight() * 0.9;
        return new Dimension((int)w, (int)h);
    }

    public static Dimension createRelativeToParent(Dimension parentMinDimension, double widthSmaller, double heightSmaller) {
        boolean heightOK;
        boolean widthOK;
        boolean bl = widthOK = 0.0 < widthSmaller && widthSmaller <= 1.0;
        if (!widthOK) {
            return null;
        }
        boolean bl2 = heightOK = 0.0 < heightSmaller && heightSmaller <= 1.0;
        if (!heightOK) {
            return null;
        }
        double w = parentMinDimension.getWidth() * widthSmaller;
        double h = parentMinDimension.getHeight() * heightSmaller;
        return new Dimension((int)w, (int)h);
    }

    public static int getScreenResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public static float getScreenResolutionFactor() {
        return (float)((int)((double)GUIUtils.getScreenResolution() / 72.0 * 100.0)) / 100.0f;
    }

    public static Dimension toCurrentDimension(int width72dpi, int high72dpi) {
        return new Dimension(GUIUtils.toCurrentPx(width72dpi), GUIUtils.toCurrentPx(high72dpi));
    }

    public static int toCurrentPx(int px72dpi) {
        float factor = (float)GUIUtils.getScreenResolution() / 72.0f;
        return (int)(factor * (float)px72dpi);
    }

    public static void setSignerThemeInUIManager() {
        try {
            MetalLookAndFeel.setCurrentTheme(new SignerTheme());
            UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
            UIManager.put("OptionPane.buttonFont", new FontUIResource(UIManager.getFont("Button.font")));
            UIManager.put("OptionPane.messageFont", new FontUIResource(UIManager.getFont("Label.font")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateFontSizeFromConfig() {
        SwingUtilities.invokeLater(() -> {
            GUIUtils.setSignerThemeInUIManager();
            LocaleChanger.getInstance().setLocale(Config.getInstance().getLocale(), true);
        });
    }

    public static Dimension createMainDialogDimension() {
        Dimension size = new Dimension(940, 690);
        return GUIUtils.convertRelativeToScreenSize((int)size.getWidth(), (int)size.getHeight());
    }

    public static Dimension createMainMaxDimension() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Dimension createCertificateDialogDimension() {
        Dimension mainDialogDimension = GUIUtils.createMainDialogDimension();
        double w = (double)mainDialogDimension.width * 0.5;
        double h = (double)mainDialogDimension.height * 0.9;
        return new Dimension((int)w, (int)h);
    }

    public static JScrollPane createScrollPaneFor(JPanel contentPanel) {
        return new JScrollPane(contentPanel, 20, 31);
    }
}

