/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.control.process.ProcessName;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicView {
    private static final Logger LOG = LogManager.getLogger(DynamicView.class);
    private JPanel dynamicPanel;
    private CardLayout cardLayout;
    private HashMap<ProcessName, Dimension> preferedSizeMap = new HashMap();

    protected DynamicView() {
        LOG.trace("");
        this.dynamicPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.dynamicPanel.setLayout(this.cardLayout);
    }

    public void setView(JComponent view, ProcessName processName) {
        this.preferedSizeMap.put(processName, view.getPreferredSize());
        this.dynamicPanel.add((Component)view, processName.getName());
    }

    public void showView(ProcessName processName) {
        this.cardLayout.show(this.dynamicPanel, processName.getName());
        this.cardLayout.invalidateLayout(this.dynamicPanel);
        this.dynamicPanel.revalidate();
    }

    public JComponent getView() {
        return this.dynamicPanel;
    }

    public JPanel getDynamicPanel() {
        return this.dynamicPanel;
    }

    public void requestFocus() {
        Component[] components;
        for (Component component : components = this.dynamicPanel.getComponents()) {
            JPanel jPanel;
            if (!(component instanceof JPanel) || !(jPanel = (JPanel)component).isVisible()) continue;
            jPanel.requestFocus();
            break;
        }
    }
}

