/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.gui.DynamicView;
import de.bos_bremen.ecard.client.gui.NavigationView;
import de.bos_bremen.ecard.client.gui.ProcessChooseView;
import de.bos_bremen.ecard.client.gui.ProcessPanel;
import de.bos_bremen.ecard.client.model.CardReader;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkInstanceHandler;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.Result;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderListener;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProviderUtils;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientView
extends JPanel
implements FrameworkInstanceHandler {
    private static final long serialVersionUID = 4117528492952071688L;
    private static final Logger LOG = LogManager.getLogger(ClientView.class);
    private final transient ProcessChooseView processChooseView;
    private final XMLProperties properties;
    private final transient NavigationView navigationView;
    private final transient DynamicView dynamicView = new DynamicView();
    private JPanel centerPanel;

    public ClientView() {
        this.navigationView = new NavigationView();
        this.processChooseView = new ProcessChooseView(this.navigationView, this.dynamicView);
        Document.getInstance().getProcessFactory().setProcessChooseView(this.processChooseView);
        LOG.info("FrameworkState : {} -> starting", (Object)Document.getInstance().getCurrentFrameworkState());
        Document.getInstance().setCurrentFrameworkState(FrameworkStatus.FrameworkState.starting);
        this.properties = Config.getInstance().getProcessProperties();
        this.initGUI();
        LOG.info("FrameworkState : {} -> online", (Object)Document.getInstance().getCurrentFrameworkState());
        Document.getInstance().setCurrentFrameworkState(FrameworkStatus.FrameworkState.online);
        KeyProviderUtils.getInstance();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.add((Component)this.dynamicView.getView(), "Center");
        this.add((Component)this.navigationView.getView(), "West");
        this.add((Component)this.centerPanel, "Center");
        List<ProcessI> processes = Document.getInstance().getProcessFactory().getProcesses(this.properties);
        for (ProcessI process : processes) {
            ProcessPanel processPanel = new ProcessPanel(process);
            this.navigationView.setView(processPanel.getNavigationView(), process.getProcessName());
            this.dynamicView.setView(processPanel.getDetailView(), process.getProcessName());
            this.processChooseView.addProcess(process);
        }
        this.setNavigationVisible(Config.getInstance().isNavigationInvisible());
    }

    public ProcessChooseView getProcessChooseView() {
        return this.processChooseView;
    }

    public boolean saveDefaultProperties() {
        Config.getInstance().setProcessProperties(Document.getInstance().getProcessFactory().getProperties());
        Config.getInstance().storeDefault();
        return true;
    }

    @Override
    public String getVersion() {
        return Config.getComponentVersion();
    }

    protected List<File> getInputfiles(String[] inputFile, List<File> inOutFileList, boolean openDirectory) {
        for (int i = 0; inputFile != null && i < inputFile.length; ++i) {
            File file = new File(inputFile[i]);
            if (file.isDirectory()) {
                if (openDirectory) {
                    LOG.error("Das Verzeichnis {} wird ausgelesen und allen Inhaltsdateien der Liste hinzugefuegt", (Object)file.getAbsolutePath());
                    File[] dirFiles = file.listFiles();
                    if (dirFiles != null) {
                        String[] dirFileNames = new String[dirFiles.length];
                        if (dirFileNames.length == 0) {
                            inOutFileList.add(file);
                        } else {
                            for (int j = 0; j < dirFiles.length; ++j) {
                                dirFileNames[j] = dirFiles[j].getAbsolutePath();
                            }
                            this.getInputfiles(dirFileNames, inOutFileList, false);
                        }
                    } else {
                        LOG.error("Das Verzeichnis {} hat keine Leseberechtigung", (Object)file.getAbsolutePath());
                    }
                } else {
                    LOG.error("Das Verzeichnis {} wird nicht eingebunden, da keine Rekursion unterstuetzt wird.", (Object)file.getAbsolutePath());
                }
            } else {
                inOutFileList.add(file);
            }
            if (file.exists()) continue;
            LOG.error("Die Datei {} existiert nicht und kann daher nicht mit in die Liste uebernommen werden", (Object)file.getAbsolutePath());
        }
        return inOutFileList;
    }

    @Override
    public boolean checkCard(String cardnumber) {
        KeyProviderListener listener = KeyProviderUtils.getInstance().getKeyProviderListener(KeyUsage.SIGN);
        return listener.checkCard(cardnumber);
    }

    @Override
    public List<CardReader> getAvailableCardReader() {
        KeyProviderListener listener = KeyProviderUtils.getInstance().getKeyProviderListener(KeyUsage.SIGN);
        return listener.getAvailableCardList();
    }

    @Override
    public FrameworkStatus getStatus() {
        FrameworkStatus signerStatus = new FrameworkStatus(Document.getInstance().getCurrentFrameworkState());
        List<WorkingResult> workingResults = Document.getInstance().getWorkingResults();
        ArrayList<Result> results = new ArrayList<Result>();
        if (workingResults != null) {
            ArrayList<String> lastResultFilenames = null;
            for (WorkingResult workingResult : workingResults) {
                ArrayList<String> resultFileName = new ArrayList<String>();
                if (workingResult.getResult() != null) {
                    for (File file : workingResult.getResult()) {
                        resultFileName.add(file.getAbsolutePath());
                    }
                }
                String sourceFilename = "";
                sourceFilename = workingResult.getSourceFile() != null ? workingResult.getSourceFile().getAbsolutePath() : (lastResultFilenames != null && !lastResultFilenames.isEmpty() ? (String)lastResultFilenames.get(0) : "");
                Result result = new Result(sourceFilename, resultFileName);
                lastResultFilenames = new ArrayList<String>(resultFileName);
                if (workingResult.getErrorObject() != null && workingResult.getErrorObject().getErrorMessage() != null) {
                    if (workingResult.getErrorObject().getErrorCode() != null) {
                        int rc = workingResult.getErrorObject().getErrorCode().getReturnCode();
                        result.setReturnCode(rc);
                        result.setDetailMessage(workingResult.getErrorObject().getErrorMessage().isEmpty() ? ErrorCode.getErrorCodeByID(rc).getDescription() : workingResult.getErrorObject().getErrorMessage());
                    } else {
                        result.setReturnCode(ErrorCode.UNKNOWN.getReturnCode());
                        result.setDetailMessage(ErrorCode.UNKNOWN.getDescription());
                    }
                } else {
                    switch (workingResult.getCurrentState()) {
                        case FINISHED: {
                            result.setReturnCode(ErrorCode.OK.getReturnCode());
                            result.setDetailMessage(ErrorCode.OK.getDescription());
                            break;
                        }
                        case ABORTED: {
                            result.setReturnCode(ErrorCode.ABORTED.getReturnCode());
                            result.setDetailMessage(ErrorCode.ABORTED.getDescription());
                            break;
                        }
                        case ERROR: {
                            result.setReturnCode(ErrorCode.UNKNOWN.getReturnCode());
                            result.setDetailMessage(ErrorCode.UNKNOWN.getDescription());
                            break;
                        }
                        default: {
                            result.setReturnCode(-1);
                            result.setDetailMessage("None");
                        }
                    }
                }
                results.add(result);
            }
        }
        signerStatus.setResults(results.toArray(new Result[results.size()]));
        return signerStatus;
    }

    public void setNavigationVisible(boolean invisible) {
        if (invisible && this.navigationView != null && this.navigationView.getView() != null && this.centerPanel != null) {
            this.navigationView.getView().setVisible(false);
            this.centerPanel.setBorder(null);
        }
    }

    @Override
    public boolean reinitCards() {
        return Document.getInstance().getActionFactory().createResetCardAction().reset();
    }

    @Override
    public void requestFocus() {
        this.processChooseView.requestFocus();
    }
}

