/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.gui;

import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.process.ProcessListener;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.ProcessPanel;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.CurvedToggleButton;
import de.bos_bremen.ecard.client.gui.view.component.label.StepNavigationLabel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;

public class ButtonPanel
extends JPanel
implements StepChangedListener,
ProcessListener {
    private static final long serialVersionUID = 1L;
    private StepNavigationLabel stepNumber;
    private JToggleButton button;
    private final transient Step step;
    private final int index;
    private final boolean firstElement;
    private final boolean lastElement;
    private final ProcessPanel.StepButtonGroup bg;
    boolean isActive = false;
    CurvedBorder activeCurvedBorder = CurvedBorder.ACTIVE_BORDER;

    public ButtonPanel(ProcessPanel parent, Step step, int index, boolean firstElement, boolean lastElement, ProcessPanel.StepButtonGroup bg) {
        this.step = step;
        this.addStateChangeListener();
        this.addProcessListener();
        this.index = index;
        this.firstElement = firstElement;
        this.lastElement = lastElement;
        this.bg = bg;
        this.initGui();
        this.layoutGui();
    }

    private void initGui() {
        this.stepNumber = this.step instanceof WorkingStep ? new StepNavigationLabel(this.index, this.firstElement, this.lastElement, this.step.getParent().getState().equals((Object)FrameworkStatus.FrameworkState.finished) ? StepNavigationLabel.StepState.complete : StepNavigationLabel.StepState.uncomplete) : new StepNavigationLabel(this.index, this.firstElement, this.lastElement, this.step.isStateComplete() ? StepNavigationLabel.StepState.complete : StepNavigationLabel.StepState.uncomplete);
        this.button = new CurvedToggleButton(this.step.getStepName().getButtonText());
        this.button.setActionCommand(this.step.getStepName().getName());
        this.button.setName("button_" + this.step.getStepName().getName());
        this.button.setFocusTraversalKeysEnabled(false);
        this.button.addKeyListener(this.createKeyAdapter());
        this.button.addActionListener(actionEvent -> this.step.getParent().setCurrentStep(actionEvent.getActionCommand()));
        this.button.setSelected(false);
        int fontsize = Document.getInstance().getFontSize().getHeaderSize();
        this.button.setPreferredSize(new Dimension(this.button.getPreferredSize().width + fontsize, (int)((double)fontsize * 3.4)));
        this.bg.add(this.button);
    }

    private void layoutGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 8, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 3;
        this.add((Component)this.stepNumber, gbc);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 5);
        this.add((Component)this.button, gbc);
        this.button.setContentAreaFilled(false);
        this.setFocusable(false);
    }

    private KeyListener createKeyAdapter() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 10: 
                    case 32: {
                        ButtonPanel.this.step.getParent().setCurrentStep(ButtonPanel.this.button.getActionCommand());
                        keyEvent.consume();
                        break;
                    }
                    case 9: {
                        if (keyEvent.isShiftDown()) {
                            ButtonPanel.this.button.getParent().getParent().transferFocusBackward();
                        } else {
                            ButtonPanel.this.button.transferFocus();
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        ButtonPanel.this.bg.createListFromGroup();
                        JToggleButton next = ButtonPanel.this.bg.getNextFrom(ButtonPanel.this.button);
                        if (next == null || !next.isEnabled()) {
                            ButtonPanel.this.bg.getFirst().requestFocus();
                        } else {
                            next.requestFocus();
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 38: {
                        ButtonPanel.this.bg.createListFromGroup();
                        JToggleButton previous = ButtonPanel.this.bg.getPreviousFrom(ButtonPanel.this.button);
                        if (previous == null) {
                            if (ButtonPanel.this.bg.getLast().isEnabled()) {
                                ButtonPanel.this.bg.getLast().requestFocus();
                            } else {
                                ButtonPanel.this.bg.getPreviousFrom(ButtonPanel.this.bg.getLast()).requestFocus();
                            }
                        } else {
                            previous.requestFocus();
                        }
                        keyEvent.consume();
                        break;
                    }
                }
            }
        };
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        this.stateChanged(null);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.step instanceof WorkingStep) {
            this.stepNumber.setStepState(this.step.getParent().getState().equals((Object)FrameworkStatus.FrameworkState.finished) ? StepNavigationLabel.StepState.complete : StepNavigationLabel.StepState.uncomplete);
        } else {
            this.stepNumber.setStepState(this.step.isStateComplete() ? StepNavigationLabel.StepState.complete : StepNavigationLabel.StepState.uncomplete);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isActive) {
            this.activeCurvedBorder.paintBorder(this, g, 0, 3, this.getSize().width - 5, this.getSize().height - 6);
        }
        this.stepNumber.repaint();
    }

    public void setSelected(boolean selected) {
        this.button.setSelected(selected);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String text) {
        String tooltipHtml = MultiLineTooltips.wrapToolTip(Utils.htmlToAscii(text));
        super.setToolTipText(tooltipHtml);
        this.button.setToolTipText(tooltipHtml);
    }

    @Override
    public void processChange() {
        this.stateChanged(null);
    }

    private void addProcessListener() {
        this.step.getParent().addProcessListener(this);
    }

    private void addStateChangeListener() {
        this.step.addStateChangeListener(this);
    }

    public void removeProcessListener() {
        this.step.getParent().removeProcessListener(this);
    }

    public void removeStateChangeListener() {
        this.step.removeStateChangeListener(this);
    }
}

