/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.control.step.working;

import de.bos_bremen.ecard.client.CommonsUrlConnector;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.ProgressEvent;
import de.bos_bremen.ecard.client.control.step.ProgressListener;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.control.step.working.ResultInput;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.dialog.RenameFileDialog;
import de.bos_bremen.ecard.client.model.DetachableFile;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.error.CancelFileExistException;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.FileExistException;
import de.bos_bremen.ecard.client.model.error.FileInUseException;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.FormularChangedEvent;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectFilesFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectSignedFilesFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectTargetFolderFormular;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.governikus.csl.ECardProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WorkingStep
extends Step {
    private static final Logger LOG = LogManager.getLogger(WorkingStep.class);
    protected WorkingState state = WorkingState.NONE;
    protected StepFormular form;
    protected List<ProgressListener> progressListener = new ArrayList<ProgressListener>();
    protected Repeat lastRepeat = null;
    protected Repeat fullRepeat = null;

    protected WorkingStep(StepFactory.StepName stepName) {
        super(stepName);
    }

    public void addProgressListener(ProgressListener listener) {
        if (this.progressListener.contains(listener)) {
            return;
        }
        this.progressListener.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        if (this.progressListener == null) {
            return;
        }
        this.progressListener.remove(listener);
    }

    public void notifyProgressListener(Object oldValue, Object newValue) {
        if (this.progressListener == null) {
            return;
        }
        for (ProgressListener listener : this.progressListener) {
            listener.handleProgressEvent(new ProgressEvent(newValue));
        }
    }

    public abstract void run(SubsequentProcess var1);

    public void run() {
        LOG.info("FrameworkState : {} -> processing", (Object)Document.getInstance().getCurrentFrameworkState());
        Document.getInstance().setCurrentFrameworkState(FrameworkStatus.FrameworkState.processing);
        this.run(null);
    }

    protected void displayFinishDialog(boolean cancelled, int errorCounter) {
        LOG.trace("Abgebrochen? {}", (Object)cancelled);
        if (errorCounter > 0) {
            if (Document.getInstance().getWorkingResults().size() > 1) {
                Document.getInstance().displayErrorMessages(Document.getInstance().getFrame(), "process_with_error." + this.getStepName().getName(), MessageFormat.format(Messages.getString("dialog.process_with_error." + this.getStepName().getName() + ".message"), errorCounter), null);
            } else {
                LOG.info("Es ist ein Fehler bei einer Datei aufgetreten. Daher gibt es keinen extra Hinweisdialog");
            }
        } else if (!cancelled) {
            Document.getInstance().displayRedundantMessages(Document.getInstance().getFrame(), "process_without_error." + this.getStepName().getName(), 1);
        } else {
            LOG.info("Der Benutzer hat den Prozess abgebrochen");
        }
    }

    public void callSubsequentProcess(SubsequentProcess process) {
        if (this.workingListContainError()) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (WorkingResult workingResult : Document.getInstance().getWorkingResults()) {
            if (!workingResult.getCurrentState().equals((Object)WorkingResult.Status.FINISHED) && !workingResult.getCurrentState().equals((Object)WorkingResult.Status.UNZIPPED)) continue;
            List<File> resultFiles = workingResult.getResult();
            files.addAll(resultFiles);
        }
        process.callSubsequentProcess(files);
    }

    protected boolean canSaveFile(File file) {
        return !file.exists();
    }

    public boolean workingListContainError() {
        boolean containError = false;
        for (WorkingResult result : Document.getInstance().getWorkingResults()) {
            if (result.getCurrentState().equals((Object)WorkingResult.Status.FINISHED) || result.getCurrentState().equals((Object)WorkingResult.Status.ZIPPED) || result.getCurrentState().equals((Object)WorkingResult.Status.UNZIPPED)) continue;
            containError = true;
            break;
        }
        return containError;
    }

    public List<WorkingResult> getWorkingResults() {
        return new ArrayList<WorkingResult>(Document.getInstance().getWorkingResults());
    }

    @Override
    public StepFormular getForm() {
        return this.form;
    }

    @Override
    public boolean setProcessFormular(StepFormular stepFormular) {
        super.setProcessFormular(stepFormular);
        this.form = stepFormular;
        this.setSubsequentProcess(this.getDefaultSubsequentProcess());
        this.buildWorkingResult();
        return true;
    }

    @Override
    public void formularChanged(FormularChangedEvent event) {
        this.buildWorkingResult();
        if (event.changedFormular(StepFactory.StepName.selectfiles) || event.changedFormular(StepFactory.StepName.workingStep)) {
            this.notifyAllStateChangeListener(null, event);
        }
        this.parent.isFinished(false);
        super.formularChanged(event);
    }

    protected void buildWorkingResult() {
        DetachableFile detachableFile;
        List<ProcessSignedFile> allSelectedFiles;
        StepFormular selectFilesFormular;
        LOG.trace("");
        this.state = WorkingState.NONE;
        Document documentInstance = Document.getInstance();
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectFilesFormular) {
            selectFilesFormular = (SelectFilesFormular)stepFormular;
            allSelectedFiles = selectFilesFormular.getSelectedFiles();
            documentInstance.setWorkingResults(new ArrayList<WorkingResult>());
            if (allSelectedFiles != null) {
                for (ProcessFileSeen processFileSeen : allSelectedFiles) {
                    LOG.info("file {}", (Object)processFileSeen.getFile().getAbsolutePath());
                    detachableFile = new DetachableFile(processFileSeen.getFile());
                    documentInstance.getWorkingResults().add(new WorkingResult(detachableFile, WorkingResult.Status.NONE, processFileSeen));
                }
            }
            this.notifyProgressListener(null, documentInstance.getWorkingResults());
        }
        if ((allSelectedFiles = this.form) instanceof SelectSignedFilesFormular) {
            selectFilesFormular = (SelectSignedFilesFormular)((Object)allSelectedFiles);
            allSelectedFiles = selectFilesFormular.getSelectedFiles();
            documentInstance.setWorkingResults(new ArrayList<WorkingResult>());
            if (allSelectedFiles != null) {
                for (ProcessSignedFile processSignedFile : allSelectedFiles) {
                    LOG.info("add file {}", (Object)processSignedFile.getFile().getAbsolutePath());
                    LOG.trace("   file {}", (Object)processSignedFile.getFile().getName());
                    detachableFile = new DetachableFile(processSignedFile.getFile());
                    detachableFile.setDetachedFile(processSignedFile.getDetachedFile());
                    documentInstance.getWorkingResults().add(new WorkingResult(detachableFile, WorkingResult.Status.NONE, processSignedFile));
                }
            }
            this.notifyProgressListener(null, documentInstance.getWorkingResults());
        }
    }

    @Override
    public boolean isStateComplete() {
        return !WorkingState.FINISHED.equals((Object)this.state) && this.parent.canProcess();
    }

    protected Repeat canMoveDocumentsToTargetFolder(TargetFolderType targetFolderType, String targetFolder, String localCopyFolder, File sourceFile, String resultFileName, boolean createDetached, boolean multipleCmsSignatures) {
        LOG.debug(">>> {} / {} >>>", (Object)this.parent, (Object)this.stepName);
        LOG.debug("ResultFileName: {}", (Object)resultFileName);
        if (resultFileName == null || resultFileName.isEmpty()) {
            throw new IllegalArgumentException("resultFileName wird erwartet");
        }
        return this.canMoveDocumentsToTargetFolder(targetFolderType, targetFolder, localCopyFolder, sourceFile, resultFileName, createDetached, false, multipleCmsSignatures);
    }

    protected Repeat canMoveDocumentsToTargetFolder(TargetFolderType targetFolderType, String targetFolder, String userLocalCopyFolder, File sourceFile, String resultFileName, boolean createDetached, boolean isVerification, boolean multipleCmsSignatures) {
        LOG.debug(">>> {} / {} >>>", (Object)this.parent, (Object)this.stepName);
        LOG.debug("ResultFileName: {}", (Object)resultFileName);
        if (resultFileName == null || resultFileName.isEmpty()) {
            throw new IllegalArgumentException("resultFileName wird erwartet");
        }
        String storeFolder = sourceFile.getParent();
        if (targetFolderType.equals((Object)TargetFolderType.oneSpecial)) {
            storeFolder = targetFolder;
        }
        LOG.debug("StoreFolder: {}", (Object)storeFolder);
        File storeFile = new File(storeFolder, resultFileName);
        LOG.debug("File to store: '{}'", (Object)storeFile.getName());
        String storeFileName = storeFile.getName();
        String filePrefix = storeFile.getName().substring(0, storeFile.getName().lastIndexOf("."));
        LOG.debug("File-Prefix: '{}'", (Object)filePrefix);
        String fileSuffix = "";
        fileSuffix = storeFileName.substring(storeFileName.lastIndexOf("."));
        LOG.debug("File-Suffix: '{}'", (Object)fileSuffix);
        boolean canSaveStoreFile = this.canSaveFile(storeFile);
        LOG.debug("can save result file: {} >>> {}", (Object)storeFile.getName(), (Object)canSaveStoreFile);
        boolean canSaveSourceFile = !createDetached ? true : (TargetFolderType.oneSpecial.equals((Object)targetFolderType) && !Utils.isSamePath(targetFolder, sourceFile.getParentFile()) ? this.canSaveFile(new File(targetFolder, sourceFile.getName())) : true);
        LOG.debug("can save source file: {} >>> {}", (Object)sourceFile.getName(), (Object)canSaveSourceFile);
        boolean canSaveLocalCopyStoreFile = true;
        boolean canSaveLocalCopySourceFile = true;
        File localCopyStoreFile = null;
        File localCopySourceFile = null;
        if (userLocalCopyFolder != null && !userLocalCopyFolder.isEmpty()) {
            localCopySourceFile = new File(userLocalCopyFolder + "/", sourceFile.getName());
            localCopyStoreFile = new File(userLocalCopyFolder + "/", filePrefix + fileSuffix);
            canSaveLocalCopyStoreFile = this.canSaveFile(localCopyStoreFile);
            canSaveLocalCopySourceFile = !createDetached ? true : (!Utils.isSamePath(userLocalCopyFolder, sourceFile.getParentFile()) ? this.canSaveFile(new File(userLocalCopyFolder, sourceFile.getName())) : true);
        }
        if (!(canSaveStoreFile && canSaveSourceFile && canSaveLocalCopyStoreFile && canSaveLocalCopySourceFile)) {
            if (!Repeat.SKIP_ALL.equals((Object)this.fullRepeat) && !Repeat.OVERWRITE_ALL.equals((Object)this.fullRepeat)) {
                RenameFileDialog dialog = userLocalCopyFolder != null && !userLocalCopyFolder.isEmpty() && !canSaveLocalCopyStoreFile ? new RenameFileDialog(localCopyStoreFile) : (userLocalCopyFolder != null && !userLocalCopyFolder.isEmpty() && !canSaveLocalCopySourceFile ? new RenameFileDialog(localCopySourceFile) : (!canSaveSourceFile ? new RenameFileDialog(sourceFile) : new RenameFileDialog(storeFile)));
                if (canSaveSourceFile && (!canSaveStoreFile || !canSaveLocalCopyStoreFile) && multipleCmsSignatures && targetFolderType.equals((Object)TargetFolderType.sameAsSourceFolder)) {
                    this.lastRepeat = Repeat.OVERWRITE;
                } else {
                    this.lastRepeat = dialog.showDialog();
                    if (Repeat.SKIP_ALL.equals((Object)this.lastRepeat)) {
                        this.fullRepeat = Repeat.SKIP_ALL;
                        this.lastRepeat = Repeat.SKIP;
                    } else if (Repeat.OVERWRITE_ALL.equals((Object)this.lastRepeat)) {
                        this.fullRepeat = Repeat.OVERWRITE_ALL;
                        this.lastRepeat = Repeat.OVERWRITE;
                    }
                }
            } else {
                this.lastRepeat = Repeat.SKIP_ALL.equals((Object)this.fullRepeat) ? Repeat.SKIP : Repeat.OVERWRITE;
            }
            return this.lastRepeat;
        }
        LOG.debug("<<<");
        return null;
    }

    protected File moveResultDocumentToTargetFolder(SelectTargetFolderFormular formular, File sourceFile, File resultFile, boolean createPDFInline, boolean createXMLInline, boolean createDetached) throws FileExistException, IOException, FileInUseException {
        return this.moveResultDocumentToTargetFolder(formular, sourceFile, resultFile, createPDFInline, createXMLInline, createDetached, true, true);
    }

    protected File moveResultDocumentToTargetFolder(SelectTargetFolderFormular formular, File sourceFile, File resultFile, String resultFileName, boolean createPDFInline, boolean createXMLInline, boolean createDetached) throws FileExistException, IOException, FileInUseException {
        return this.moveResultDocumentToTargetFolder(formular, sourceFile, resultFile, resultFileName, createPDFInline, createXMLInline, createDetached, true, true);
    }

    protected File moveResultDocumentToTargetFolder(SelectTargetFolderFormular formular, File sourceFile, File resultFile, boolean createPDFInline, boolean createXMLInline, boolean createDetached, boolean post, boolean filesuffix) throws FileExistException, IOException, FileInUseException {
        return this.moveResultDocumentToTargetFolder(formular, sourceFile, resultFile, null, createPDFInline, createXMLInline, createDetached, post, filesuffix);
    }

    protected File moveResultDocumentToTargetFolder(SelectTargetFolderFormular formular, File sourceFile, File resultFile, String resultFileName, boolean createPDFInline, boolean createXMLInline, boolean createDetached, boolean post, boolean filesuffix) throws FileExistException, IOException, FileInUseException {
        LOG.trace("");
        LOG.trace("source file : {}", (Object)sourceFile);
        LOG.trace("result file : {}", (Object)resultFile);
        Document.getInstance().notifyProgressListeners(ECardProgressListener.ProgressType.WRITING_DOCUMENT_WITH_SIGNATURE, -1);
        try {
            boolean moved;
            LOG.trace("");
            String storeFolder = sourceFile.getParent();
            if (formular.getTargetFolderType().equals((Object)TargetFolderType.oneSpecial)) {
                storeFolder = formular.getTargetFolder();
                LOG.trace("storeFolder : {}", (Object)storeFolder);
            }
            String filePrefix = sourceFile.getName();
            String fileSuffix = "";
            if (filesuffix) {
                try {
                    if (resultFileName != null && resultFileName.contains(".")) {
                        fileSuffix = resultFileName.substring(resultFileName.lastIndexOf("."));
                    } else if (resultFile.getName().contains(".")) {
                        fileSuffix = resultFile.getName().substring(resultFile.getName().lastIndexOf("."));
                    }
                    if (sourceFile.getName().toLowerCase().contains(".p7m") || sourceFile.getName().toLowerCase().contains(".enz")) {
                        filePrefix = sourceFile.getName().substring(0, sourceFile.getName().substring(0, sourceFile.getName().length() - 4).lastIndexOf("."));
                    } else if (resultFile.getName().toLowerCase().endsWith(".pdf")) {
                        filePrefix = sourceFile.getName().substring(0, sourceFile.getName().lastIndexOf("."));
                        fileSuffix = "_signed.pdf";
                    } else if (resultFile.getName().toLowerCase().endsWith(".xml")) {
                        filePrefix = sourceFile.getName().substring(0, sourceFile.getName().lastIndexOf("."));
                        fileSuffix = "_signed.xml";
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            File localCopyStoreFile = null;
            if (formular.getLocalCopyFolder() != null && !formular.getLocalCopyFolder().isEmpty()) {
                localCopyStoreFile = new File(formular.getLocalCopyFolder() + "/", filePrefix + fileSuffix);
            }
            if (TargetFolderType.oneSpecial.equals((Object)formular.getTargetFolderType()) && formular.getTargetFolder().contains("://") && !formular.getTargetFolder().contains("file:")) {
                boolean sendPostOk;
                Object urlConn;
                LOG.trace("Ziel: http:// ...");
                File storeFile = new File(resultFile.getParentFile(), filePrefix + fileSuffix);
                storeFile.deleteOnExit();
                Utils.moveFile(resultFile, storeFile);
                LOG.trace("moveFile : ok : {}", (Object)resultFile);
                if (post) {
                    LOG.trace("try post ...");
                    urlConn = new CommonsUrlConnector(Document.getInstance().getFrame());
                    try {
                        LOG.trace("sendPost ... {}", (Object)storeFile);
                        String postResponseStr = urlConn.sendPost(new URL(formular.getTargetFolder()), "fileName", storeFile);
                        LOG.trace("sendPost : ok");
                        if (postResponseStr.contains("<error>")) {
                            LOG.trace("");
                            if (postResponseStr.contains("<fileexist")) {
                                LOG.info("");
                                Document.getInstance().reportError(ErrorCode.CANNOT_SAVE_OUTPUT, false, Messages.getString("step." + this.stepName + ".error.fileexist.text"), formular.getTargetFolder(), "");
                            } else {
                                LOG.trace("");
                                Document.getInstance().reportError(ErrorCode.CANNOT_SAVE_OUTPUT, false, storeFile.getName(), formular.getTargetFolder(), "");
                            }
                            LOG.trace("");
                            throw new IOException(new SignerException(ErrorCode.CANNOT_SAVE_OUTPUT, null));
                        }
                        sendPostOk = true;
                        LOG.trace("sendPostOk : ok");
                    }
                    catch (IllegalArgumentException | MalformedURLException ex) {
                        LOG.trace("");
                        Document.getInstance().reportError(ErrorCode.CONNECTION_ERROR, false, formular.getTargetFolder(), "");
                        LOG.error((Object)ex, (Throwable)ex);
                        throw new IOException(ex);
                    }
                    catch (SignerException e) {
                        LOG.trace("");
                        Document.getInstance().reportError(e.getErrorCode(), false, formular.getTargetFolder());
                        LOG.error((Object)e, (Throwable)e);
                        throw new IOException(e);
                    }
                } else {
                    sendPostOk = true;
                    LOG.trace("sendPostOk : ok");
                }
                if (sendPostOk && localCopyStoreFile != null) {
                    if (this.lastRepeat != null) {
                        switch (this.lastRepeat) {
                            case OVERWRITE: {
                                break;
                            }
                            case OVERWRITE_ALL: {
                                this.fullRepeat = Repeat.OVERWRITE_ALL;
                                this.lastRepeat = Repeat.OVERWRITE;
                                break;
                            }
                            case SKIP: 
                            case SKIP_ALL: {
                                resultFile.deleteOnExit();
                                throw new CancelFileExistException("File exist in target folder.");
                            }
                        }
                    }
                    Utils.copyFile(storeFile, localCopyStoreFile);
                }
                urlConn = storeFile;
                return urlConn;
            }
            File storeFile = new File(storeFolder, filePrefix + fileSuffix);
            LOG.debug("store file : {}", (Object)storeFile);
            this.testWriteToFolder(storeFile);
            if (localCopyStoreFile != null) {
                this.testWriteToFolder(localCopyStoreFile);
            }
            if (moved = Utils.moveFile(resultFile, storeFile)) {
                if (localCopyStoreFile != null && !localCopyStoreFile.getParentFile().getAbsolutePath().equals(storeFile.getParentFile().getAbsolutePath())) {
                    Utils.copyFile(storeFile, localCopyStoreFile);
                }
                File urlConn = storeFile;
                return urlConn;
            }
            String path = storeFile.getAbsolutePath().replaceAll("[\n|\r|\t]", " ");
            LOG.info("{} is in use by other program.", (Object)path);
            Document.getInstance().reportError(ErrorCode.FILE_IN_USE, true, path);
            throw new FileInUseException("File is in use by other program.");
        }
        finally {
            Document.getInstance().notifyProgressListeners(ECardProgressListener.ProgressType.WRITING_DOCUMENT_WITH_SIGNATURE, 1);
        }
    }

    protected void testWriteToFolder(File storeFile) throws FileExistException {
        if (storeFile == null) {
            return;
        }
        if (!Utils.isFolderWriteable(storeFile.getParentFile())) {
            LOG.trace("");
            Document.getInstance().reportError(ErrorCode.CANNOT_WRITE_TO_FOLDER, true, storeFile.getParent());
            for (WorkingResult workingResult : Document.getInstance().getWorkingResults()) {
                workingResult.setErrorObject(Document.getInstance().getLastReportedErrorObject());
            }
            throw new FileExistException("File exist in target folder.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File copyOriginalDocument(SelectTargetFolderFormular formular, File sourceFile) throws IOException, FileExistException {
        LOG.trace("");
        Document.getInstance().notifyProgressListeners(ECardProgressListener.ProgressType.WRITING_DOCUMENT_WITH_SIGNATURE, -1);
        try {
            File copiedFile;
            File copiedLocalCopyFile;
            block27: {
                LOG.trace("");
                if (formular.getTargetFolder() != null && formular.getTargetFolder().contains("://") && !formular.getTargetFolder().contains("file:")) {
                    File copiedLocalCopyFile2;
                    LOG.trace("Ziel : {}", (Object)formular.getTargetFolder());
                    boolean sendPostOk = false;
                    if (sourceFile.canRead() && sourceFile.exists()) {
                        LOG.trace("");
                        CommonsUrlConnector urlConn = new CommonsUrlConnector(Document.getInstance().getFrame());
                        LOG.trace("");
                        try {
                            LOG.trace("sendPost ...");
                            String postResponseStr = urlConn.sendPost(new URL(formular.getTargetFolder()), "fileName", sourceFile);
                            LOG.trace("sendPost ok");
                            if (postResponseStr.contains("<error>")) {
                                LOG.trace("");
                                if (postResponseStr.contains("<fileexist")) {
                                    LOG.trace("");
                                    Document.getInstance().reportError(ErrorCode.CANNOT_SAVE_OUTPUT, false, Messages.getString("step.sign.error.fileexist.text"), formular.getTargetFolder(), "");
                                } else {
                                    LOG.trace("");
                                    Document.getInstance().reportError(ErrorCode.CANNOT_SAVE_OUTPUT, false, formular.getTargetFolder(), "");
                                }
                                throw new IOException(new SignerException(ErrorCode.CANNOT_SAVE_OUTPUT, null));
                            }
                            sendPostOk = true;
                        }
                        catch (SignerException | MalformedURLException e) {
                            LOG.trace("");
                            throw new IOException(e);
                        }
                    }
                    if (sendPostOk && formular.getLocalCopyFolder() != null && !formular.getLocalCopyFolder().isEmpty()) {
                        LOG.trace("");
                        copiedLocalCopyFile2 = new File(formular.getLocalCopyFolder(), sourceFile.getName());
                        if (copiedLocalCopyFile2.exists() && !Repeat.OVERWRITE.equals((Object)this.lastRepeat)) {
                            LOG.trace("");
                            throw new FileExistException(copiedLocalCopyFile2.getName());
                        }
                        Utils.copyFile(sourceFile, copiedLocalCopyFile2);
                    }
                    copiedLocalCopyFile2 = sourceFile;
                    return copiedLocalCopyFile2;
                }
                LOG.trace("");
                copiedLocalCopyFile = null;
                FileOutputStream ostr = null;
                FileInputStream istr = null;
                try {
                    String storeFolder = sourceFile.getParent();
                    if (formular.getTargetFolderType().equals((Object)TargetFolderType.oneSpecial)) {
                        storeFolder = formular.getTargetFolder();
                    }
                    copiedFile = new File(storeFolder, sourceFile.getName());
                    if (formular.getLocalCopyFolder() != null && !formular.getLocalCopyFolder().isEmpty()) {
                        copiedLocalCopyFile = new File(formular.getLocalCopyFolder(), sourceFile.getName());
                    }
                    if (Utils.isSamePath(copiedFile.getParentFile(), sourceFile.getParentFile())) {
                        if (copiedLocalCopyFile != null && !Utils.isSamePath(copiedLocalCopyFile.getParentFile(), copiedFile.getParentFile())) {
                            Utils.copyFile(copiedFile, copiedLocalCopyFile);
                        }
                        File file = sourceFile;
                        return file;
                    }
                    if (copiedFile.exists() && !Repeat.OVERWRITE.equals((Object)this.lastRepeat)) {
                        throw new FileExistException(copiedFile.getName());
                    }
                    ostr = new FileOutputStream(copiedFile);
                    istr = new FileInputStream(sourceFile);
                    byte[] buf = new byte[0x1000000];
                    int read = ((InputStream)istr).read(buf);
                    while (read != -1) {
                        ((OutputStream)ostr).write(buf, 0, read);
                        read = ((InputStream)istr).read(buf);
                    }
                    Utils.closeStream(ostr);
                }
                catch (IOException e) {
                    LOG.error((Object)e, (Throwable)e);
                    copiedFile = null;
                    break block27;
                }
                finally {
                    Utils.closeStream(ostr);
                    Utils.closeStream(istr);
                }
                Utils.closeStream(istr);
            }
            if (copiedFile != null && copiedLocalCopyFile != null && !Utils.isSamePath(copiedLocalCopyFile.getParentFile(), copiedFile.getParentFile())) {
                Utils.copyFile(copiedFile, copiedLocalCopyFile);
            }
            File file = copiedFile;
            return file;
        }
        finally {
            Document.getInstance().notifyProgressListeners(ECardProgressListener.ProgressType.WRITING_DOCUMENT_WITH_SIGNATURE, 1);
        }
    }

    public abstract SubsequentProcess getDefaultSubsequentProcess();

    public SubsequentProcess getSubsequentProcess() {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof ProcessFormular) {
            ProcessFormular processFormular = (ProcessFormular)((Object)stepFormular);
            return processFormular.getSubsequentProcess();
        }
        return null;
    }

    public void setSubsequentProcess(SubsequentProcess subsequentProcess) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof ProcessFormular) {
            ProcessFormular processFormular = (ProcessFormular)((Object)stepFormular);
            processFormular.setSubsequentProcess(subsequentProcess);
        }
    }

    protected boolean checkSourceFileBeforeProcess(WorkingResult workingResult, TargetFolderType targetFolderType) {
        Document documentInstance = Document.getInstance();
        DetachableFile file = workingResult.getSourceFile();
        if (!file.exists()) {
            LOG.error("FILE_NOT_FOUND");
            documentInstance.reportError(ErrorCode.FILE_NOT_FOUND, true, workingResult.getSourceFile());
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            return false;
        }
        if (file.isFile() && file.length() == 0L) {
            LOG.error("FILE_IS_EMPTY");
            String errorObjectString = MultiLineTooltips.wrappString(workingResult.getSourceFile().getAbsolutePath(), 80);
            documentInstance.reportError(ErrorCode.FILE_IS_EMPTY, true, errorObjectString);
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            return false;
        }
        if (file.isDirectory()) {
            LOG.error("SOURCE_DIR_EMPTY");
            documentInstance.reportError(ErrorCode.SOURCE_DIR_EMPTY, true, workingResult.getSourceFile());
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            return false;
        }
        if (targetFolderType.equals((Object)TargetFolderType.sameAsSourceFolder) && !Utils.canWrite(workingResult.getSourceFile().getParentFile().getAbsolutePath())) {
            LOG.error("CANNOT_WRITE_TO_FOLDER");
            documentInstance.reportError(ErrorCode.CANNOT_WRITE_TO_FOLDER, true, workingResult.getSourceFile().getParentFile().getAbsolutePath());
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
            return false;
        }
        return true;
    }

    protected boolean checkResult(ResultInput resultInput) {
        ResultInput resultInput2 = resultInput;
        Integer n = resultInput2.errorCounter;
        resultInput2.errorCounter = resultInput2.errorCounter + 1;
        Document documentInstance = Document.getInstance();
        resultInput.workingResult.setCurrentState(WorkingResult.Status.ERROR);
        LOG.trace("");
        documentInstance.reportError(ErrorCode.UNKNOWN, true, resultInput.exception.toString());
        resultInput.workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
        return false;
    }

    @Override
    public void resetProcess() {
        super.resetProcess();
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof ProcessFormular) {
            ProcessFormular processFormular = (ProcessFormular)((Object)stepFormular);
            processFormular.setSubsequentProcess(this.getDefaultSubsequentProcess());
        }
    }

    protected static enum WorkingState {
        NONE,
        RUNNING,
        CALLING_SUBSEQUENT_PROCESS,
        FINISHED;

    }

    public static enum Repeat {
        CANCEL,
        OVERWRITE,
        OVERWRITE_ALL,
        SKIP,
        SKIP_ALL,
        ZIP_ENTRY_RENAME;

    }
}

