/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.control.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.model.DetachableFile;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.governikus.csl.uom.validate.ValidateResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WorkingResult {
    List<File> resultFiles;
    DetachableFile sourceFile;
    ViewableProcessFile processFile;
    Status state;
    ErrorObject errorObject;
    boolean zipped = false;
    ValidateResponse response;

    public WorkingResult(DetachableFile sourceFile) {
        this.sourceFile = sourceFile;
        this.resultFiles = new ArrayList<File>();
        this.state = Status.FINISHED;
    }

    public WorkingResult() {
        this.sourceFile = null;
        this.resultFiles = new ArrayList<File>();
        this.state = Status.FINISHED;
    }

    public WorkingResult(Status state) {
        this.sourceFile = null;
        this.resultFiles = new ArrayList<File>();
        this.state = state;
    }

    public WorkingResult(DetachableFile sourceFile, Status state) {
        this.sourceFile = sourceFile;
        this.resultFiles = new ArrayList<File>();
        this.state = state;
    }

    public WorkingResult(DetachableFile sourceFile, Status state, ViewableProcessFile file) {
        this.sourceFile = sourceFile;
        this.resultFiles = new ArrayList<File>();
        this.state = state;
        this.processFile = file;
    }

    public DetachableFile getSourceFile() {
        return this.sourceFile;
    }

    public void removeSourceFile() {
        this.sourceFile = null;
    }

    public Status getCurrentState() {
        return this.state;
    }

    public void setCurrentState(Status state) {
        this.state = state;
        if (!Status.ERROR.equals((Object)state)) {
            return;
        }
        if (Document.getInstance().getLastReportedErrorObject() == null) {
            this.errorObject = null;
            return;
        }
        if (this.errorObject == null || this.errorObject.getErrorCode() == null) {
            this.errorObject = Document.getInstance().getLastReportedErrorObject();
            return;
        }
        if (this.errorObject.getErrorCode().errorLevel() < Document.getInstance().getLastReportedErrorObject().getErrorCode().errorLevel()) {
            this.errorObject = Document.getInstance().getLastReportedErrorObject();
        }
    }

    public void setErrorObject(ErrorObject errorObject) {
        if (errorObject == null) {
            this.errorObject = null;
            return;
        }
        if (this.errorObject == null || this.errorObject.getErrorCode() == null || this.errorObject.getErrorCode().errorLevel() < errorObject.getErrorCode().errorLevel()) {
            this.errorObject = errorObject;
        }
    }

    public ErrorObject getErrorObject() {
        return this.errorObject;
    }

    public List<File> getResult() {
        return this.resultFiles;
    }

    public boolean addResultFile(File result) {
        return this.resultFiles.add(result);
    }

    public boolean removeResultFile(File result) {
        return this.resultFiles.remove(result);
    }

    public ViewableProcessFile getProcessFile() {
        return this.processFile;
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public void setZipped(boolean zipped) {
        this.zipped = zipped;
    }

    public void setValidateResponse(ValidateResponse response) {
        this.response = response;
    }

    public ValidateResponse getValidateResponse() {
        return this.response;
    }

    public static enum Status {
        NONE,
        WORKING,
        FINISHED,
        ABORTED,
        ERROR,
        ZIPPED,
        UNZIPPED;


        public String toString() {
            return Messages.getString("workingresult.status." + this.name().toLowerCase());
        }
    }
}

