/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.control.step;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.step.StepChangedListener;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.control.step.StepI;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.formular.FormularChangeListener;
import de.bos_bremen.ecard.client.model.formular.FormularChangedEvent;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Step
implements StepI,
FormularChangeListener {
    private static final String APPLICATION_NODE_KEY = "application";
    protected ProcessI parent;
    protected List<StepChangedListener> stateChangeListener;
    protected Properties applicationProperties;
    protected XMLProperties stepProperties;
    protected final StepFactory.StepName stepName;
    protected JComponent viewPanel;
    private static final Logger LOG = LogManager.getLogger(Step.class);

    protected Step(StepFactory.StepName newStepName) {
        this.stepName = newStepName;
        this.applicationProperties = new Properties();
    }

    @Override
    public StepFactory.StepName getStepName() {
        return this.stepName;
    }

    @Override
    public JComponent getJComponent() {
        return this.viewPanel;
    }

    @Override
    public ProcessI getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ProcessI parent) {
        this.parent = parent;
    }

    @Override
    public void removeStateChangeListener(StepChangedListener changeListener) {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.remove(changeListener);
        }
    }

    @Override
    public void addStateChangeListener(StepChangedListener changeListener) {
        if (this.stateChangeListener == null) {
            this.stateChangeListener = new ArrayList<StepChangedListener>();
        }
        if (!this.stateChangeListener.contains(changeListener)) {
            this.stateChangeListener.add(changeListener);
        }
    }

    protected void notifyAllStateChangeListener(Object oldValue, Object newValue) {
        boolean changedValue;
        boolean bl = changedValue = oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
        if (changedValue) {
            this.notifyAllStateChangeListener();
        }
    }

    private void notifyAllStateChangeListener() {
        if (this.stateChangeListener == null) {
            return;
        }
        for (StepChangedListener changeListener : this.stateChangeListener) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private void setActiveStep(boolean active) {
        LOG.trace("Set active : {}:{} : {}", (Object)this.getParent().getProcessName(), (Object)this.getStepName().getName(), (Object)active);
        if (this.stateChangeListener == null) {
            return;
        }
        for (StepChangedListener changeListener : this.stateChangeListener) {
            changeListener.setActive(active);
        }
    }

    @Override
    public boolean startState() {
        LOG.info("Start {}:{}", (Object)this.getParent().getProcessName(), (Object)this.getStepName().getName());
        if (this.isRunStep()) {
            LOG.debug("delete tmp dir in {}:{}", (Object)this.getParent().getProcessName(), (Object)this.getStepName().getName());
            Step.deleteTempFolder();
        }
        this.setActiveStep(true);
        return this.getForm() != null;
    }

    @Override
    public boolean cancelState() {
        LOG.info("Abbrechen {}", (Object)this.getStepName().getName());
        if (this.isRunStep()) {
            LOG.info("delete tmp dir in {}:{}", (Object)this.getParent().getProcessName(), (Object)this.getStepName().getName());
            Step.deleteTempFolder();
        }
        return true;
    }

    private boolean isRunStep() {
        boolean stepForDeleteTempDir = "sign".equals(this.stepName.name()) || "verify".equals(this.stepName.name()) || "encrypt".equals(this.stepName.name()) || "decrypt".equals(this.stepName.name());
        return stepForDeleteTempDir;
    }

    @Override
    public void finishState() {
        LOG.trace("Finisch : setActiveStep false...");
        this.setActiveStep(false);
        if (this.isRunStep()) {
            LOG.info("delete tmp dir in {}:{}", (Object)this.getParent().getProcessName(), (Object)this.getStepName().getName());
            Step.deleteTempFolder();
        }
    }

    @Override
    public Properties getDefaults() {
        if (this.stepProperties == null) {
            this.stepProperties = new XMLProperties();
        }
        this.stepProperties.addAll(APPLICATION_NODE_KEY, this.applicationProperties);
        return (Properties)this.stepProperties.clone();
    }

    @Override
    public void setDefaults(XMLProperties propertiesForNode) {
        if (propertiesForNode != null) {
            this.applicationProperties = propertiesForNode.getPropertiesForNode(APPLICATION_NODE_KEY);
            this.stepProperties = propertiesForNode;
        }
    }

    @Override
    public Properties getApplicationProperties() {
        return (Properties)this.applicationProperties.clone();
    }

    @Override
    public String getApplicationProperty(String key) {
        return this.applicationProperties.getProperty(key);
    }

    public Properties getStepProperties() {
        return (Properties)this.stepProperties.clone();
    }

    @Override
    public void setApplicationProperty(String key, String value) {
        this.applicationProperties.setProperty(key, value);
    }

    @Override
    public boolean setProcessFormular(StepFormular formular) {
        LOG.debug(this.getStepName().getName());
        formular.addFormularChangeListener(this);
        return true;
    }

    @Override
    public void formularChanged(FormularChangedEvent ev) {
        if (ev.changedFormular(this.getStepName())) {
            this.notifyAllStateChangeListener();
        }
    }

    public LicenceTyp getLicenceTyp() {
        String key = this.getLicenceTypKey();
        return Document.getInstance().getProductFunctions().getLicence(key);
    }

    public String getLicenceTypKey() {
        String processname = "process/" + this.parent.getProcessName().getName();
        switch (this.getStepName()) {
            case selectcertificates: 
            case selectkeys: {
                processname = processname + "/key";
                break;
            }
            case selectfiles: {
                processname = processname + "/sourcefolder";
                break;
            }
            case selecttargetfolder: {
                processname = processname + "/targetfolder";
                break;
            }
            case options: {
                processname = processname + "/" + StepFactory.StepName.options.name();
                break;
            }
            case addTrustedCertificate: {
                processname = processname + "/" + StepFactory.StepName.addTrustedCertificate.name();
                break;
            }
        }
        return processname;
    }

    @Override
    public String getInCompleteDetails() {
        if (this.isStateComplete()) {
            return null;
        }
        return Messages.getString(this.getStepName().getName() + ".incomplete.tooltip");
    }

    @Override
    public void resetProcess() {
        LOG.info("reset : {}", (Object)this.getStepName().getName());
        if (this.isRunStep()) {
            LOG.info("delete tmp dir in {}:{}", (Object)this.getParent().getProcessName(), (Object)this.getStepName().getName());
            Step.deleteTempFolder();
        }
    }

    public static File getTempFolder() {
        File temp = new File(new File(System.getProperty("java.io.tmpdir")), "boreum");
        if (!temp.exists() && !temp.mkdirs()) {
            LOG.error("could not create boreum tmp folder: {}", (Object)temp);
        }
        LOG.debug("java.io.tmpdir/boreum: {}", (Object)temp.getAbsolutePath());
        return temp;
    }

    public static void deleteTempFolder() {
        LOG.trace("");
        File temp = new File(System.getProperty("java.io.tmpdir"));
        File signerFolder = new File(temp, "boreum");
        if (signerFolder.exists()) {
            LOG.debug("delete : {}", (Object)signerFolder.getAbsolutePath());
            Utils.deleteRecursive(signerFolder, true);
        }
        LOG.debug("delete files signed*, VisSig* in : {}", (Object)temp.getAbsolutePath());
        Utils.deleteTempSignedFiles(temp, "signed");
        Utils.deleteTempSignedFiles(temp, "VisSig");
    }
}

