/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.control.step;

import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.formular.steps.SelectKeysFormular;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.keyprovider.AbstractKeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.BNotKServiceKey;
import de.bos_bremen.ecard.client.model.keyprovider.CardKey;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.SignServiceKey;
import de.bos_bremen.ecard.client.model.keyprovider.SoftwareKey;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyProviderStep
extends SkippableStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyProviderStep.class);
    public final KeyUsage keyUsage;
    protected JComponent lastSelectedJComponent;
    protected static final String KEYPROVIDER_KEY = "keyprovider";
    protected static final String UID_KEY = "uid";
    protected static final String SOFTWAREKP_KEY = "softwareKP";
    protected static final String CARDKP_KEY = "cardKP";
    protected static final String ALIAS_KEY = "alias";
    protected static final String SERIALNUMBER_KEY = "serialnumber";
    private List<AbstractKeyProvider> keyProviderList = new ArrayList<AbstractKeyProvider>();
    private AbstractKeyProvider selectedKeyProvider;

    protected KeyProviderStep(StepFactory.StepName sn, KeyUsage ku) {
        super(sn);
        this.keyUsage = ku;
    }

    public List<AbstractKeyProvider> getKeyProviderList() {
        return this.keyProviderList;
    }

    public void setSelectedKeyProvider(AbstractKeyProvider selectedKeyProvider) {
        log.trace("set selectedKeyProvider : '{}'", (Object)(selectedKeyProvider == null ? "" : selectedKeyProvider.getIFDName()));
        this.selectedKeyProvider = selectedKeyProvider;
    }

    public KeyProvider getSelectedKeyProvider() {
        log.trace("selectedKeyProvider : '{}'", (Object)(this.selectedKeyProvider == null ? "kein" : this.selectedKeyProvider.getIFDName()));
        return this.selectedKeyProvider;
    }

    public void setSelectedAlias(KeyProvider kp, String a) {
        log.trace("");
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectKeysFormular) {
            SelectKeysFormular selectKeysFormular = (SelectKeysFormular)stepFormular;
            selectKeysFormular.setSelectedAlias(kp, a, this.keyUsage);
            this.replacePropertiesProviderList(selectKeysFormular.getKeyProvider(this.keyUsage));
        }
    }

    public void addKeyProviderToUse(KeyProvider kp) {
        SelectKeysFormular selectKeysFormular;
        log.trace("");
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectKeysFormular && (selectKeysFormular = (SelectKeysFormular)stepFormular).addKeyProvider(kp, this.keyUsage)) {
            this.replacePropertiesProviderList(selectKeysFormular.getKeyProvider(this.keyUsage));
        }
    }

    public void removeKeyProviderToUse(KeyProvider kp) {
        log.trace("");
        if (kp == null) {
            return;
        }
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectKeysFormular) {
            SelectKeysFormular selectKeysFormular = (SelectKeysFormular)stepFormular;
            log.trace("remove : {}", (Object)kp.getIFDName());
            selectKeysFormular.removeKeyProvider(kp, this.keyUsage);
            this.replacePropertiesProviderList(selectKeysFormular.getKeyProvider(this.keyUsage));
        }
    }

    public List<KeyProvider> getKeyProviderToUse() {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectKeysFormular) {
            SelectKeysFormular selectKeysFormular = (SelectKeysFormular)stepFormular;
            return selectKeysFormular.getKeyProvider(this.keyUsage);
        }
        return Collections.emptyList();
    }

    public String getFromConfigCardProvider() {
        log.trace("'{}'", (Object)(this.stepProperties == null ? "" : this.stepProperties.toString()));
        if (this.stepProperties == null) {
            return "";
        }
        String cardKP = (String)this.stepProperties.get("keyprovider/_1/cardKP/serialnumber");
        log.trace("{}/{}: keyprovider/_1/cardKP/serialnumber : {}", new Object[]{this.parent.getProcessName(), this.stepName.name(), cardKP});
        return cardKP == null || cardKP.isEmpty() ? "" : cardKP;
    }

    public String getFromConfigSWProvider() {
        log.trace("'{}'", (Object)(this.stepProperties == null ? "" : this.stepProperties.toString()));
        if (this.stepProperties == null) {
            return null;
        }
        String swKP = (String)this.stepProperties.get("keyprovider/_0/softwareKP");
        log.trace("{}: keyprovider/_0/softwareKP : {}", (Object)this.stepName.name(), (Object)swKP);
        return swKP == null || swKP.isEmpty() ? null : swKP;
    }

    public String getFromConfigSWAlias() {
        log.trace(this.stepProperties.toString());
        String swKPAlias = (String)this.stepProperties.get("keyprovider/_0/alias");
        log.trace("{}/{}: keyprovider/_0/alias : {}", new Object[]{this.getParent().getProcessName(), this.stepName.name(), swKPAlias});
        return swKPAlias == null || swKPAlias.isEmpty() ? "" : swKPAlias;
    }

    public boolean isUsePinCache() {
        log.trace(this.stepProperties.toString());
        String isUsePinCache = (String)this.stepProperties.get("keyprovider/_0/usePinCache");
        log.trace("{}/{} : keyprovider/_0/usePinCache = {}", new Object[]{this.parent.getProcessName(), this.stepName.name(), isUsePinCache});
        return "true".equalsIgnoreCase(isUsePinCache);
    }

    public void setUsePinCache(boolean usePinCache) {
        log.trace("set usePinCache = {}", (Object)usePinCache);
        this.stepProperties.getPropertiesForNode("_0").setProperty("usePinCache", Boolean.toString(usePinCache));
        log.trace(this.stepProperties.toString());
    }

    protected void replacePropertiesProviderList(List<KeyProvider> p) {
        this.removeAllPropertiesProvider();
        this.storeAllPropertiesProvider(p);
    }

    protected void storeAllPropertiesProvider(List<KeyProvider> p) {
        log.trace("");
        if (p == null || p.isEmpty()) {
            return;
        }
        for (KeyProvider provider : p) {
            this.storePropertiesProvider(provider);
        }
    }

    protected void storePropertiesProvider(KeyProvider provider) {
        log.trace("");
        if (provider instanceof SoftwareKey) {
            SoftwareKey softwareKey = (SoftwareKey)provider;
            this.stepProperties.put("keyprovider/_0/softwareKP", softwareKey.getProviderKeyFile().getAbsolutePath());
            this.stepProperties.put("keyprovider/_0/alias", softwareKey.getSelectedAlias() != null ? softwareKey.getSelectedAlias() : "");
            this.stepProperties.put("keyprovider/_0/usePinCache", Boolean.toString(softwareKey.isUsePinCache()));
        }
        if (provider instanceof CardKey) {
            CardKey cardKey = (CardKey)provider;
            this.stepProperties.put("keyprovider/_1/cardKP/serialnumber", cardKey.getSerialnumberForselectedAlias());
            this.stepProperties.put("keyprovider/_1/cardKP/alias", cardKey.getSelectedAlias());
        }
    }

    protected void removeAllPropertiesProvider() {
        XMLProperties fileProperties = this.stepProperties.extractPropertiesForNode(KEYPROVIDER_KEY);
        fileProperties.clear();
    }

    @Override
    public boolean isStateComplete() {
        boolean keyProviderOK = false;
        List<KeyProvider> keyProviderToUse = this.getKeyProviderToUse();
        if (keyProviderToUse == null) {
            return keyProviderOK;
        }
        if (keyProviderToUse.isEmpty()) {
            return keyProviderOK;
        }
        if (keyProviderToUse.get(0).getSelectedAlias() == null) {
            return keyProviderOK;
        }
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        for (KeyProvider keyProvider : keyProviderToUse) {
            if (keyProvider instanceof SoftwareKey) {
                if (!productFunctions.getLicence(this.getLicenceTypKey() + "/software").useInProcess() && !productFunctions.getLicence(this.getLicenceTypKey() + "/certificate/software").useInProcess()) continue;
                keyProviderOK = true;
                continue;
            }
            if (keyProvider instanceof SignServiceKey) {
                SignServiceKey signServiceKey = (SignServiceKey)keyProvider;
                if (!productFunctions.getLicence(this.getLicenceTypKey() + "/signservice").useInProcess()) continue;
                keyProviderOK = signServiceKey.getSelectedAlias() != null;
                continue;
            }
            if (keyProvider instanceof BNotKServiceKey) {
                BNotKServiceKey bNotKServiceKey = (BNotKServiceKey)keyProvider;
                if (!productFunctions.getLicence(this.getLicenceTypKey() + "/BNotK").useInProcess()) continue;
                keyProviderOK = bNotKServiceKey.getSelectedAlias() != null;
                continue;
            }
            if (!productFunctions.getLicence(this.getLicenceTypKey()).useInProcess()) continue;
            keyProviderOK = keyProvider.getSelectedAlias() != null;
        }
        return keyProviderOK;
    }

    public JComponent getLastSelectedJComponent() {
        return this.lastSelectedJComponent;
    }

    public void setLastSelectedJComponent(JComponent lastSelectedJC) {
        this.lastSelectedJComponent = lastSelectedJC;
    }
}

