/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.control.step;

import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.formular.steps.SelectTargetFolderFormular;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import java.io.File;
import java.util.HashMap;
import javax.swing.JComponent;

public abstract class AbstractSelectTargetDir
extends SkippableStep {
    private static final String TARGET_FOLDER_KEY = "targetfolder.path";
    private static final String LOCALCOPY_FOLDER_KEY = "localcopyfolder.path";
    private static final String TARGET_FOLDER_TYPE_KEY = "targetfolder.type";
    private JComponent lastSelectedJComponent;

    protected AbstractSelectTargetDir() {
        this(StepFactory.StepName.selecttargetfolder);
    }

    protected AbstractSelectTargetDir(StepFactory.StepName stepName) {
        super(stepName);
    }

    public String getTargetFolder() {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectTargetFolderFormular) {
            SelectTargetFolderFormular selectTargetFolderFormular = (SelectTargetFolderFormular)stepFormular;
            return selectTargetFolderFormular.getTargetFolder();
        }
        return null;
    }

    public String getLocalCopyFolder() {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectTargetFolderFormular) {
            SelectTargetFolderFormular selectTargetFolderFormular = (SelectTargetFolderFormular)stepFormular;
            return selectTargetFolderFormular.getLocalCopyFolder();
        }
        return null;
    }

    public boolean setTargetFolder(String targetFolder) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectTargetFolderFormular) {
            SelectTargetFolderFormular selectTargetFolderFormular = (SelectTargetFolderFormular)stepFormular;
            selectTargetFolderFormular.setTargetFolder(targetFolder);
            this.stepProperties.setProperty(TARGET_FOLDER_KEY, targetFolder != null ? targetFolder : "");
            return true;
        }
        return false;
    }

    public boolean setLocalCopyFolder(String targetFolder) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectTargetFolderFormular) {
            SelectTargetFolderFormular selectTargetFolderFormular = (SelectTargetFolderFormular)stepFormular;
            selectTargetFolderFormular.setLocalCopyFolder(targetFolder);
            this.stepProperties.setProperty(LOCALCOPY_FOLDER_KEY, targetFolder != null ? targetFolder : "");
            return true;
        }
        return false;
    }

    public TargetFolderType getTargetFolderTyp() {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectTargetFolderFormular) {
            SelectTargetFolderFormular selectTargetFolderFormular = (SelectTargetFolderFormular)stepFormular;
            return selectTargetFolderFormular.getTargetFolderType();
        }
        return TargetFolderType.sameAsSourceFolder;
    }

    public void setTargetFolderTyp(TargetFolderType targetFolderTyp) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectTargetFolderFormular) {
            SelectTargetFolderFormular selectTargetFolderFormular = (SelectTargetFolderFormular)stepFormular;
            selectTargetFolderFormular.setTargetFolderType(targetFolderTyp);
        }
        this.stepProperties.setProperty(TARGET_FOLDER_TYPE_KEY, targetFolderTyp != null ? targetFolderTyp.toString() : TargetFolderType.sameAsSourceFolder.toString());
    }

    @Override
    public boolean setProcessFormular(StepFormular form) {
        File tempFolder;
        String targetFolder;
        if (!(form instanceof SelectTargetFolderFormular) || !super.setProcessFormular(form)) {
            return false;
        }
        this.form = form;
        SelectTargetFolderFormular folderFormular = (SelectTargetFolderFormular)this.form;
        TargetFolderType targetFolderType = folderFormular.getTargetFolderType();
        if (targetFolderType == null) {
            targetFolderType = TargetFolderType.valueOf(this.stepProperties.getProperty(TARGET_FOLDER_TYPE_KEY, TargetFolderType.sameAsSourceFolder.toString()));
        }
        if ((targetFolder = folderFormular.getTargetFolder()) == null) {
            targetFolder = this.stepProperties.getProperty(TARGET_FOLDER_KEY, null);
        }
        if (!(targetFolder == null || targetFolder.indexOf("://") != -1 || targetFolder.indexOf("file:") != -1 || (tempFolder = new File(targetFolder)).exists() && tempFolder.isDirectory())) {
            targetFolder = null;
            targetFolderType = TargetFolderType.sameAsSourceFolder;
        }
        folderFormular.setTargetFolderType(targetFolderType);
        folderFormular.setTargetFolder(targetFolder);
        return true;
    }

    @Override
    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/targetfolder", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/localcopyfolder", LicenceTyp.hide_disable);
        return processLicenceTypes;
    }

    public JComponent getLastSelectedJComponent() {
        return this.lastSelectedJComponent;
    }

    public void setLastSelectedJComponent(JComponent lastSelectedJC) {
        this.lastSelectedJComponent = lastSelectedJC;
    }

    @Override
    public boolean isStateComplete() {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof SelectTargetFolderFormular)) {
            return false;
        }
        SelectTargetFolderFormular selectTargetFormular = (SelectTargetFolderFormular)stepFormular;
        TargetFolderType targetFolderType = selectTargetFormular.getTargetFolderType();
        if (targetFolderType == null) {
            return false;
        }
        if (targetFolderType == TargetFolderType.sameAsSourceFolder) {
            return true;
        }
        String targetFolder = selectTargetFormular.getTargetFolder();
        if (targetFolder == null || targetFolder.trim().isEmpty()) {
            return false;
        }
        if (targetFolder.indexOf("://") != -1 && targetFolder.indexOf("file:") == -1) {
            return true;
        }
        return new File(targetFolder).exists();
    }

    public String getStepProperty(String key) {
        return this.getStepProperties().getProperty(key, null);
    }
}

