/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.control.process.impl;

import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessListener;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.control.step.StepI;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.model.ApplicationPolicy;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkInstanceHandler;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.ProcessFileSeen;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectFilesFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectSignedFilesFormular;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Process
implements ProcessI {
    private static final String SUBSEQUENT_PROCESS_UID = "subsequent_process_uid";
    private static final Logger LOG = LogManager.getLogger(Process.class);
    protected ProcessFormular form;
    protected int currentIndex = 0;
    private final List<Step> steps;
    protected final List<ProcessListener> listeners;
    private List<String> completeDetails = new ArrayList<String>();
    private String subsequentProcessUID;

    protected Process(XMLProperties properties) {
        this.steps = new LinkedList<Step>();
        this.listeners = new LinkedList<ProcessListener>();
        this.setProperties(properties);
        this.addProcessRessourceBundle();
    }

    public void addStep(Step step) {
        this.steps.add(step);
        step.setParent(this);
    }

    public void addStep(int index, Step step) {
        this.steps.add(index, step);
        step.setParent(this);
    }

    @Override
    public int getStepsCount() {
        return this.steps.size();
    }

    @Override
    public List<Step> getSteps() {
        return new ArrayList<Step>(this.steps);
    }

    @Override
    public Step getStep(String stepName) {
        Step result = null;
        for (Step step : this.steps) {
            if (!step.getStepName().getName().equals(stepName)) continue;
            result = step;
            break;
        }
        return result;
    }

    private void notifyProcessListeners() {
        this.completeDetails = new ArrayList<String>();
        for (ProcessListener l : this.listeners) {
            l.processChange();
        }
    }

    @Override
    public void addProcessListener(ProcessListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeProcessListener(ProcessListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setCurrentStep(String stepName) {
        for (int i = 0; i < this.steps.size(); ++i) {
            Step step = this.steps.get(i);
            if (!step.getStepName().getName().equals(stepName)) continue;
            this.finishCurrentStep();
            this.currentIndex = i;
            this.startCurrentStep();
            break;
        }
        this.notifyProcessListeners();
    }

    @Override
    public void setFirstStep() {
        LOG.debug("setFirstStep");
        this.finishCurrentStep();
        this.currentIndex = this.findFirstStep();
        this.startCurrentStep();
        this.notifyProcessListeners();
    }

    private int findFirstStep() {
        int stepIndex;
        for (stepIndex = 0; stepIndex < this.steps.size() - 1 && !this.steps.get(stepIndex).getLicenceTyp().isVisible(); ++stepIndex) {
        }
        return stepIndex;
    }

    private void finishCurrentStep() {
        this.getCurrentStep().finishState();
    }

    private void startCurrentStep() {
        if (!this.getLicenceTyp().isVisible()) {
            LOG.trace("CurrentStep : {} ist nicht sichtbar -> return", (Object)this.getCurrentStep());
            return;
        }
        if (!this.steps.get(this.currentIndex).getLicenceTyp().isVisible()) {
            this.nextStep();
        }
        this.completeDetails = new ArrayList<String>();
        this.canProcess();
        this.notifyProcessListeners();
        this.getCurrentStep().startState();
    }

    @Override
    public Step getCurrentStep() {
        return this.steps.get(this.currentIndex);
    }

    @Override
    public boolean startProcess(ProcessFormular processFormular) {
        LOG.debug(this.getProcessName().getName());
        if (!(processFormular instanceof StepFormular)) {
            return false;
        }
        this.clearFileList();
        if (!processFormular.equals(this.form)) {
            this.form = processFormular;
        } else {
            this.form.setSubsequentProcess(Config.getInstance().getSubsequentProcess(this.getSubsequentProcessUID()));
        }
        Document.getInstance().resetLastErrorObject();
        this.completeDetails = new ArrayList<String>();
        LOG.info("FrameworkState : {} -> working ", (Object)Document.getInstance().getCurrentFrameworkState());
        Document.getInstance().setCurrentFrameworkState(FrameworkStatus.FrameworkState.working);
        for (StepI stepI : this.steps) {
            stepI.setProcessFormular((StepFormular)((Object)this.form));
        }
        this.startCurrentStep();
        return true;
    }

    @Override
    public boolean restartProcess() {
        LOG.info("FrameworkState : {} -> working ", (Object)Document.getInstance().getCurrentFrameworkState());
        Document.getInstance().setCurrentFrameworkState(FrameworkStatus.FrameworkState.working);
        this.clearRestartFileList();
        this.finishCurrentStep();
        for (StepI stepI : this.steps) {
            stepI.resetProcess();
        }
        this.currentIndex = this.findFirstStep();
        this.startCurrentStep();
        LOG.debug("restartProcess");
        this.notifyProcessListeners();
        return true;
    }

    @Override
    public boolean cancelProcess() {
        LOG.info("FrameworkState {} -> cancelled ", (Object)Document.getInstance().getCurrentFrameworkState());
        Document.getInstance().setCurrentFrameworkState(FrameworkStatus.FrameworkState.cancelled);
        this.finishCurrentStep();
        this.currentIndex = this.findFirstStep();
        this.notifyProcessListeners();
        LOG.trace("");
        return true;
    }

    private void clearRestartFileList() {
        this.form.addBlockRequest();
        List<WorkingResult> workingResults = ((WorkingStep)this.steps.get(this.steps.size() - 1)).getWorkingResults();
        for (WorkingResult workingResult : workingResults) {
            if (!workingResult.getCurrentState().equals((Object)WorkingResult.Status.FINISHED) && !workingResult.getCurrentState().equals((Object)WorkingResult.Status.UNZIPPED) && !workingResult.getCurrentState().equals((Object)WorkingResult.Status.ZIPPED)) continue;
            ProcessFormular processFormular = this.form;
            if (processFormular instanceof SelectFilesFormular) {
                SelectFilesFormular selectFilesFormular = (SelectFilesFormular)((Object)processFormular);
                selectFilesFormular.removeSelectedFile((ProcessFileSeen)workingResult.getProcessFile());
            }
            if (!((processFormular = this.form) instanceof SelectSignedFilesFormular)) continue;
            SelectSignedFilesFormular selectSignedFilesFormular = (SelectSignedFilesFormular)((Object)processFormular);
            selectSignedFilesFormular.removeSelectedFile((ProcessSignedFile)workingResult.getProcessFile());
        }
        this.form.removeBlockRequest();
    }

    private void clearFileList() {
        ProcessFormular processFormular = this.form;
        if (processFormular instanceof SelectSignedFilesFormular) {
            SelectSignedFilesFormular selectSignedFilesFormular = (SelectSignedFilesFormular)((Object)processFormular);
            selectSignedFilesFormular.removeAllFiles();
        } else {
            processFormular = this.form;
            if (processFormular instanceof SelectFilesFormular) {
                SelectFilesFormular selectFilesFormular = (SelectFilesFormular)((Object)processFormular);
                selectFilesFormular.removeAllFiles();
            }
        }
    }

    @Override
    public boolean stopProcess() {
        LOG.info("Stop Process...");
        Document documentInstance = Document.getInstance();
        LOG.info("FrameworkState : {} ", (Object)documentInstance.getCurrentFrameworkState());
        if (!documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.cancelled) && !documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.initializing)) {
            LOG.info("FrameworkState : {} -> online ", (Object)documentInstance.getCurrentFrameworkState());
            documentInstance.setCurrentFrameworkState(FrameworkStatus.FrameworkState.online);
        }
        this.finishCurrentStep();
        this.currentIndex = this.findFirstStep();
        this.notifyProcessListeners();
        if (ApplicationPolicy.hideAfterProcess.equals((Object)documentInstance.getApplicationPolicy()) && !documentInstance.getCurrentFrameworkState().equals((Object)FrameworkStatus.FrameworkState.initializing)) {
            FrameworkInstanceHandler singleInstanceHandler = documentInstance.getSingleInstanceHandler();
            if (singleInstanceHandler != null) {
                singleInstanceHandler.hide();
            } else {
                int errorCode = ErrorCode.ABORTED.getReturnCode();
                if (!FrameworkStatus.FrameworkState.cancelled.equals((Object)documentInstance.getCurrentFrameworkState())) {
                    errorCode = ErrorCode.OK.getReturnCode();
                }
                documentInstance.reportError(errorCode, false, this.getProcessName().getName());
            }
        }
        LOG.info("Stop Process done.");
        return true;
    }

    protected abstract boolean couldHideAfterProcess();

    @Override
    public void isFinished(boolean isFinished) {
        LOG.info("Set Prozess finished : {} ", (Object)isFinished);
        Document documentInstance = Document.getInstance();
        Config.getInstance().removeSuppressedElement("error.while_processing");
        FrameworkStatus.FrameworkState oldValue = documentInstance.getCurrentFrameworkState();
        if (!FrameworkStatus.FrameworkState.cancelled.equals((Object)oldValue)) {
            if (isFinished) {
                LOG.info("FrameworkState : {} -> finished ", (Object)Document.getInstance().getCurrentFrameworkState());
                documentInstance.setCurrentFrameworkState(FrameworkStatus.FrameworkState.finished);
                documentInstance.setProcessPolicy(ProcessPolicy.useDefault);
            } else {
                LOG.info("FrameworkState : {} -> working ", (Object)Document.getInstance().getCurrentFrameworkState());
                documentInstance.setCurrentFrameworkState(FrameworkStatus.FrameworkState.working);
            }
            if (!documentInstance.getCurrentFrameworkState().equals((Object)oldValue)) {
                LOG.debug("FrameworkState was changed, notify : {} --> {}", (Object)oldValue, (Object)documentInstance.getCurrentFrameworkState());
                this.notifyProcessListeners();
            }
        }
        if (isFinished && ApplicationPolicy.hideAfterProcess.equals((Object)documentInstance.getApplicationPolicy()) && this.couldHideAfterProcess()) {
            LOG.debug("AppPolicy --> hideAfterProcess && couldHideAfterProcess && isFinish");
            FrameworkInstanceHandler singleInstanceHandler = documentInstance.getSingleInstanceHandler();
            if (singleInstanceHandler != null) {
                LOG.debug("call singleInstanceHandler.hide()");
                singleInstanceHandler.hide();
                Document.getInstance().getProcessFactory().getProcessChoose().showProcess(RootProcessName.getInstance());
            } else {
                LOG.debug("singleInstanceHandler == null --> reportError with OK/Aborted");
                int errorCode = ErrorCode.ABORTED.getReturnCode();
                if (FrameworkStatus.FrameworkState.finished.equals((Object)documentInstance.getCurrentFrameworkState())) {
                    errorCode = ErrorCode.OK.getReturnCode();
                }
                documentInstance.reportError(errorCode, false, this.getProcessName().getName());
            }
        }
    }

    @Override
    public FrameworkStatus.FrameworkState getState() {
        return Document.getInstance().getCurrentFrameworkState();
    }

    @Override
    public ProcessFormular getProcessFormular() {
        return this.form;
    }

    @Override
    public boolean hasNextStep() {
        boolean hasNext = false;
        for (int i = this.currentIndex; i < this.steps.size() - 1; ++i) {
            if (!this.steps.get(i).getLicenceTyp().isVisible()) continue;
            hasNext = true;
            break;
        }
        return hasNext;
    }

    @Override
    public boolean hasPreviousStep() {
        boolean hasPrevius = false;
        for (int i = 0; i < this.currentIndex; ++i) {
            if (!this.steps.get(i).getLicenceTyp().isVisible()) continue;
            hasPrevius = true;
            break;
        }
        return hasPrevius;
    }

    @Override
    public void nextUncompleteStep() {
        LOG.debug("nextUncompleteStep");
        this.finishCurrentStep();
        if (this.steps.get(this.currentIndex).isStateComplete()) {
            boolean nextStepIsNotProcessableWorkingStep;
            boolean currentStepIsUncomplete;
            do {
                SkippableStep skippableStep;
                Step step;
                ++this.currentIndex;
                if (this.currentIndex >= this.steps.size()) {
                    LOG.debug("currentIndex >= steps.size()");
                    break;
                }
                currentStepIsUncomplete = this.steps.get(this.currentIndex).getLicenceTyp().isVisible() ? !(this.steps.get(this.currentIndex) instanceof SkippableStep) || !this.steps.get(this.currentIndex).isStateComplete() || (step = this.steps.get(this.currentIndex)) instanceof SkippableStep && !(skippableStep = (SkippableStep)step).skipStep() : false;
                nextStepIsNotProcessableWorkingStep = this.currentIndex < this.steps.size() - 1 ? this.steps.get(this.currentIndex + 1) instanceof WorkingStep && !this.canProcess() : false;
            } while (!currentStepIsUncomplete && !nextStepIsNotProcessableWorkingStep);
            if (this.currentIndex >= this.getStepsCount()) {
                this.currentIndex = this.getStepsCount() - 1;
            }
        }
        this.startCurrentStep();
        this.notifyProcessListeners();
    }

    @Override
    public void nextStep() {
        this.finishCurrentStep();
        do {
            ++this.currentIndex;
        } while (this.currentIndex < this.getStepsCount() - 1 && !this.steps.get(this.currentIndex).getLicenceTyp().isVisible());
        if (this.currentIndex >= this.getStepsCount()) {
            this.currentIndex = this.getStepsCount() - 1;
        }
        this.startCurrentStep();
        this.notifyProcessListeners();
    }

    @Override
    public void previousStep() {
        LOG.debug("prevStep");
        this.finishCurrentStep();
        do {
            --this.currentIndex;
        } while (this.currentIndex > 0 && !this.steps.get(this.currentIndex).getLicenceTyp().isVisible());
        if (this.currentIndex < 0) {
            this.currentIndex = this.findFirstStep();
        }
        this.startCurrentStep();
        this.notifyProcessListeners();
    }

    @Override
    public void previousIncompleteStep() {
        boolean prevIsIncomplete;
        LOG.debug("previousIncompleteStep");
        this.finishCurrentStep();
        do {
            SkippableStep skippableStep;
            --this.currentIndex;
            Step step = this.steps.get(this.currentIndex);
            prevIsIncomplete = step.getLicenceTyp().isVisible() ? !(step.isStateComplete() && step instanceof SkippableStep && (skippableStep = (SkippableStep)step).skipStep()) : false;
        } while (this.currentIndex > 0 && !prevIsIncomplete);
        this.startCurrentStep();
        this.notifyProcessListeners();
    }

    @Override
    public XMLProperties getProperties() {
        LOG.trace("");
        XMLProperties properties = new XMLProperties();
        for (Step step : this.steps) {
            Properties props = step.getDefaults();
            properties.addAll(step.getStepName().getName(), props);
        }
        if (this.getSubsequentProcessUID() != null) {
            properties.put(SUBSEQUENT_PROCESS_UID, this.getSubsequentProcessUID());
        }
        return properties;
    }

    @Override
    public void setProperties(XMLProperties properties) {
        LOG.trace("");
        if (properties == null) {
            return;
        }
        Object subSequenceProcessUIDObj = properties.get(SUBSEQUENT_PROCESS_UID);
        if (subSequenceProcessUIDObj instanceof String) {
            String uid = (String)subSequenceProcessUIDObj;
            this.setSubsequentProcessUID(uid);
        }
        for (Step step : this.steps) {
            step.setDefaults(properties.getPropertiesForNode(step.getStepName().getName()));
        }
    }

    @Override
    public boolean canProcess() {
        boolean canProcess = true;
        for (StepI stepI : this.steps) {
            if (stepI instanceof WorkingStep) continue;
            boolean isStepComplete = stepI.isStateComplete();
            if (!isStepComplete && !this.completeDetails.contains(stepI.getInCompleteDetails())) {
                this.completeDetails.add(stepI.getInCompleteDetails());
            }
            canProcess = canProcess && isStepComplete;
        }
        return canProcess;
    }

    @Override
    public List<String> getCompleteDetails() {
        this.completeDetails = new ArrayList<String>();
        this.canProcess();
        return this.completeDetails;
    }

    @Override
    public LicenceTyp getLicenceTyp() {
        return Document.getInstance().getProductFunctions().getLicence("process/" + this.getProcessName().getName());
    }

    @Override
    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        for (StepI stepI : this.getSteps()) {
            processLicenceTypes.putAll(stepI.getDefaultLicenceTypes());
        }
        processLicenceTypes.put("process/" + this.getProcessName().getName(), LicenceTyp.disable);
        return processLicenceTypes;
    }

    @Override
    public String getSubsequentProcessUID() {
        return this.subsequentProcessUID;
    }

    @Override
    public void setSubsequentProcessUID(String processUID) {
        this.subsequentProcessUID = processUID;
    }

    public String toString() {
        return this.getProcessName().getName();
    }
}

