/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.control.process;

import de.bos_bremen.ecard.client.control.process.ProcessComparator;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.gui.ProcessChooseView;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.error.ErrorObject;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;

public class ProcessFactory {
    private List<ProcessI> allProcesses;
    private HashMap<ProcessName, ProcessFormular> formularMap = new HashMap();
    private ProcessChooseView processChoose;

    public void setProcessChooseView(ProcessChooseView chooseView) {
        this.processChoose = chooseView;
    }

    public ProcessFactory(ProcessChooseView chooseView) {
        Document.getInstance().setProcessFactory(this);
        this.processChoose = chooseView;
        this.allProcesses = new ArrayList<ProcessI>();
        for (ProcessI processI : ServiceLoader.load(ProcessI.class)) {
            this.allProcesses.add(processI);
        }
        Document.getInstance().setProductFunctions(ProductFunctions.getInstance());
    }

    public ProcessChooseView getProcessChoose() {
        return this.processChoose;
    }

    public List<ProcessI> getProcesses(XMLProperties properties) {
        this.setProperties(properties);
        return this.allProcesses;
    }

    public List<ProcessI> getProcesses() {
        this.allProcesses.sort(new ProcessComparator());
        return this.allProcesses;
    }

    public XMLProperties getProperties() {
        XMLProperties properties = new XMLProperties();
        for (ProcessI process : this.allProcesses) {
            properties.addAll(process.getProcessName().getName(), process.getProperties());
        }
        return properties;
    }

    public void resetProcesses() {
        this.formularMap = new HashMap();
        this.setProperties(new XMLProperties());
    }

    public void setProperties(XMLProperties properties) {
        if (properties == null) {
            return;
        }
        for (ProcessI process : this.allProcesses) {
            process.setProperties(properties.getPropertiesForNode(process.getProcessName().getName()));
        }
    }

    public void setProperties(ProcessName processName, XMLProperties properties) {
        if (properties == null) {
            return;
        }
        for (ProcessI process : this.allProcesses) {
            if (!process.getProcessName().equals(processName)) continue;
            process.setProperties(properties.getPropertiesForNode(process.getProcessName().getName()));
        }
    }

    public ProcessFormular getProcessesFormular(ProcessI process) {
        ProcessFormular formular = this.formularMap.get(process.getProcessName());
        if (formular == null) {
            formular = process.createNewFormular();
            this.formularMap.put(process.getProcessName(), formular);
        }
        return formular;
    }

    public ProcessFormular getNewProcessesFormularInstance(ProcessI process) {
        ProcessFormular formular = Document.getInstance().getProductFunctions().enableGeneralIntegratedWS().useInProcess() ? process.createNewFormular() : this.createClonedProcessesFormularInstance(process);
        this.formularMap.put(process.getProcessName(), formular);
        return formular;
    }

    public ProcessFormular createClonedProcessesFormularInstance(ProcessI process) {
        ProcessFormular formular = this.formularMap.get(process.getProcessName());
        formular = formular == null ? process.createNewFormular() : process.createNewFormular(formular);
        return formular;
    }

    public void setProcessesFormularInstance(ProcessI process, ProcessFormular processFormular) {
        if (processFormular != null) {
            this.formularMap.put(process.getProcessName(), processFormular);
        }
    }

    public ProcessI getProcess(ProcessName processName) {
        ProcessI process = null;
        for (ProcessI _process : this.allProcesses) {
            if (!_process.getProcessName().equals(processName)) continue;
            process = _process;
        }
        return process;
    }

    public ProcessI getProcess(String processName) {
        ProcessI process = null;
        for (ProcessI _process : this.allProcesses) {
            if (!_process.getProcessName().getName().equals(processName)) continue;
            process = _process;
        }
        return process;
    }

    public void setErrorObjectToAllCurrentWorkingResults(ErrorObject errorObject) {
        List<WorkingResult> workingResults = Document.getInstance().getWorkingResults();
        for (int i = 0; workingResults != null && i < workingResults.size(); ++i) {
            WorkingResult workingResult = workingResults.get(i);
            workingResult.setErrorObject(errorObject);
        }
    }
}

