/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.config;

import de.bos_bremen.ecard.client.control.process.ProcessFactory;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ConfigDialog;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Configuration {
    private static File file;

    public static void main(String[] args) {
        Configuration.run();
    }

    public static void run() {
        JFrame frame = new JFrame();
        Document documentInstance = Document.getInstance();
        documentInstance.setParent(frame);
        documentInstance.setProcessFactory(new ProcessFactory(null));
        Configuration.setLookAndFeel();
        Configuration.getConfig(documentInstance);
        documentInstance.setSaveConfig(true);
        documentInstance.getProcessFactory().setProperties(Config.getInstance().getProcessProperties());
        ConfigDialog configDialog = new ConfigDialog(frame);
        configDialog.setVisible(true);
        String formatedMessage = "Konfiguration wurde erfolgreich erstellt. Datei: " + file.getParent() + File.separator + file.getName();
        JLabel messageLabel = (JLabel)ComponentUtils.makeFocusable(new JLabel(formatedMessage));
        JOptionPane.showMessageDialog(frame, messageLabel, "Fertig", 1);
        System.exit(0);
    }

    private static Config getConfig(Document documentInstance) {
        try {
            Config.getInstance();
        }
        catch (RuntimeException ex) {
            JFileChooser fileChooser = FileChooserFactory.createFileChooser(new File(System.getProperty("user.home")));
            fileChooser.setPreferredSize(GUIUtils.createChooserDimension());
            int answer = fileChooser.showOpenDialog(null);
            if (answer == 0) {
                file = fileChooser.getSelectedFile();
                if (!file.getName().endsWith(".xml")) {
                    file = new File(fileChooser.getSelectedFile().getAbsolutePath() + ".xml");
                }
                System.setProperty("BoreumConfigFolder", file.getParent() + File.separator);
                Config.init((Component)documentInstance.getFrame(), file.getName());
            }
            System.exit(1);
        }
        return Config.getInstance();
    }

    private static void setLookAndFeel() {
        GUIUtils.setSignerThemeInUIManager();
    }
}

