/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.debug_mode.DebugMode;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public class ShowProtocolAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_NAME_KEY = "action.showprotocol";

    public ShowProtocolAction(Component parent, boolean isForMenu) {
        super(ACTION_NAME_KEY + (isForMenu ? ".menu" : ""), parent);
        this.setKeyAndIcon(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOG.info("Protokolldatei anzeigen");
        File protocolFile = DebugMode.getInstance().getLogFile();
        LOG.info("Protokolldatei  : {}", (Object)protocolFile);
        if (protocolFile != null && protocolFile.exists()) {
            this.openWithSystem(protocolFile);
        } else {
            File eidLogFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "eid_client_debug.log");
            if (eidLogFile.exists() && eidLogFile.length() > 0L) {
                this.openWithSystem(eidLogFile);
            }
        }
    }

    private void openWithSystem(File file) {
        try {
            Utils.openFile(file);
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            Document.getInstance().displayRedundantMessages(this.parent, "showfile.failure", 1);
        }
    }
}

