/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ci.asn1.cms.CMSSignedData;
import de.bos_bremen.ci.asn1.cms.EncapsulatedContentInfo;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.gui.view.component.table.action.ViewFilesAction;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.HashedFile;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.cms.CMSException;

public class ShowFileAction
extends AbstractSignerAction {
    private static final long serialVersionUID = -6467537194059882552L;
    private static final String ACTION_NAME_KEY = "action.showfile";
    private final transient ViewFilesAction viewFileAction;

    public ShowFileAction(Component parent, ViewFilesAction viewFileAction) {
        super(ACTION_NAME_KEY, parent);
        this.viewFileAction = viewFileAction;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        LOG.trace("- Event : {} ", (Object)evt);
        List<ViewableProcessFile> allFiles = this.viewFileAction.getFiles();
        for (ViewableProcessFile pfs : allFiles) {
            LOG.trace("- Datei : {}", (Object)pfs.getFile().getAbsolutePath());
            if (pfs instanceof ProcessSignedFile) {
                ProcessSignedFile signedFile = (ProcessSignedFile)pfs;
                File detachedFile = signedFile.getDetachedFile();
                if (detachedFile == null) {
                    LOG.trace("");
                    this.showFile(signedFile.getFile());
                    continue;
                }
                this.showSignedDetachedFile(signedFile);
                continue;
            }
            LOG.trace("");
            this.showFile(pfs.getFile());
        }
    }

    private void showSignedDetachedFile(ProcessSignedFile signedFile) {
        if (signedFile == null) {
            return;
        }
        this.showFile(signedFile.getFile());
    }

    private boolean showFile(HashedFile file) {
        if (file == null) {
            return false;
        }
        if (file.getDigest() == null) {
            file.setDigest(Utils.createSHA256Hash(file));
        }
        LOG.trace("- show file : {}", (Object)file.getAbsolutePath());
        boolean success = this.openWithSystem(file);
        this.viewFileAction.setShowSuccess(success);
        return success;
    }

    private boolean openWithSystem(File file) {
        if (file == null) {
            return false;
        }
        LOG.info("open with system : {}", (Object)file.getAbsolutePath());
        try {
            if (Utils.isCMSFile(file.getName())) {
                LOG.trace("- verify -> cms content -> open : {}", (Object)file.getName());
                if (this.openCMSFile(file)) {
                    return true;
                }
            }
            String extension = FilenameUtils.getExtension((String)file.getName()).toUpperCase();
            LOG.trace("- open {} : {}", (Object)extension, (Object)file.getName());
            Utils.openFile(file);
            this.viewFileAction.setShowSuccess(true);
            LOG.info("open {} done : {}", (Object)extension, (Object)file.getName());
            return true;
        }
        catch (Exception io) {
            this.viewFileAction.setShowSuccess(false);
            Document.getInstance().displayRedundantMessages(this.parent, "showfile.failure", 1);
            return false;
        }
    }

    private boolean openCMSFile(File file) {
        if (file == null) {
            return false;
        }
        try {
            Utils.openFile(ShowFileAction.verifySignature(file));
            this.viewFileAction.setShowSuccess(true);
            LOG.trace("- verify -> open done : {}", (Object)file.getName());
            return true;
        }
        catch (Exception ex) {
            LOG.error("- verify -> open failed : {}", (Object)file.getName());
            LOG.error("", (Throwable)ex);
            return false;
        }
    }

    private static File verifySignature(File signatureFile) throws Exception {
        if (signatureFile == null) {
            return null;
        }
        LOG.trace("- {}", (Object)signatureFile.getAbsolutePath());
        ValidateResponse response = SignerValidationProcessor.getInstance().verifyEnvelopedCMS(signatureFile);
        List svr = response.getDocumentValidationResult().getSignatureValidationResults();
        for (SignatureValidationResult signatureValidationResult : svr) {
            MajorTotalResult integrity = signatureValidationResult.getSignatureMathCheck().getMajor();
            if (integrity == MajorTotalResult.TOTAL_PASSED) continue;
            throw new CMSException("invalid cms file");
        }
        String tmpFileName = signatureFile.getName();
        tmpFileName = tmpFileName.substring(0, tmpFileName.lastIndexOf(46));
        File tmpFile = new File(Step.getTempFolder(), tmpFileName);
        int counter = 1;
        String fn = tmpFileName;
        String suffix = "";
        String prefix = fn;
        if (fn.lastIndexOf(".") > 1) {
            suffix = fn.substring(fn.lastIndexOf("."));
            prefix = fn.substring(0, fn.lastIndexOf("."));
        }
        while (tmpFile.exists()) {
            tmpFile = new File(tmpFile.getParentFile(), prefix + " (" + counter++ + ")" + suffix);
        }
        tmpFile.deleteOnExit();
        CMSSignedData s = new CMSSignedData(signatureFile);
        EncapsulatedContentInfo encapsulatedContentInfo = s.getSignedData().getEncapsulatedContentInfo();
        try (FileOutputStream os = new FileOutputStream(tmpFile);){
            encapsulatedContentInfo.writeContent((OutputStream)os);
        }
        LOG.trace("- {}", (Object)tmpFile.getAbsolutePath());
        return tmpFile;
    }
}

