/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.SelectedCertificateHandler;
import de.bos_bremen.ecard.client.gui.dialog.CertificateDialog;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.swing.JFrame;

public class ShowCertificateAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_NAME_KEY = "action.showCertificate";
    private transient SelectedCertificateHandler certificateHandler;

    protected ShowCertificateAction(Component parent, SelectedCertificateHandler handler) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(true);
        this.certificateHandler = handler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KeyProvider selectedKeyProvider;
        FlatCertificate selectedCertificate = this.certificateHandler.getSelectedCertificate();
        KeyUsage keyUsage = this.certificateHandler.getKeyUsage();
        if (selectedCertificate == null && (selectedKeyProvider = this.certificateHandler.getSelectedKeyProvider()) != null) {
            String alias = selectedKeyProvider.getSelectedAlias();
            if (alias == null) {
                alias = selectedKeyProvider.getDefaultAlias();
            }
            try {
                selectedCertificate = Certificate.forX509((X509Certificate)selectedKeyProvider.getCertificate(alias));
            }
            catch (ParseException | CertificateEncodingException e1) {
                LOG.error((Object)e1, e1);
            }
        }
        if (selectedCertificate != null) {
            CertificateDialog certDialog = new CertificateDialog((JFrame)Document.getInstance().getFrame(), selectedCertificate, keyUsage);
            certDialog.setVisible(true);
        } else {
            Document.getInstance().displayRedundantMessages(this.parent, "showcertificate.failure", 1);
        }
    }
}

