/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.debug_mode.DebugMode;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.licence.LicenceKeyEngine;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.mail.MessagingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendProtocolAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 382398379467324932L;
    private static final Logger LOG = LogManager.getLogger(SendProtocolAction.class);
    private static final String ACTION_NAME_KEY = "action.sendprotocol";

    public SendProtocolAction(Component parent, boolean isForMenu) {
        super(ACTION_NAME_KEY + (isForMenu ? ".menu" : ""), parent);
        this.setKeyAndIcon(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        LOG.info("Protokolldatei senden");
        File protocolFile = DebugMode.getInstance().getLogFile();
        LOG.info("Protokolldatei : {}", (Object)protocolFile);
        if (protocolFile == null || !protocolFile.exists()) {
            File eidLogFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "AutentClient_debug.log");
            LOG.debug("java.io.tmpdir log : {}", (Object)eidLogFile);
            protocolFile = eidLogFile.exists() && eidLogFile.length() > 0L ? eidLogFile : null;
        }
        if (protocolFile != null) {
            try {
                File snapShot = this.createSnapShot(protocolFile);
                snapShot.deleteOnExit();
                this.sendProtocolMail(snapShot);
            }
            catch (Exception | UnsatisfiedLinkError e) {
                LOG.error((Object)e, e);
                Document.getInstance().displayRedundantMessages(this.parent, "action.sendprotocol.failure", 1);
            }
        }
    }

    private File createSnapShot(File protocolFile) {
        String attachment = Messages.getString("action.sendprotocol.mail.attachment");
        try {
            ResourceBundle providerBundle = ResourceBundle.getBundle("resources/provider");
            attachment = providerBundle.getString("action.sendprotocol.mail.attachment");
        }
        catch (MissingResourceException e) {
            LOG.debug("");
        }
        File snapShot = new File(System.getProperty("java.io.tmpdir"), attachment);
        LOG.info("java.io.tmpdir : {}", (Object)snapShot);
        try (FileChannel srcChannel = new FileInputStream(protocolFile).getChannel();
             FileChannel dstChannel = new FileOutputStream(snapShot).getChannel();){
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
        return snapShot;
    }

    private void sendProtocolMail(File protocolFile) throws MessagingException, IOException {
        OCFProvider ocfProvider;
        String recipient = Messages.getString("action.sendprotocol.mail.recipient");
        String subject = Messages.getString("action.sendprotocol.mail.subject");
        String body = Messages.getString("action.sendprotocol.mail.body");
        ResourceBundle providerBundle = ResourceBundle.getBundle("resources/provider");
        try {
            recipient = providerBundle.getString("action.sendprotocol.mail.recipient");
        }
        catch (MissingResourceException e) {
            LOG.debug("");
        }
        try {
            subject = providerBundle.getString("action.sendprotocol.mail.subject");
        }
        catch (MissingResourceException e) {
            LOG.debug("");
        }
        try {
            body = providerBundle.getString("action.sendprotocol.mail.body");
        }
        catch (MissingResourceException e) {
            LOG.debug("");
        }
        String signerVersion = "10.11.1";
        String signerName = Messages.getResource("signer.name");
        String versionMessage = signerName == null ? "Governikus DATA Boreum Version: " + signerVersion : signerName + " Version: " + signerVersion;
        Preferences signerNode = Preferences.userRoot().node("de/governikus/boreum");
        if (signerNode != null) {
            try {
                LicenceKeyEngine licenceKeyEngine = new LicenceKeyEngine(signerNode.get("licence", ""));
                versionMessage = versionMessage + "\nLicence-ID: " + licenceKeyEngine.getKundennummer() + "-" + licenceKeyEngine.getEdition();
            }
            catch (Exception ex) {
                LOG.debug(ex.getMessage());
            }
        }
        try {
            Provider provider = Security.getProvider("ocf");
            if (provider instanceof OCFProvider) {
                ocfProvider = (OCFProvider)provider;
            } else {
                LOG.info("OCFProvider wurde nicht gefunden. Daher wird fuer die Anzeige eine neue Instanz erzeugt.");
                ocfProvider = new OCFProvider();
            }
        }
        catch (Exception ex) {
            LOG.info("Fehler beim Laden des OCFProviders. Daher wird fuer die Anzeige eine neue Instanz erzeugt.");
            ocfProvider = new OCFProvider();
        }
        versionMessage = versionMessage + "\n" + ocfProvider.getComponentName() + ": " + ocfProvider.getComponentVersion();
        body = MessageFormat.format(body, versionMessage);
        Utils.sendMail(recipient, subject, body, protocolFile);
    }
}

