/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.gui.view.component.SignedFileChooser;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;

public class SelectSignedFileAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private transient SelectedFileHandler selectFileHandler;
    private boolean mustExists = true;

    protected SelectSignedFileAction(String key, Component parentComponent, SelectedFileHandler handler) {
        super(key, parentComponent);
        this.setKeyAndIcon(true);
        this.selectFileHandler = handler;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        File lastDir = this.selectFileHandler.getLastFolder();
        SignedFileChooser chooser = new SignedFileChooser(lastDir);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(Messages.getString(this.actionKeyName + ".dialog.title"));
        if (chooser.showDialog(this.parent, Messages.getString(this.actionKeyName + ".dialog.button")) == 0) {
            File[] selectedFiles = chooser.getSelectedFiles();
            if (selectedFiles == null || selectedFiles.length == 0) {
                File selectedFile = chooser.getSelectedFile();
                if (selectedFile.exists()) {
                    this.selectFileHandler.setFileToLoad(selectedFile);
                } else if (this.mustExists) {
                    String message = MessageFormat.format(Messages.getString("dialog.selectfile.failure.message"), selectedFile.getAbsolutePath());
                    Document.getInstance().displayRedundantMessages(this.parent, "selectfile.failure", message, 1, 0, false);
                } else {
                    this.selectFileHandler.setFileToLoad(selectedFile);
                }
            } else {
                for (File f : selectedFiles) {
                    if (f.exists()) {
                        this.selectFileHandler.setFilesToLoad(selectedFiles);
                        continue;
                    }
                    if (this.mustExists) {
                        String message = MessageFormat.format(Messages.getString("dialog.selectfile.failure.message"), f.getAbsolutePath());
                        Document.getInstance().displayRedundantMessages(this.parent, "selectfile.failure", message, 1, 0, false);
                        continue;
                    }
                    this.selectFileHandler.setFilesToLoad(selectedFiles);
                }
            }
        } else {
            this.selectFileHandler.setFilesToLoad(null);
        }
    }
}

