/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SelectProcessAction
extends AbstractSignerAction
implements Action {
    private static final long serialVersionUID = 1L;
    private static final String KEY = "action.loadprocess";
    private transient SelectedFileHandler handler;

    protected SelectProcessAction(Component parentComponent, SelectedFileHandler handler) {
        super(KEY, parentComponent);
        this.setKeyAndIcon(true);
        this.handler = handler;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = FileChooserFactory.createFileChooser(this.handler.getLastFolder());
        chooser.setPreferredSize(GUIUtils.createChooserDimension(this.parent));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                if (f.isDirectory()) {
                    return true;
                }
                return name.endsWith(".exe") || name.endsWith(".bat") || name.endsWith(".com");
            }

            @Override
            public String getDescription() {
                return "Process (*exe, *.bat, *.com)";
            }
        });
        String title = Messages.getString("action.subsequentprocess.choosedialog.title");
        chooser.setDialogTitle(title);
        if (chooser.showDialog(this.parent, title) == 0) {
            this.handler.setFileToLoad(chooser.getSelectedFile());
        } else {
            this.handler.setFileToLoad(null);
        }
    }
}

