/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SelectFileAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private transient SelectedFileHandler selectFileHandler;
    private int selectionMode;
    private boolean enableMultiSelection;
    private boolean mustExists;

    protected SelectFileAction(String key, Component parent, SelectedFileHandler handler, int selectionMode, boolean enableMultiSelection, boolean mustExists) {
        super(key, parent);
        this.setKeyAndIcon(true);
        this.selectFileHandler = handler;
        this.selectionMode = selectionMode;
        this.enableMultiSelection = enableMultiSelection;
        this.mustExists = mustExists;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.selectFileHandler == null) {
            this.selectFileHandler = new SelectedFileHandler(){

                @Override
                public void setFilesToLoad(File[] files) {
                }

                @Override
                public void setFileToLoad(File file) {
                }

                @Override
                public File getLastFolder() {
                    return new File(System.getProperty("user.dir"));
                }
            };
        }
        JFileChooser chooser = FileChooserFactory.createFileChooser(this.selectFileHandler.getLastFolder());
        chooser.setPreferredSize(GUIUtils.createChooserDimension(this.parent));
        chooser.setFileSelectionMode(this.selectionMode);
        chooser.setMultiSelectionEnabled(this.enableMultiSelection);
        chooser.setDialogTitle(Messages.getString(this.actionKeyName + ".dialog.title"));
        if (1 == this.selectionMode) {
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Verzeichnis";
                }
            });
        } else {
            FileFilter[] choosableFileFilters = chooser.getChoosableFileFilters();
            chooser.addChoosableFileFilter(this.createFileFilter(".pdf"));
            chooser.addChoosableFileFilter(this.createFileFilter(".doc"));
            chooser.addChoosableFileFilter(this.createFileFilter(".txt"));
            chooser.addChoosableFileFilter(this.createFileFilter(".tif", ".tiff"));
            chooser.addChoosableFileFilter(this.createFileFilter(".xml"));
            chooser.addChoosableFileFilter(this.createFileFilter(".p7s", ".pkcs7"));
            chooser.addChoosableFileFilter(this.createFileFilter(".p7m", ".enz"));
            chooser.addChoosableFileFilter(this.createFileFilter(".zip"));
            if (choosableFileFilters != null && choosableFileFilters.length > 0) {
                chooser.setFileFilter(choosableFileFilters[0]);
            }
        }
        if (chooser.showDialog(this.parent, Messages.getString(this.actionKeyName + ".dialog.button")) == 0) {
            File[] selectedFiles = chooser.getSelectedFiles();
            if (selectedFiles == null || selectedFiles.length == 0) {
                File selectedFile = chooser.getSelectedFile();
                if (selectedFile != null && selectedFile.exists()) {
                    this.selectFileHandler.setFileToLoad(selectedFile);
                } else if (this.mustExists) {
                    String message = MessageFormat.format(Messages.getString("dialog.selectfile.failure.message"), selectedFile != null ? selectedFile.getAbsolutePath() : "");
                    Document.getInstance().displayRedundantMessages(this.parent, "selectfile.failure", message, 1, 0, false);
                } else {
                    this.selectFileHandler.setFileToLoad(selectedFile);
                }
            } else {
                ArrayList<File> fileToAdd = new ArrayList<File>();
                for (File f : selectedFiles) {
                    if (f.exists()) {
                        fileToAdd.add(f);
                        continue;
                    }
                    if (this.mustExists) {
                        String message = MessageFormat.format(Messages.getString("dialog.selectfile.failure.message"), f.getAbsolutePath());
                        Document.getInstance().displayRedundantMessages(this.parent, "selectfile.failure", message, 1, 0, false);
                        continue;
                    }
                    fileToAdd.add(f);
                }
                this.selectFileHandler.setFilesToLoad(fileToAdd.toArray(new File[0]));
            }
        } else if (this.selectFileHandler != null) {
            this.selectFileHandler.setFilesToLoad(null);
        }
    }

    private FileFilter createFileFilter(final String ... suffix) {
        return new FileFilter(){

            @Override
            public String getDescription() {
                StringBuilder builder = new StringBuilder();
                for (String string : suffix) {
                    if (builder.length() != 0) {
                        builder.append(" | ");
                    }
                    builder.append("*" + string);
                }
                return builder.toString();
            }

            @Override
            public boolean accept(File f) {
                for (String string : suffix) {
                    if (!f.getName().toLowerCase().endsWith(string)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

