/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.control.process.RootProcessName;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ResetConfigFileAction
extends AbstractSignerAction {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_NAME_KEY = "action.reset";
    private static final String INIT_FILE = "." + File.separator + "boreum.xml";

    protected ResetConfigFileAction(Component parent) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String message = Messages.getString(ACTION_NAME_KEY);
        LOG.info("{}...", (Object)message);
        this.resetFile();
        LOG.info("{} : done", (Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void resetFile() {
        ResetConfigFileAction.LOG.info("");
        documentInstance = Document.getInstance();
        message = Messages.getString("dialog.reset.question.message");
        ResetConfigFileAction.LOG.info("Dialog: {} ", (Object)message);
        doit = documentInstance.displayRedundantMessages(this.parent, "reset.question", 2, true);
        ResetConfigFileAction.LOG.info("Ausgew\u00e4hlt: {}", (Object)(doit == 0 ? "Ja" : "Nein"));
        initFileConfig = new File(ResetConfigFileAction.INIT_FILE);
        ResetConfigFileAction.LOG.debug("INIT_FILE : {}", (Object)initFileConfig.getAbsolutePath());
        if (doit != 0 && doit != 0) {
            return;
        }
        initFileStream = null;
        try {
            initFileStream = new FileInputStream(initFileConfig);
            config = Config.resetInstance();
            if (config.checkConfigFile(initFileStream)) {
                Utils.closeStream(initFileStream);
                ResetConfigFileAction.LOG.info("Installierte/Ausgelieferte Konfigurationdatei laden ...");
                initFileStream = new FileInputStream(initFileConfig);
                ResetConfigFileAction.LOG.trace("load init file in Config Instance ...");
                returnValue = config.load(initFileStream);
                Utils.closeStream(initFileStream);
                ResetConfigFileAction.LOG.trace("load init file in Config Instance: done.");
                ResetConfigFileAction.LOG.trace("resetProcesses ...");
                documentInstance.getProcessFactory().resetProcesses();
                if (documentInstance.getProcessFactory().getProcessChoose().getActiveProcess() != null) {
                    documentInstance.getProcessFactory().getProcessChoose().showProcess(documentInstance.getProcessFactory().getProcessChoose().getActiveProcess());
                } else if (documentInstance.isSaveConfig()) {
                    documentInstance.getProcessFactory().getProcessChoose().showProcess(RootProcessName.getInstance());
                }
                ResetConfigFileAction.LOG.trace("Zurueckgesetzte Config in Nutzerkonfiguration speichern...");
                config.storeDefault(true);
                documentInstance.getProcessFactory().setProperties(config.getProcessProperties());
                if (returnValue != null && returnValue.booleanValue()) {
                    ResetConfigFileAction.LOG.info("show error : reset.ready");
                    documentInstance.showMessageDialog(this.parent, "reset.ready");
                } else if (returnValue != null) {
                    ResetConfigFileAction.LOG.info("show error : reset.ready.error");
                    documentInstance.showMessageDialog(this.parent, "reset.ready.error");
                }
            } else {
                documentInstance.showMessageDialog(this.parent, "error.reset.xml");
            }
            ResetConfigFileAction.LOG.trace("Zur\u00fccksetzen ohne error : done");
        }
        catch (HeadlessException | IOException e) {
            try {
                message = Messages.getString("dialog.error.reset.message");
                ResetConfigFileAction.LOG.error("Dialog: {}", (Object)message);
                ResetConfigFileAction.LOG.error("show error : error.reset");
                documentInstance.displayErrorMessages(this.parent, "error.reset", e.toString());
            }
            catch (Throwable var8_9) {
                Utils.closeStream(initFileStream);
                if (Document.getInstance().getFrame() != null) {
                    Document.getInstance().getFrame().setSplashScreenVisible(false);
                }
                throw var8_9;
            }
            Utils.closeStream(initFileStream);
            if (Document.getInstance().getFrame() != null) {
                Document.getInstance().getFrame().setSplashScreenVisible(false);
            } else {
                ** GOTO lbl65
            }
        }
        Utils.closeStream(initFileStream);
        if (Document.getInstance().getFrame() != null) {
            Document.getInstance().getFrame().setSplashScreenVisible(false);
        }
        Config.getInstance().storeDefault();
        GUIUtils.updateFontSizeFromConfig();
    }
}

