/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.dialog.ResetCardWaitWindow;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.FrameworkStatus;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.formular.steps.SelectKeysFormular;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;

public class ResetCardAction
extends AbstractSignerAction {
    private static final String ACTION_NAME_KEY = "action.reset.card";
    private static final long serialVersionUID = 3471982482712100475L;

    ResetCardAction(Component parent) {
        super(ACTION_NAME_KEY, parent);
        this.setKeyAndIcon(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.reset();
    }

    public boolean reset() {
        ProcessFormular processFormular;
        LOG.info("ResetCardAction:BEGIN");
        Document documentInstance = Document.getInstance();
        FrameworkStatus.FrameworkState currentState = documentInstance.getCurrentFrameworkState();
        LOG.info("FrameworkState : {} -> initializing ", (Object)currentState);
        documentInstance.setCurrentFrameworkState(FrameworkStatus.FrameworkState.initializing);
        ResetCardWaitWindow waitWindow = null;
        if (Document.getInstance().getFrame() != null && Document.getInstance().getFrame().isVisible()) {
            waitWindow = new ResetCardWaitWindow((Component)documentInstance.getFrame());
            waitWindow.showWindow();
        }
        LOG.info("FrameworkState : {} -> {}", (Object)documentInstance.getCurrentFrameworkState(), (Object)currentState);
        documentInstance.setCurrentFrameworkState(currentState);
        ProcessI process = documentInstance.getProcessFactory().getProcess(documentInstance.getProcessFactory().getProcessChoose().getActiveProcess());
        if (process != null && (processFormular = process.getProcessFormular()) instanceof SelectKeysFormular) {
            SelectKeysFormular formular = (SelectKeysFormular)((Object)processFormular);
            this.removeKeyProviderFromFormular(formular, KeyUsage.SIGN);
            this.removeKeyProviderFromFormular(formular, KeyUsage.DECRYPT);
            this.removeKeyProviderFromFormular(formular, KeyUsage.ENCRYPT);
        }
        LOG.debug("ResetCardAction:reInitGUI: BEGIN");
        LocaleChanger.getInstance().setLocale(Config.getInstance().getLocale(), true);
        LOG.debug("ResetCardAction:reInitGUI: END");
        if (waitWindow != null) {
            waitWindow.closeWindow();
        }
        return true;
    }

    private void removeKeyProviderFromFormular(SelectKeysFormular formular, KeyUsage keyUsage) {
        LOG.trace("");
        List<KeyProvider> keyProvider = formular.getKeyProvider(keyUsage);
        if (keyProvider != null) {
            for (KeyProvider keyProvider2 : keyProvider) {
                formular.removeKeyProvider(keyProvider2, keyUsage);
            }
        }
    }
}

