/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.action;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.view.component.filechooser.FileChooserFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class LoadKeyStoreAction
extends AbstractSignerAction
implements Action {
    private static final long serialVersionUID = 1L;
    private static final String KEY_CERT = "action.loadcertificate";
    private static final String KEY_KEYSTORE = "action.loadkeystore";
    private transient SelectedFileHandler handler;
    private boolean loadPrivateKey;
    private boolean loadCertificate;

    protected LoadKeyStoreAction(Component parent, SelectedFileHandler handler, boolean loadPrivateKey, boolean loadCertificate) {
        super(loadCertificate ? KEY_CERT : KEY_KEYSTORE, parent);
        this.setKeyAndIcon(true);
        this.handler = handler;
        this.loadPrivateKey = loadPrivateKey;
        this.loadCertificate = loadCertificate;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = FileChooserFactory.createFileChooser(this.handler.getLastFolder());
        chooser.setPreferredSize(GUIUtils.createChooserDimension(this.parent));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                if (f.isDirectory()) {
                    return true;
                }
                if (LoadKeyStoreAction.this.loadCertificate && LoadKeyStoreAction.this.loadPrivateKey) {
                    return name.endsWith(".p12") || name.endsWith(".pfx") || name.endsWith(".cer") || name.endsWith(".crt");
                }
                if (LoadKeyStoreAction.this.loadCertificate) {
                    return name.endsWith(".cer") || name.endsWith(".crt");
                }
                return name.endsWith(".p12") || name.endsWith(".pfx");
            }

            @Override
            public String getDescription() {
                if (LoadKeyStoreAction.this.loadCertificate && LoadKeyStoreAction.this.loadPrivateKey) {
                    return "PKCS12-keystore and Certificates file (*.p12, *.pfx, *.cer, *.crt)";
                }
                if (LoadKeyStoreAction.this.loadCertificate) {
                    return "Certificate file (*.cer, *.crt)";
                }
                return "PKCS12-keystore file (*.p12, *.pfx)";
            }
        });
        String title = Messages.getString("step.selectcertificates.displayname");
        if (this.loadCertificate) {
            title = Messages.getString(KEY_CERT);
        }
        chooser.setDialogTitle(title);
        if (chooser.showDialog(this.parent, title) == 0) {
            this.handler.setFileToLoad(chooser.getSelectedFile());
        } else {
            this.handler.setFileToLoad(null);
        }
    }
}

